<?php



    /**
     * Add urls to admin top navigation
     */
    function systemAdminTopNavigation() {
        echo '<a target="_blank" href="'.getSiteUrl(false).'">'.lang('system_site').'</a>&nbsp;&nbsp;';
        echo '<a href="'.getSiteUrl(false).'admin/index.php?logout=do">'.lang('system_logout').'</a>';
    }
   
    
    /**
     * System plugin admin
     * @global $api_common common api file
     */
    function systemAdmin() {

        $plugins    = getPluginInfo();
        $components = getComponents();
        $filters    = getFilters();
        $hooks      = getHooks();
        
        $common_api_url = 'http://template-cms.ru/api/basic.xml';
        // Check if is exists common_api_url then try to force load only in system plugin area
        if(urlExists($common_api_url) and (isset($_GET['id']) && $_GET['id'] == 'system')) $api_common = getXML($common_api_url,true);

        // Check TEMPLATE CMS API
        // Сheck version
        if($api_common->TEMPLATE_CMS_VERSION_ID > TEMPLATE_CMS_VERSION_ID) {
            $old_cms_version_message = true;
        } else {
            $old_cms_version_message = false;
        }

        // Get system timezone
        $system_timezone = getSiteTimezone(false);

        // Get maintenance settings file
        $maintenance_xml = getXMLdb('../'.TEMPLATE_CMS_DATA_PATH.'system/maintenance.xml');

        // Get languages files
        $language_files = listOfFiles('../plugins/box/system/languages/', 'Lang.php');
        foreach($language_files as $language) {
            $languages_array[] = preg_replace('/(.*)-(.*)-(.*)/', '$2', $language);
        }

        // Get page files
        $page_files = listOfFiles('../data/pages/', '.xml');
        foreach($page_files as $page) {
            $page_xml = getXML('../data/pages/'.$page);
            if($page_xml != null) {
                if(trim($page_xml->slug) !== 'error404') {
                    $pages_array[] = trim($page_xml->slug);
                }
            }
        }

        if(isGet('sitemap')) {
            if('create' == get('sitemap')) {
                createSiteMap();           
                flashMessage(lang('system_sitemap_created'));
            }            
        }
        if(isGet('maintenance')) {
            if('on' == get('maintenance')) {                
                updateXMLRecord($maintenance_xml,'maintenance','1',array('status'=>'on'));
                redirect('index.php?id=system');
            }
            if('off' == get('maintenance')) {
                updateXMLRecord($maintenance_xml,'maintenance','1',array('status'=>'off'));
                redirect('index.php?id=system');
            }
        }

        // Edit main settings
        if(isPost('edit_main_settings')) {

            htmlPostText();

            // Prepare content before saving
            $content = '<?xml version="1.0" encoding="UTF-8"?>';
            $content .= '<root>';
            $content .= '<sitename>'.post('site_name').'</sitename>';
            $content .= '<description>'.post('site_description').'</description>';
            $content .= '<keywords>'.post('site_keywords').'</keywords>';
            $content .= '<slogan>'.post('site_slogan').'</slogan>';
            $content .= '<defaultpage>'.post('site_default_page').'</defaultpage>';
            $content .= '</root>';

            createFile('../'.TEMPLATE_CMS_DATA_PATH.'system/main.xml',$content);
            redirect('index.php?id=system');
        }

        // Edit system settings
        if(isPost('edit_system_settings')) {

            htmlPostText();
            
            // Prepare content before saving
            $content = '<?xml version="1.0" encoding="UTF-8"?>';
            $content .= '<root>';
            $content .= '<siteurl>'.post('system_url').'</siteurl>';
            $content .= '<timezone>'.post('system_timezone').'</timezone>';
            $content .= '<language>'.post('system_language').'</language>';
            $content .= '</root>';
            createFile('../'.TEMPLATE_CMS_DATA_PATH.'system/system.xml',$content);

            // Update maintenance db
            updateXMLRecord($maintenance_xml,'maintenance','1',array('message'=>toHtml(post('site_maintenance_message'))));
            
            redirect('index.php?id=system');
        }

        // Its mean that you can add your own actions for this plugin
        runHook('admin_system_extra_actions');

        // Include timezone-s
        include '../'.TEMPLATE_CMS_DATA_PATH.'system/timezone.php';

        $system_main_xml = getXML('../'.TEMPLATE_CMS_DATA_PATH.'system/main.xml');
        $system_system_xml = getXML('../'.TEMPLATE_CMS_DATA_PATH.'system/system.xml');

        // Display system template
        include 'templates/backend/SystemTemplate.php';
    }


    /**
     * Create sitemap
     */
    function createSitemap() {
        $pages_path = '../' . TEMPLATE_CMS_DATA_PATH . 'pages/';
        $pages_list = listFiles($pages_path,'.xml');

        $pages_array = array();

        $count = 0;
        foreach ($pages_list as $file) {

            // Get pages without error404.xml page
            if($file !== 'error404.xml') {
                $data = getXML($pages_path . $file);
                $pages_array[$count]['title'] = html_entity_decode($data->title, ENT_QUOTES, 'UTF-8');
                $pages_array[$count]['parent'] = $data->parent;
                $pages_array[$count]['date'] = $data->date;
                $pages_array[$count]['slug'] = $data->slug;

                if(isset($data->parent)) {
                    $c_p = $data->parent;
                } else {
                    $c_p = '';
                }

                if ($c_p != '') {
                    $parent_data = getXML($pages_path . $data->parent . '.xml');
                    if(isset($parent_data->title)) {
                        $parent_title = $parent_data->title;
                    } else {
                        $parent_title = '';
                    }
                    $pages_array[$count]['sort'] = $parent_title . ' ' . $data->title;
                } else {
                    $pages_array[$count]['sort'] = $data->title;
                }
                $parent_title = '';
                $count++;
            }
        }
        $pages = subval_sort($pages_array, 'sort');
        
        $map = '<?xml version="1.0" encoding="UTF-8"?>'."\n";
        $map .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">'."\n";
        foreach ($pages as $page) {
            if ($page['parent'] != '') {
                $parent = $page['parent'].'/';
            } else {
                $parent = '';
            }
            $map .= "\t".'<url>'."\n\t\t".'<loc>'.getSiteUrl(false).$parent.$page['slug'].'</loc>'."\n\t\t".'<lastmod>'.date("Y-m-d",(int)$page['date']).'</lastmod>'."\n\t\t".'<changefreq>weekly</changefreq>'."\n\t\t".'<priority>1.0</priority>'."\n\t".'</url>'."\n";
        }
        $map .= '</urlset>';
        createFile('../sitemap.xml',$map);
    }