<?php  if (!defined('TEMPLATE_CMS_ACCESS')) exit('No direct script access allowed');

    /**
     *	Preload module
     *	@package TemplateCMS
     *  @subpackage Engine
     *	@author Romanenko Sergey / Awilum
     *	@copyright 2011 Romanenko Sergey / Awilum
     *	@version $Id$
     *	@since 2.0
     *  @license http://opensource.org/licenses/gpl-license.php GNU Public License
     *  TemplateCMS is free software. This version may have been modified pursuant
     *  to the GNU General Public License, and as distributed it includes or
     *  is derivative of works licensed under the GNU General Public License or
     *  other free or open source software licenses.
     *  See COPYING.txt for copyright notices and details.
     *  @filesource
     */


    // Try to kill magic quotes
    @set_magic_quotes_runtime(0);

    // Gets the current configuration setting of magic_quotes_gpc
    // and kill magic quotes
    if (get_magic_quotes_gpc()) {
        function stripslashes_gpc(&$value) {
            $value = stripslashes($value);
        }
        array_walk_recursive($_GET, 'stripslashes_gpc');
        array_walk_recursive($_POST, 'stripslashes_gpc');
        array_walk_recursive($_COOKIE, 'stripslashes_gpc');
        array_walk_recursive($_REQUEST, 'stripslashes_gpc');
    }
      
    	
    // Preload main system variables from CORE/BOX PLUGINS
    // Main CMS files is system.xml, main.xml and theme.xml
	
    // Get system settings
    // Load system.xml
    global $site_url,$system_language,$system_timezone;
    $system_system_xml = getXML($admin_path.TEMPLATE_CMS_DATA_PATH.'system/system.xml');
    $site_url        = $system_system_xml->siteurl;
    $system_language = $system_system_xml->language;
    $system_timezone = $system_system_xml->timezone;
    unset($system_system_xml);
       
    // Get site settings
    // Load main.xml
    global $defpage,$system_site_name,$system_site_slogan,$system_site_title,$system_site_description,$system_site_keywords;
    $system_main_xml = getXML($admin_path.TEMPLATE_CMS_DATA_PATH.'system/main.xml');
    $defpage                 = $system_main_xml->defaultpage;   
    $system_site_name        = $system_main_xml->sitename;
    $system_site_description = $system_main_xml->description;
    $system_site_keywords    = $system_main_xml->keywords;
    $system_site_title       = $system_main_xml->title;
    $system_site_slogan      = $system_main_xml->slogan;
    unset($system_main_xml);

    // Get site theme
    // Load theme.xml
    global $current_theme;
    $theme_xml = getXML($admin_path.TEMPLATE_CMS_DATA_PATH.'themes/theme.xml');
    $current_theme = $theme_xml->theme_name;
    unset($theme_xml);
    
    // Set the default timezone used by all date/time functions
    if (function_exists('date_default_timezone_set')) {
        date_default_timezone_set($system_timezone);
    }