<?php

    /**
     *	NicEdit plugin
     *	@package TemplateCMS
     *  @subpackage Plugins
     *	@author Romanenko Sergey / Awilum
     *	@copyright 2011 Romanenko Sergey / Awilum
     *	@version 1.0
     *
     */


    // Register plugin
    registerPlugin( getPluginId(__FILE__),
                    getPluginFilename(__FILE__),
                    '<a href="#">NicEdit</a>|box',
                    '1.0',
                    'JavaScript WYSIWYG editor http://nicedit.com/',
                    'Awilum',
                    'http://awilum.webdevart.ru/',
                    '');


    // Add hooks
    addHook('admin_editor','editor',array());
    addHook('admin_editor_secondary','editor2',array());
    addHook('admin_header','editorHeaders');

    // Add new content filter
    addFilter('content', 'xhtmlCompliantOutput');


    /**
     * Some editors generates bad, non standards complient code
     * @param string $str string
     * @return string
     */
    function xhtmlCompliantOutput($str) {
        // XHTML Compliant Output  
        return strtr($str,array('<br>'         =>  '<br />',
                                'target=""'    =>  '',
                                'align="none"' =>  '',                
                                '<hr>'         =>  '<hr />'));

    }

    /**
     * Render editor
     * @param string $val editor data
     */
    function editor($val=null) {        
        echo '<div id="editor_panel" style="width: 800px;"></div>';
        echo '<textarea style="width: 800px; height:350px;" id="editor_area" name="editor" >'.$val.'</textarea>';
    }

    /**
     * Render secondary editor
     * @param string $val editor data
     */	
    function editor2($val=null) {        
        echo '<div id="editor_panel2" style="width: 800px;"></div>';
        echo '<textarea style="width: 800px; height:200px;" id="editor_area2" name="editor_secondary" >'.$val.'</textarea>';
    }

    /**
     * Set editor headers
     */
    function editorHeaders() {                
        echo '
        <script type="text/javascript" src="'.getSiteUrl(false).'plugins/box/nicedit/nicedit/nicEdit.js"></script>
        <script type="text/javascript">
                 bkLib.onDomLoaded(function() {
                          var myNicEditor = new nicEditor({fullPanel : true});
                          myNicEditor.setPanel("editor_panel");
                          myNicEditor.addInstance("editor_area");						  
						  
						  var myNicEditor2 = new nicEditor({fullPanel : true});
                          myNicEditor2.setPanel("editor_panel2");
                          myNicEditor2.addInstance("editor_area2");						  
                 });				
        </script>
        ';
    }