<?php  if (!defined('TEMPLATE_CMS_ACCESS')) exit('No direct script access allowed');

    /**
     *	Filesystem module
     *	@package TemplateCMS
     *  @subpackage Engine
     *	@author Romanenko Sergey / Awilum
     *	@copyright 2011 Romanenko Sergey / Awilum
     *	@version $Id$
     *	@since 2.0
     *  @license http://opensource.org/licenses/gpl-license.php GNU Public License
     *  TemplateCMS is free software. This version may have been modified pursuant
     *  to the GNU General Public License, and as distributed it includes or
     *  is derivative of works licensed under the GNU General Public License or
     *  other free or open source software licenses.
     *  See COPYING.txt for copyright notices and details.
     *  @filesource 
     */
	 

     /**
      * Get list of files in directory (1 level)
      * @param string $dir Directory to scan
      * @param mixed $type Files types
      * @return boolean
      */
     function listFiles($dir, $type=null) {
        $files = array();
        if(is_dir($dir)) {
        $dir = opendir ($dir);
            while (false !== ($file = readdir($dir))) {                
                if(is_array($type)) {    
                    $file_ext = substr(strrchr($file, '.'), 1);                                     
                    if(in_array($file_ext, $type)) {
                        if (strpos($file, $file_ext, 1)) { 
                            $files[] = $file;
                        }                          
                    }
                } else {
                    if(($file !=".") && ($file !="..")) {
                        if(isset($type)) {
                            if (strpos($file, $type, 1)) {
                                $files[] = $file;
                            }
                        } else {
                            $files[] = $file;
                        }
                    }
                }
            }
            closedir($dir);
            return $files;
        } else {
            return false;
        }
     }

     /**
      * Get list of files in directory recursive
      * @param string $folder Folder
      * @param mixed $type Files types
      * @return array
      */
     function listOfFiles($folder, $type=null) {
        $data = array();
        if(is_dir($folder)) {
            $iterator = new RecursiveDirectoryIterator($folder);
            foreach(new RecursiveIteratorIterator($iterator) as $file) {            
                if(is_array($type)) {    
                    $file_ext = substr(strrchr($file->getFilename(), '.'), 1);                                     
                    if(in_array($file_ext, $type)) {                                                       
                        if (strpos($file->getFilename(), $file_ext, 1)) {                        
                            $data[] = $file->getFilename();
                        }                                
                    }
                } else {
                    if (strpos($file->getFilename(), $type, 1)) {
                        $data[] = $file->getFilename();
                    }
                }
            }
            return $data;
        } else {
            return false;
        }        
     }

    /**
     * Returns true if the File exists.
     * @param string $filename The file name
     * @return boolean
     */
    function fileExists($filename) {
       return (file_exists($filename) && is_file($filename)); 
    }

     /**
      * Create new file
      * @param string $filename The file name
      * @param string $content Content to save
      * @param string $old_filename Old filename turn on rename mod
      * @return boolean
      */
    function createFile($filename, $content, $old_filename=null) {
        
        $space = '-';
		$dir_name = dirname($filename);

		// Rename mod
        if(!empty($old_filename)) {
            $new_cl_space = str_replace(" ", $space, $filename);
            $new = translitIt($new_cl_space);
            if($old_filename !== $new) {
                rename($old_filename,$new);
                $save_filename = $filename;
            } else {
                $save_filename = $filename;
            }                            
        } else {
            $save_filename = $filename;
        }
                
        // Create safe filename        
        $save_cl_space = str_replace(" ", $space, $save_filename);
        $save_file_name = translitIt($save_cl_space);
        
        // Check that the folder exists and is writable
        if (!is_dir($dir_name))      return false;
        if (!is_writable($dir_name)) return false;
        
        // Write file
        return file_put_contents($save_file_name, $content, LOCK_EX);              
    }

     /**
      * Delete current file
      * @param string $filename The file name
      * @return boolean
      */
    function deleteFile($filename) {
        if (!is_dir($filename)) {
            return unlink($filename);
        }
        return false;
    }

    /**
     * Rename file
     * @param string $from Original file location
     * @param string $to Desitination location of the file
     * @return boolean
     */
    function renameFile($from, $to) {
        if (!fileExists($to)) {
            return rename($from, $to);
        }
        return false;
    }

    /**
     * Load file if exists
     * @param $filename The file name
     * @return boolean
     */
    function loadFile($filename) {
        if(fileExists($filename)) {
            return file_get_contents($filename);
        }
    }

    /**
     * Copy file
     * @param string $from Original file location
     * @param string $to Desitination location of the file
     * @return boolean
     */
    function copyFile($from, $to) {
        if (!fileExists($from) || fileExists($to)) {
            return false;
        }
        return copy($from, $to);
    }

    /**
     * Get time(in Unix timestamp) the file was last changed 
     * @param string $filename The file name
     * @return boolean
     */    
    function fileLastChange($filename) {
        if (fileExists($filename)) {
            return filemtime($filename);
        }
        return false;
    }   

    /**
     * Get last access time
     * @param string $filename The file name
     * @return boolean
     */
    function fileLastAccess($filename) {
        if (fileExists($filename)) {
            return fileatime($filename);
        }
        return false;              
    }

    /**
     * Get the File extension.
     * @param string $filename The file name
     * @return string
     */
    function fileExt($filename){
        return substr(strrchr($filename, '.'), 1);
    }

    /**
     * Get the File name
     * @param string $filename The file name
     * @return string
     */
    function fileName($filename) {
        return basename($filename,'.'.fileExt($filename));
    }

    /**
     * Creates a directory
     * @param string $dir Name of directory to create
     * @return boolean
     */
    function createDir($dir) {		
        if (is_dir($dir)) {
            return false;
        }
        return mkdir($dir, 0775);
    }

    /**
     * Delete directory
     * @param string $dir Name of directory to delete
     */
     function deleteDir($dir) { 
        if (is_dir($dir)) { 
            $objects = scandir($dir); 
            foreach ($objects as $object) { 
                if ($object != '.' && $object != '..') { 
                    if (filetype($dir.'/'.$object) == 'dir') {
                        deleteDir($dir.'/'.$object);     
                    } else {
                        unlink($dir.'/'.$object);    
                    }
                } 
            } 
            reset($objects); 
            rmdir($dir); 
        } 
     } 

    /**
     * Check dir permission
     * @param string $dir Directory to check
     * @return string
     */
    function checkDirPerm($dir) {
        clearstatcache();
        return substr(sprintf('%o', fileperms($dir)), -4);
    }

    /**
     * Get list of directories
     * @param string $dir Directory
     */
    function listOfDirs($dir){        
        $ignored_directory[] = '.'; 
        $ignored_directory[] = '..';
        if (is_dir($dir)){
            if ($dir_handle = opendir($dir)){
                while (($directory = readdir($dir_handle)) !== false){
                    if (!(array_search($directory,$ignored_directory) > -1)){
                        if (filetype($dir.$directory) == "dir"){
                            $directory_list[] = $directory;
                        }
                    }
                }
            closedir($dir_handle);
            }
        }
        return($directory_list);
    }
