<?php

    /**
     *	Main CMS module
     *	@package TemplateCMS 
     *	@author Romanenko Sergey / Awilum
     *	@copyright 2011 Romanenko Sergey / Awilum
     *	@version $Id$
     *	@since 2.0
     *  @license http://opensource.org/licenses/gpl-license.php GNU Public License
     *  TemplateCMS is free software. This version may have been modified pursuant
     *  to the GNU General Public License, and as distributed it includes or
     *  is derivative of works licensed under the GNU General Public License or
     *  other free or open source software licenses.
     *  See COPYING.txt for copyright notices and details.
     */

    // First check for installer then go
    if(file_exists('install.php')) {
        if(isset($_GET['install'])) {
            if($_GET['install'] == 'done') {
                // Try to delete install file if not delete manually
                @unlink('install.php');
                // Redirect to main page
                header('location: index.php');
            }
        } else {            
            include 'install.php';
        }
    } else {

        // Start system timer
        $start_time = microtime(true);

        // Initialize session 
        session_start();

        // Set admin path false
        $admin = FALSE;

        // Set TemplateCMS access
        define('TEMPLATE_CMS_ACCESS',true);

        // Include engine core
        include 'template_cms/Core.php';       

        // Check for maintenance mod
        $maintenance_xml = getXML(TEMPLATE_CMS_DATA_PATH.'system/maintenance.xml');        
        if('on' == $maintenance_xml->maintenance->status) {  
            // Set maintenance mode for all except admin        
            if(!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
                die($maintenance_xml->maintenance->message);        
            }
        }        

        // Display template
        loadTemplate('themes/'.getSiteTheme(false).'/'.getTemplate().'Template.php');        

        // Flush (send) the output buffer and turn off output buffering
        ob_end_flush();
        
    }