<?php


    /**
     * Blocks admin function
     */
    function blocksAdmin() {

        // Init vars
        $blocks_path = '../' . TEMPLATE_CMS_DATA_PATH . 'blocks/';
        $blocks_list = array();
        $errors = array();
        
        // Check for get actions
        if (isGet('action')) {
            // Switch actions
            switch (get('action')) {
                case "add_block":
                    if(isPost('add_blocks')) {
                        if(trim(post('blocks_editor_name')) == '') $errors['blocks_empty_name'] = lang('themes_empty_field');
                        if(count($errors) == 0) {                            
                            createFile($blocks_path.safeName(post('blocks_editor_name')).'.php', post('blocks_editor'));
                            redirect('index.php?id=themes&sub_id=blocks');
                        }
                    }
                    // Save fields
                    if(isPost('blocks_editor_name')) $post_name = post('blocks_editor_name'); else $post_name = '';
                    if(isPost('blocks_editor')) $blocks_data = post('blocks_editor'); else $blocks_data = '';
                    include 'templates/backend/BlocksAddTemplate.php';
                break;
                case "edit_block":
                    // Edit current block
                    if(isPost('edit_blocks')) {
                        if(trim(post('blocks_editor_name')) == '') $errors['blocks_empty_name'] = lang('themes_empty_field');
                        // Save fields
                        if(isPost('blocks_editor')) $blocks_data = post('blocks_editor'); else $blocks_data = '';
                        if(count($errors) == 0) {
                            createFile($blocks_path.safeName(post('blocks_editor_name')).'.php', post('blocks_editor'), $blocks_path.post('blocks_old_name').'.php');
                            redirect('index.php?id=themes&sub_id=blocks');
                        }
                    }
                    if(isPost('blocks_editor_name')) $post_name = post('blocks_editor_name'); else $post_name = fileName(get('filename'));
                    $blocks_data = loadFile($blocks_path.get('filename').'.php');                    
                    include 'templates/backend/BlocksEditTemplate.php';
                break;
                case "delete_block":
                    deleteFile($blocks_path.get('filename'));
                    redirect('index.php?id=themes&sub_id=blocks');
                break;
            }
        } else {
            // Display template for all blocks
            $blocks_list = listFiles($blocks_path,'.php');
            include 'templates/backend/BlocksTemplate.php';
        }
    }