<?php


    // Add hooks
    addHook('admin_pages_second_navigation','adminSecondNavigation',array('pages',lang('filesmanager_submenu'),'filesmanager'));
    addHook('admin_header','filesmanagerHeaders');
	
    /**
     * Files manager headers
     */
    function filesmanagerHeaders() {
        echo '
                <style type="text/css">
                    .filesmanager-main {
                        color:#737373;
                        float:left;
                        width:600px;
                    }

                    .filesmanager-tr {
                        border-bottom:1px solid #f2f2f2;
                    }

                    .filesmanager-tr:hover {
                        background:#FBF4DF;
                    }

                    .filesmanager-td {
                        padding-left:5px;
                        padding-right:5px;
                        padding-top:5px;
                        padding-bottom:5px;
                    }

                    #filesmanager-upload {
                        border:1px solid #DDD;
                        float:right;
                        margin-left:20px;
                        padding:10px 20px;
                        width:250px;
                    }

                    input.file {
                        position: relative;
                        text-align: right;
                        -moz-opacity:0 ;
                        filter:alpha(opacity: 0);
                        opacity: 0;
                        z-index: 2;
                    }
                    .file-ext {
                        -moz-border-radius:3px;
                        -webkit-border-radius:3px;
                        background:#F2F2F2;
                        border-radius:3px;
                        border: 1px solid #ccc;
                        color:#4E4131;
                        font-weight:bold;
                        padding:10px;
                        text-align:center;
                        line-height:10px;
                    }
                    .file-ext:hover {
                        background:#E5DED7;
                        color:#000;
                    }
                </style>
            ';
    }
    

    /**
     * Filesmanager admin function
     */
    function filesmanagerAdmin() {

        // Array of forbidden types
        $forbidden_types = array('php','htaccess','html','htm');        

        // Get Site url
        $site_url = getSiteUrl(false);

        // Init vars
        $files_path = '../'.TEMPLATE_CMS_DATA_PATH.'files/';
        $files_list = array();
        $files_list = listFiles($files_path);

        // Delete file
        if(get('sub_id') == 'filesmanager') {
            if(get('delete_file')) {
                deleteFile($files_path.get('delete_file'));
                redirect($site_url.'admin/index.php?id=pages&sub_id=filesmanager');
            }
        }

        // Upload file
        if(isPost('upload_file')) {
            if ($_FILES['file']) {
                if(!in_array(fileExt($_FILES['file']['name']),$forbidden_types)) {
                    move_uploaded_file($_FILES['file']['tmp_name'],$files_path.translitIt($_FILES['file']['name']));
                    redirect($site_url.'admin/index.php?id=pages&sub_id=filesmanager');                    
                }
            }
        }

        // Display Files manager template
        include 'templates/backend/FilesmanagerTemplate.php';
    }