<?php

/*
	@author: Plato
	@modified: Artas
	@package: PerfCMS
	@year: 2012
*/
class Lang
	{
	public $languages = array();
	public $cache = 0;
	public $language = 'en';
	public $data = array();

	public function __construct() {

		$this->get_languages();
		global $settings;
		global $system;

		// if ($_SESSION['lang']) {
			// $this->set_language($_SESSION['lang']);
		// }
		// elseif ($_COOKIE['lang']) {
			// $this->set_language($_COOKIE['lang']);
		// } 
		// else
		if ($settings['lang']) {
			$this->set_language($settings['lang']);
		}
		else {
			$this->set_language($system['lang']);
		}

		@define('LANGUAGE', $this->language);


		$dir = opendir(SYS .'/lang/'. $this->language);

		while ($file = readdir($dir)) {
			if ($file == '.' OR $file == '..' OR $file == 'lang.ini') continue;

			$data = include_once SYS .'/lang/'. $this->language .'/' . $file;


			$this->data = array_merge($this->data, $data);
		}
	}


	public function get_browser_language() {
		if ( ! $_SERVER['HTTP_ACCEPT_LANGUAGE']) return 'en';


		$language = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);


		if ( ! in_array($language, array_keys($this->languages))) {
			$language = 'en';
		}

		return $language;
	}


	public function set_language($language) {

		if ( ! in_array($language, array_keys($this->languages))) {
			$language = $this->get_browser_language();
		}


		$this->language = $language;

		$_SESSION['lang'] = $language;
		$_COOKIE['lang'] = $language;
	}



	public function word($key) {
		if (empty($this->data[$key])) $data = $key;
		else $data = $this->data[$key];

		if (is_string($key)) {

			$lgr = parse_ini_file(SYS .'/lang/'. $this->language .'/lang.ini');
			$data = $lgr[$key];
		}

		return $data;
	}


	protected function get_languages() {
		$dir = opendir(SYS .'/lang');

		while ($lang = readdir($dir)) {

			if ( ! file_exists(SYS .'/lang/'. $lang .'/lang.ini')) continue;


			$config = parse_ini_file(SYS .'/lang/'. $lang .'/lang.ini');

			if (empty($config['name'])) continue;

			$this->languages = array_merge($this->languages, array($lang => $config['name']));
		}
	}
}