<?php
/**********************************
*	@package: PerfCMS			  *
*	@year: 2012					  *
*	@author: Artas				  *
*	@link: http://perfcms.ru	  *
**********************************/
function display_error($content) {
	echo "<div class=\"error\">{$content}</div>\n";
	}

function go($link) {
	header('location: '.$link);
	exit;
	}
	
function cget($var) {
	return htmlspecialchars(trim($var));
	}
	
function escape($inp)
	{ 
     if(is_array($inp)) 
         return array_map(__METHOD__, $inp); 

     if(!empty($inp) && is_string($inp)) { 
         return str_replace(array('\\', "\0", "\n", "\r", "'", '"', "\x1a"), array('\\', '\0', '\n', '\r', "\'", '\"', '\Z'), $inp); 
     } 

     return $inp; 
	}
	
	
function rtime($var) {
	require_once(SYS.'/classes/lang.php');
	global $lang;
    if ($var == NULL) { 
		$var = time();
	}
    $real_time = date('d.m.Y '.$lang->word('time_in').' H:i', $var);
    $date = date('d.m.Y', $var);
    $time = date('H:i', $var);

    if ($date == date('d.m.Y')) {
		$real_time = date(''.$lang->word('today').' '.$lang->word('time_in').' H:i', $var);
	}
    if ($date == date('d.m.Y', time()-60*60*24)) {
		$real_time = date(''.$lang->word('yesterday').' '.$lang->word('time_in').' H:i', $var);
    }
    return $real_time;
	}
	
function input($var) {
	return escape(htmlspecialchars($var, ENT_QUOTES));
	}
	
function output($var) {
	return smiles(tags(nl2br($var)));
	}
	
function crypto($var) {
	return md5(base64_encode($var) .'_PerfCMS_');
	}

function highlight($code) 
	{ 
		$code = strtr($code, array (
        '<br />' => '',
        '\\' => 'slash'
		));
		$code = html_entity_decode($code, ENT_QUOTES, 'UTF-8');
		$code = stripslashes($code); 
		if(!strpos($code,"<?") && substr($code,0,2)!="<?") {
			$code="<?php\n".trim($code)."\n?>"; 
		}  
		$code = trim($code); 
		$code = highlight_string($code,true);
		$code = strtr($code, array (
        'slash' => '&#92;',
        ':' => '&#58;',
        '[' => '&#91;',
        '&nbsp;' => ' '
		));
		return '<div class="code">'.$code.'</div>';
	} 
	

function tags($var){
	global $system;
	$var = preg_replace(array ('#\[code\](.*?)\[\/code\]#se'), array ("''.highlight('$1').''"), str_replace("]\n", "]", $var));
	if($system['bb_b'] == 'on') { $var = preg_replace('/\[b\](.+)\[\/b\]/isU', '<b>$1</b>', $var); }
    if($system['bb_u'] == 'on') { $var = preg_replace('/\[u\](.+)\[\/u\]/isU', '<span style="text-decoration:underline;">$1</span>', $var); }
    if($system['bb_s'] == 'on') { $var = preg_replace('/\[s\](.+)\[\/s\]/isU', '<s>$1</s>', $var); }
    if($system['bb_i'] == 'on') { $var = preg_replace('/\[i\](.+)\[\/i\]/isU', '<i>$1</i>', $var); }
    if($system['bb_big'] == 'on') { $var = preg_replace('/\[big\](.+)\[\/big\]/isU', '<span style="font-size:large;">$1</span>', $var); }
    if($system['bb_small'] == 'on') { $var = preg_replace('/\[small\](.+)\[\/small\]/isU', '<span style="font-size:small;">$1</span>', $var); }
    if($system['bb_red'] == 'on') { $var = preg_replace('/\[red\](.+)\[\/red\]/isU', '<span style="color:#ff0000;">$1</span>', $var); }
    if($system['bb_yellow'] == 'on') { $var = preg_replace('/\[yellow\](.+)\[\/yellow\]/isU', '<span style="color:#ffff22;">$1</span>', $var); }
    if($system['bb_green'] == 'on') { $var = preg_replace('/\[green\](.+)\[\/green\]/isU', '<span style="color:#00bb00;">$1</span>', $var); }
    if($system['bb_blue'] == 'on') { $var = preg_replace('/\[blue\](.+)\[\/blue\]/isU', '<span style="color:#0000bb;">$1</span>', $var); }
    if($system['bb_color'] == 'on') { $var = preg_replace('/\[color=(.+)\](.+)\[\/color\]/isU', '<span style="color:$1;">$2</span>', $var); }
    if($system['bb_quote'] == 'on') { $var = preg_replace('/\[quote\](.+)\[\/quote\]/isU', '<div class="quote">$1</div>', $var); }
    if($system['bb_size'] == 'on') { $var = preg_replace('/\[size=([0-9]+)\](.+)\[\/size\]/isU', '<span style="font-size:$1px;">$2</span>', $var); }
	$var = preg_replace("/(https?|ftps?)\:\/\/([a-z0-9\.\/\-\#\?\_\!\=&;]*)\b/i", "<a href=\"$1://$2\" target=\"_blank\">$1://$2</a>", $var);
	$var = preg_replace("/([a-z0-9\.\-\_]*)\@([a-z0-9\.\-]*)\.([a-z]*)\b/i", '<a href="mailto:$1@$2.$3">$1@$2.$3</a>', $var);
	return $var;
	}

function smiles($var) {
	$var = preg_replace('/\:\)|:-\)|:smile:/', '<img src="/template/smiles/smiley-smile.png" alt="Smile" />', $var);
	$var = preg_replace('/:D|:-D/', '<img src="/template/smiles/smiley-grin.png" alt="Smile" />', $var);
	$var = preg_replace('/\:\(|:-\(/', '<img src="/template/smiles/smiley-sad.png" alt="Smile" />', $var);
	$var = preg_replace('/\;-\(|\;\(/', '<img src="/template/smiles/smiley-cry.png" alt="Smile" />', $var);
	$var = preg_replace('/\;\)|\;-\)/', '<img src="/template/smiles/smiley-wink.png" alt="Smile" />', $var);
	$var = preg_replace('/8\)|8-\)/', '<img src="/template/smiles/smiley-cool.png" alt="Smile" />', $var);
	$var = preg_replace('/=O|O_O/', '<img src="/template/smiles/smiley-eek.png" alt="Smile" />', $var);
	$var = str_replace('$)', '<img src="/template/smiles/smiley-money.png" alt="Smile" />', $var);
	$var = str_replace(':*', '<img src="/template/smiles/smiley-kiss.png" alt="Smile" />', $var);
	$var = preg_replace('/:P/', '<img src="/template/smiles/smiley-razz.png" alt="Smile" />', $var);
	$var = str_replace(':|', '<img src="/template/smiles/smiley-netural.png" alt="Smile" />', $var);
	$var = preg_replace('/:Z/', '<img src="/template/smiles/smiley-sleep.png" alt="Smile" />', $var);
	$var = preg_replace('/:lol:/', '<img src="/template/smiles/smiley-lol.png" alt="Smile" />', $var);
	$var = preg_replace('/:rofl:/', '<img src="/template/smiles/smiley-yell.png" alt="Smile" />', $var);
	$var = str_replace(':&', '<img src="/template/smiles/smiley-confuse.png" alt="Smile" />', $var);
	$var = str_replace(':>', '<img src="/template/smiles/smiley-evil.png" alt="Smile" />', $var);
	$var = str_replace(':@', '<img src="/template/smiles/smiley-mad.png" alt="Smile" />', $var);
	$var = preg_replace('/:angel:/', '<img src="/template/smiles/smiley-angel.png" alt="Smile" />', $var);
	$var = preg_replace('/:bla:/', '<img src="/template/smiles/smiley-draw.png" alt="Smile" />', $var);
	$var = preg_replace('/:fat:/', '<img src="/template/smiles/smiley-fat.png" alt="Smile" />', $var);
	$var = preg_replace('/:kitty:/', '<img src="/template/smiles/smiley-kitty.png" alt="Smile" />', $var);
	$var = preg_replace('/:green:/', '<img src="/template/smiles/smiley-mr-green.png" alt="Smile" />', $var);
	$var = str_replace('%)', '<img src="/template/smiles/smiley-nerd.png" alt="Smile" />', $var);
	$var = preg_replace('/:red:/', '<img src="/template/smiles/smiley-red.png" alt="Smile" />', $var);
	$var = preg_replace('/:roll:/', '<img src="/template/smiles/smiley-roll.png" alt="Smile" />', $var);
	$var = preg_replace('/:sweat:/', '<img src="/template/smiles/smiley-sweat.png" alt="Smile" />', $var);
	$var = preg_replace('/:slim:/', '<img src="/template/smiles/smiley-slim.png" alt="Smile" />', $var);
	$var = preg_replace('/:surprise:/', '<img src="/template/smiles/smiley-surprise.png" alt="Smile" />', $var);
	$var = str_replace('<)', '<img src="/template/smiles/smiley-twist.png" alt="Smile" />', $var);
	$var = str_replace(':]', '<img src="/template/smiles/smiley-zipper.png" alt="Smile" />', $var);
	return $var;
	}
	
function browser_type() {
		$useragent	=	$_SERVER['HTTP_USER_AGENT'];
		if(preg_match('/android|avantgo|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|msie|mmp|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i',$useragent)||preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|e\-|e\/|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(di|rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|xda(\-|2|g)|yas\-|your|zeto|zte\-/i',substr($useragent,0,4)))
			{
				return 'wap';
			}
		else {
				return 'web';
			}
		}
	
	function subtok($string,$chr,$pos,$len = NULL) {
	return implode($chr,array_slice(explode($chr,$string),$pos,$len));
	}
	
function browser($agent) {

    if(empty($agent)) { $agent = $_SERVER['HTTP_USER_AGENT']; }

    if (stripos($agent, 'Avant Browser') !== false) {
      return 'Avant Browser';
    } elseif (stripos($agent, 'Acoo Browser') !== false) {
      return 'Acoo Browser';
    } elseif (stripos($agent, 'MyIE2') !== false) {
      return 'MyIE2';
    } elseif (preg_match('|Iron/([0-9a-z\.]*)|i', $agent, $pocket)) {
      return 'SRWare Iron ' . subtok($pocket[1], '.', 0, 2);
    } elseif (preg_match('|Chrome/([0-9a-z\.]*)|i', $agent, $pocket)) {
      return 'Chrome ' . subtok($pocket[1], '.', 0, 3);
    } elseif (preg_match('#(Maxthon|NetCaptor)( [0-9a-z\.]*)?#i', $agent, $pocket)) {
      return $pocket[1] . $pocket[2];
    } elseif (stripos($agent, 'Safari') !== false && preg_match('|Version/([0-9]{1,2}.[0-9]{1,2})|i', $agent, $pocket)) {
      return 'Safari ' . subtok($pocket[1], '.', 0, 3);
    } elseif (preg_match('#(NetFront|K-Meleon|Netscape|Galeon|Epiphany|Konqueror|Safari|Opera Mini|Opera Mobile/Opera Mobi)/([0-9a-z\.]*)#i', $agent, $pocket)) {
      return $pocket[1] . ' ' . subtok($pocket[2], '.', 0, 2);
    } elseif (stripos($agent, 'Opera') !== false && preg_match('|Version/([0-9]{1,2}.[0-9]{1,2})|i', $agent, $pocket)) {
      return 'Opera ' . $pocket[1];
    } elseif (preg_match('|Opera[/ ]([0-9a-z\.]*)|i', $agent, $pocket)) {
      return 'Opera ' . subtok($pocket[1], '.', 0, 2);
    } elseif (preg_match('|Orca/([ 0-9a-z\.]*)|i', $agent, $pocket)) {
      return 'Orca ' . subtok($pocket[1], '.', 0, 2);
    } elseif (preg_match('#(SeaMonkey|Firefox|GranParadiso|Minefield|Shiretoko)/([0-9a-z\.]*)#i', $agent, $pocket)) {
      return $pocket[1] . ' ' . subtok($pocket[2], '.', 0, 3);
    } elseif (preg_match('|rv:([0-9a-z\.]*)|i', $agent, $pocket) && strpos($agent, 'Mozilla/') !== false) {
      return 'Mozilla ' . subtok($pocket[1], '.', 0, 2);
    } elseif (preg_match('|Lynx/([0-9a-z\.]*)|i', $agent, $pocket)) {
      return 'Lynx ' . subtok($pocket[1], '.', 0, 2);
    } elseif (preg_match('|MSIE ([0-9a-z\.]*)|i', $agent, $pocket)) {
      return 'IE ' . subtok($pocket[1], '.', 0, 2);
    } elseif (preg_match('|Googlebot/([0-9a-z\.]*)|i', $agent, $pocket)) {
      return 'Google Bot ' . subtok($pocket[1], '/', 0, 2);
    } elseif (preg_match('|Yandex|i', $agent)) {
      return 'Yandex Bot ';
    } elseif (preg_match('|Nokia([0-9a-z\.\-\_]*)|i', $agent, $pocket)) {
      return 'Nokia '.$pocket[1];
    } else {
      $agent = preg_replace('|http://|i', '', $agent);
      $agent = strtok($agent, '/ ');
      $agent = substr($agent, 0, 22);
      $agent = subtok($agent, '.', 0, 2);

      if (!empty($agent)) {
        return $agent;
      } 
    } 
	return 'Unknown';
	}
	
	function img($name) {
	return '<img src="/template/icons/'. $name .'" alt="Icon" /> ';
	}
	
	function nick($user_id) {
	global $db;
	if($db->query("SELECT * FROM `users` WHERE `id` = '". $user_id ."'")->rowCount() == 1) {
	$us = $db->query("SELECT * FROM `users` WHERE `id` = '". $user_id ."'")->fetch();
	if($us['time'] > (time()-300)) { $on = img('on.png'); } else { $on = img('off.png'); }
	return img($us['gender'].'.png') .' <a href="/user/'. $us['id'] .'/">'.($us['level'] >=6 ? '<span class="red">'.$us['nick'].'</span>' : ($us['level'] >= 2 && $us['level'] <= 5 ? '<span style="color:#22b14c;">'.$us['nick'].'</span>' : $us['nick'])) .'</a> '. $on;
	} else {
		return 'User Not Exists';
	}
	}
	
	function tnick($user_id) {
	global $db;
	if($db->query("SELECT * FROM `users` WHERE `id` = '". $user_id ."'")->rowCount() == 1) {
	$us = $db->query("SELECT * FROM `users` WHERE `id` = '". $user_id ."'")->fetch();
	return  $us['nick'];
	} else {
		return 'User Not Exists';
	}
	}
	
	function avatar($user_nick) {
		if(file_exists(ROOT .'/files/avatars/'. $user_nick .'.png')) {
			return '<img src="/files/avatars/'. $user_nick .'.png" alt="'. $user_nick .'" /><br/>';
		}
		else {
			return '<img src="/files/preview/no_photo.png" alt="No photo" /><br/>';
		}
	}


  function cyrlat($cyr_str) {
   $tr = array(
   "Ґ"=>"G","Ё"=>"YO","Є"=>"E","Ї"=>"YI","І"=>"I",
   "і"=>"i","ґ"=>"g","ё"=>"yo","№"=>"","є"=>"e",
   "ї"=>"yi","А"=>"A","Б"=>"B","В"=>"V","Г"=>"G",
   "Д"=>"D","Е"=>"E","Ж"=>"ZH","З"=>"Z","И"=>"I",
   "Й"=>"Y","К"=>"K","Л"=>"L","М"=>"M","Н"=>"N",
   "О"=>"O","П"=>"P","Р"=>"R","С"=>"S","Т"=>"T",
   "У"=>"U","Ф"=>"F","Х"=>"H","Ц"=>"TS","Ч"=>"CH",
   "Ш"=>"SH","Щ"=>"SCH","Ъ"=>"'","Ы"=>"YI","Ь"=>"",
   "Э"=>"E","Ю"=>"YU","Я"=>"YA","а"=>"a","б"=>"b",
   "в"=>"v","г"=>"g","д"=>"d","е"=>"e","ж"=>"zh",
   "з"=>"z","и"=>"i","й"=>"y","к"=>"k","л"=>"l",
   "м"=>"m","н"=>"n","о"=>"o","п"=>"p","р"=>"r",
   "с"=>"s","т"=>"t","у"=>"u","ф"=>"f","х"=>"h",
   "ц"=>"ts","ч"=>"ch","ш"=>"sh","щ"=>"sch","ъ"=>"",
   "ы"=>"yi","ь"=>"","э"=>"e","ю"=>"yu","я"=>"ya",
   " "=>"-", "_"=>"-", "~"=>"-", "`" => "", "!"=>"",
   "@"=>"-", "#"=>"", "$"=>"", "%"=>"", "^"=>"",
   "&"=>"", "*"=>"", "("=>"", ")"=>"", "+"=>"-",
   "\\"=>"", "="=>"-", ";"=>"", ":"=>"", "?"=>"",
   "<"=>"", ">"=>"",","=>"", "."=>"", "'"=>''
  );
   return strtolower(strtr($cyr_str,$tr));
  }
function size($var) {
  if ($var >= 1073741824) return round($var/1073741824, 2) .' Gb';
  else if ($var >= 1048576) return round($var/1048576, 2) .' Mb';
  elseif($var >= 1024) return round($var/1024, 2) .' Kb';
  else return round($var) .' b';
}

function user_level($user_id) {
	global $db;
	if($db->query("SELECT * FROM `users` WHERE `id` = '$user_id'")->rowCount() == 1)
		{
			$level = $db->query("SELECT level FROM `users` WHERE `id` = '$user_id'")->fetchColumn();
			if($level == 1) {
			return 'User';
			} elseif($level == 2) {
			return 'ChatMod';
			} elseif($level == 3) {
			return 'ForumMod';
			} elseif($level == 4) {
			return 'ShareMod';
			} elseif($level == 5) {
			return 'SuperMod';
			} elseif($level == 6) {
			return 'Admin';
			} elseif($level == 7) {
			return 'SuperAdmin';
			} else {
			return 'Undefined';
			}
		} else {
			return 'User not exists';
		}
	}
function level($level) {
		if($level == 1) {
		return 'User';
		} elseif($level == 2) {
		return 'ChatMod';
		} elseif($level == 3) {
		return 'ForumMod';
		} elseif($level == 4) {
		return 'ShareMod';
		} elseif($level == 5) {
		return 'SuperMod';
		} elseif($level == 6) {
		return 'Admin';
		} elseif($level == 7) {
		return 'SuperAdmin';
		} else {
		return 'Undefined';
	}
}

	function title() {
	global $title;
	global $system;
	if(!empty($title)) { return ''.$title.''; } else { return 'Page of PerfCMS'; }
	}
	
	function user_panel() {
		global $lang;
		global $user;
		return (isset($user) ? '<a href="/user/panel/">'. $lang->word('user_panel') .'</a> | <a href="/exit/">'. $lang->word('sign_out') .'</a>' : '<a href="/sign_in/">'. $lang->word('sign_in') .'</a> | <a href="/sign_up/">'. $lang->word('sign_up') .'</a>') . ($user['level'] >= 6 ? ' | <a href="/padmin/">'. $lang->word('admin_panel').'</a>' : NULL);
	}
