-- --------------------------------------------------------
DROP TABLE IF EXISTS `ads`;
CREATE TABLE `ads` (
`id` INT( 16 ) NOT NULL AUTO_INCREMENT ,
`name` VARCHAR( 150 ) NOT NULL ,
`link` VARCHAR( 250 ) NOT NULL ,
`image` VARCHAR( 250 ) NOT NULL ,
`type` INT( 1 ) NOT NULL ,
`redirect` INT( 1 ) NOT NULL ,
PRIMARY KEY ( `id` ) 
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- --------------------------------------------------------
DROP TABLE IF EXISTS `chat`;
CREATE TABLE  `chat` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `pos` int(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

DROP TABLE IF EXISTS `chat_p`;
CREATE TABLE `chat_p` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `room_id` int(32) NOT NULL,
  `text` varchar(1000) NOT NULL,
  `user_id` int(32) NOT NULL,
  `time` int(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
DROP TABLE IF EXISTS `forum`;
CREATE TABLE  `forum` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `pos` int(32) NOT NULL,
  `desc` VARCHAR( 160 ) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
DROP TABLE IF EXISTS `forum_c`;
CREATE TABLE  `forum_c` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `f_id` int(32) NOT NULL,
  `name` varchar(32) NOT NULL,
  `pos` int(32) NOT NULL,
  `desc` VARCHAR( 160 ) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
DROP TABLE IF EXISTS `forum_pt`;
CREATE TABLE  `forum_pt` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `topic_id` int(32) NOT NULL,
  `cat_id` int(32) NOT NULL,
  `f_id` int(32) NOT NULL,
  `time` int(32) NOT NULL,
  `user_id` int(32) NOT NULL,
  `name` varchar(32) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `file_size` int(100) NOT NULL,
  `text` text NOT NULL,
  `edit_time` int(11) NOT NULL,
  `count_edit` int(11) NOT NULL,
  `edit_user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
DROP TABLE IF EXISTS `forum_t`;
CREATE TABLE  `forum_t` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `cat_id` int(11) NOT NULL,
  `time_last_post` int(11) NOT NULL,
  `user_last_post` int(11) NOT NULL,
  `closed` int(1) NOT NULL,
  `attach` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
DROP TABLE IF EXISTS `guests`;
CREATE TABLE  `guests` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `ip` varchar(20) NOT NULL,
  `browser` text NOT NULL,
  `time` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

DROP TABLE IF EXISTS `mail`;
CREATE TABLE  `mail` (
  `id` int(11) NOT NULL auto_increment,
  `mail_chat_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  `who_id` int(11) NOT NULL,
  `read` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

DROP TABLE IF EXISTS `mail_chat`;
CREATE TABLE `mail_chat` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL,
  `who_id` int(11) NOT NULL,
  `time_last_message` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

DROP TABLE IF EXISTS `news`;
CREATE TABLE  `news` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `time` int(32) NOT NULL,
  `user_id` int(32) NOT NULL,
  `name` varchar(32) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
DROP TABLE IF EXISTS `news_comms`;
CREATE TABLE  `news_comms` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `time` int(32) NOT NULL,
  `user_id` int(32) NOT NULL,
  `news_id` int(32) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
DROP TABLE IF EXISTS `pages`;
CREATE TABLE  `pages` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `lat_name` varchar(100) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
DROP TABLE IF EXISTS `settings`;
CREATE TABLE  `settings` (
  `user_id` int(20) NOT NULL,
  `lang` varchar(10) NOT NULL,
  `ames` varchar(2) NOT NULL,
  `theme` varchar(50) NOT NULL,
  `web_theme` varchar(50) NOT NULL,
  `fast_mess` varchar(3) NOT NULL,
  `view_profile` varchar(50) NOT NULL,
  `show_email` varchar(50) NOT NULL,
  `timezone` VARCHAR( 55 ) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
DROP TABLE IF EXISTS `share`;
CREATE TABLE  `share` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
DROP TABLE IF EXISTS `share_c`;
CREATE TABLE  `share_c` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `rid` int(20) NOT NULL,
  `name` varchar(32) NOT NULL,
  `who_upload` INT( 1 ) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
DROP TABLE IF EXISTS `share_comms`;
CREATE TABLE  `share_comms` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `share_id` int(32) NOT NULL,
  `user_id` int(32) NOT NULL,
  `time` int(32) NOT NULL,
  `text` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
DROP TABLE IF EXISTS `share_files`;
CREATE TABLE  `share_files` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `cat_id` int(32) NOT NULL,
  `user_id` int(32) NOT NULL,
  `dload_times` int(32) NOT NULL,
  `name` varchar(32) NOT NULL,
  `path_name` varchar(100) NOT NULL,
  `path` varchar(100) NOT NULL,
  `time` int(50) NOT NULL,
  `size` int(75) NOT NULL,
  `text` varchar(10000) NOT NULL,
  `ext` varchar(10) NOT NULL,
  `moderate` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
DROP TABLE IF EXISTS `share_rating`;
CREATE TABLE `share_rating` (
					`file_id` INT( 16 ) NOT NULL ,
					`user_id` INT( 16 ) NOT NULL ,
					`rated` INT( 16 ) NOT NULL,
					`rating` INT( 16 ) NOT NULL 
					) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- --------------------------------------------------------
DROP TABLE IF EXISTS `system`;
CREATE TABLE  `system` (
  `open_reg` varchar(10) NOT NULL,
  `ames` varchar(2) NOT NULL,
  `theme` varchar(50) NOT NULL,
  `web_theme` varchar(50) NOT NULL,
  `keywords` varchar(150) NOT NULL,
  `description` varchar(200) NOT NULL,
  `open_forum` varchar(3) NOT NULL,
  `open_chat` varchar(3) NOT NULL,
  `open_share` varchar(3) NOT NULL,
  `open_news` varchar(3) NOT NULL,
  `copyright` varchar(25) NOT NULL,
  `title` varchar(25) NOT NULL,
  `open_site` varchar(3) NOT NULL,
  `ads_footer` varchar(5000) NOT NULL,
  `ads_header` varchar(5000) NOT NULL,
  `ads_banners` varchar(5000) NOT NULL,
  `bb_b` varchar(3) NOT NULL,
  `bb_u` varchar(3) NOT NULL,
  `bb_s` varchar(3) NOT NULL,
  `bb_i` varchar(3) NOT NULL,
  `bb_big` varchar(3) NOT NULL,
  `bb_small` varchar(3) NOT NULL,
  `bb_yellow` varchar(3) NOT NULL,
  `bb_blue` varchar(3) NOT NULL,
  `bb_green` varchar(3) NOT NULL,
  `bb_red` varchar(3) NOT NULL,
  `bb_color` varchar(3) NOT NULL,
  `bb_size` varchar(3) NOT NULL,
  `bb_quote` varchar(3) NOT NULL,
  `lang` varchar(10) NOT NULL,
  `public_site` varchar(10) NOT NULL,
  `files_types` text NOT NULL,
  `who_upload` int(1) NOT NULL,
  `timezone` VARCHAR( 55 ) NOT NULL,
  `mainpage` TEXT NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `system` (`open_reg`, `ames`, `theme`, `web_theme`, `keywords`, `description`, `open_forum`, `open_chat`, `open_share`, `open_news`, `copyright`, `title`, `open_site`, `ads_footer`, `ads_header`, `ads_banners`, `bb_b`, `bb_u`, `bb_s`, `bb_i`, `bb_big`, `bb_small`, `bb_yellow`, `bb_blue`, `bb_green`, `bb_red`, `bb_color`, `bb_size`, `bb_quote`, `lang`, `public_site`, `files_types`, `who_upload`, `timezone`) VALUES
('yes', '10', 'default', 'default', 'PerfCMS', 'PerfCMS - Open Source Content Managment System For Mobile Sites', 'yes', 'yes', 'yes', 'yes', 'PerfCMS', 'PerfCMS', 'yes', '', '', '', 'on', 'on', 'on', 'on', 'on', 'on', 'on', 'on', 'on', 'on', 'on', 'on', 'on', 'ru', 'yes', 'png;gif;jpg;jpeg;bmp;sis;sisx;zip;rar;jar;jad;mp4;3gp;mp3;mid;midi;wav;amr;exe;tar.gz;3gpp;', 0, 'Europe/Kiev');

-- --------------------------------------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE  `users` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `nick` varchar(32) NOT NULL,
  `password` varchar(32) NOT NULL,
  `email` varchar(100) NOT NULL,
  `name` varchar(25) NOT NULL,
  `surname` varchar(40) NOT NULL,
  `device` varchar(40) NOT NULL,
  `icq` int(9) NOT NULL,
  `phone` varchar(40) NOT NULL,
  `site` varchar(40) NOT NULL,
  `info` varchar(3000) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `day` int(2) NOT NULL,
  `month` int(2) NOT NULL,
  `year` int(4) NOT NULL,
  `interests` varchar(1000) NOT NULL,
  `city` varchar(55) NOT NULL,
  `country` varchar(55) NOT NULL,
  `time` varchar(55) NOT NULL,
  `reg_time` varchar(55) NOT NULL,
  `locate` varchar(100) NOT NULL,
  `level` int(2) NOT NULL,
  `ban_time` int(32) NOT NULL,
  `ban_text` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;