function createCookie(name,value,days) {
	if (days) {
		var date = new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires = "; expires="+date.toGMTString();
	}
	else var expires = "";
	document.cookie = name+"="+value+expires+"; path=/";
}

var ComiqsLangMap = { 
  en: Comiqs_en
//  ,
//  de: Comiqs_de,
//  es: Comiqs_es,
//  fr: Comiqs_fr,
//  nl: Comiqs_nl,
//  pt: Comiqs_pt,
//  ru: Comiqs_ru,
//  tr: Comiqs_tr
};

var ComiqsDefaultOptions = {
    lang: 'en'
}

var Comiqs_en = {
    login_title: 'Please login',
    login_text: 'You need to login before using this function',
	user_rater_top_text: 'Rate this',
	user_rater_hover_text: ['Poor','Nothing special','OK','Pretty cool','Awesome!'],
	user_rater_rated_text: '<b>Thank you for rating</b>'	
};

var Comiqs = {

    options: null,
    language: Comiqs_en,
    
    init: function(options) {
        Comiqs.getOptions(options);
        createCookie("testcookie","1",1);
    },

validateLoginAction: function(userIsAuthenticated, action, param)
{
	if (userIsAuthenticated)
	{
		if (action != null)
			action(param);		
	}
	else
	{
		Ext.MessageBox.alert(Comiqs.language.login_title, Comiqs.language.login_text);
	}
},

getOptions: function(options)
{
     Comiqs.options = ComiqsDefaultOptions;
     for (var p in options) {
            Comiqs.options[p] = options[p];
        }

        // Map languages
        var lang = ComiqsLangMap[Comiqs.options.lang];
        if (typeof(lang) != "undefined") {
            Comiqs.language = lang;
        }
    },
    
    
    dummy : null   
}