/***************************************************************************
 *                              utils.js
 *                              ---------
 *   begin                : Ignatov V. Oleg, Apr 19, 2006
 *   author               : Ignatov V. Oleg (o.ignatov@onlike.ru)
 *   author               : Shelenkov V. Evgeniy (e.shelenkov@onlike.ru)
 *   copyright            : (C) 2006-2008 Studio Onlike
 *   mail                 : support@onlike.ru
 *   url                  : www.onlike.ru
 *   license              : commerce
 *
 *   $Id: utils.inc.js,v 1.40 2009/05/28 07:58:56 O.Ignatov Exp $
 *
 ***************************************************************************/


/**   -   **/

utils = function utils()
{

};

utils.client_pc  = navigator.userAgent.toLowerCase(); // Get client info
utils.client_ver = parseInt(navigator.appVersion); // Get browser version

utils.is_ie      = ((utils.client_pc.indexOf("msie") != -1));
utils.is_ie6      = ((utils.client_pc.indexOf("msie 6") != -1));
utils.is_ie7      = ((utils.client_pc.indexOf("msie 7") != -1));
utils.is_firefox = ((utils.client_pc.indexOf("firefox") != -1));
utils.is_ff2     = ((utils.client_pc.indexOf("firefox/2") != -1));
utils.is_ff3     = ((utils.client_pc.indexOf("firefox/3") != -1));
utils.is_safari  = ((utils.client_pc.indexOf("safari") != -1));
utils.is_opera   = ((utils.client_pc.indexOf("opera") != -1));
utils.is_win     = ((utils.client_pc.indexOf("win")!=-1) || (utils.client_pc.indexOf("16bit") != -1));
utils.is_mac     =  (utils.client_pc.indexOf("mac")!=-1);

utils.print_r = function(array)
{
   var text = '';
   for (var id in array){
       text = text+" ["+id+"] = "+array[id]+";\n";
   };
   alert(text);
};


utils.print_box = function (array)
{
   var text = '';
   for (var id in array){
       text = text+" ["+id+"] = "+array[id]+";\n";
   };
   document.write('<textarea style="width:100%; height:300px">'+text+'</textarea>');
};

utils.in_array_object = function (id, haystack)
{
   for (var value in  haystack) {
      if (haystack[value].id == id) {
         return true;
      }
   }
   return false;
};

utils.in_array = function (id, haystack)
{
   for (var i = 0; i < haystack.length; i++) {
      if (haystack[i] == id) {
         return true;
      }
   }
   return false;
};

utils.mozilla_wrap = function (textarea, open_tag, close_tag) {
   var select_length = textarea.textLength;
   var select_start  = textarea.selectionStart;
   var select_end    = textarea.selectionEnd;
   if (select_end == 1 || select_end == 2) {
      select_end = select_length;
   }
   var part_1 = (textarea.value).substring(0,select_start);
   var part_2 = (textarea.value).substring(select_start, select_end)
   var part_3 = (textarea.value).substring(select_end, select_length);
   textarea.value = part_1 + open_tag + part_2 + close_tag + part_3;
   return;
};

utils.str_replace = function (search, replace, subject)
{
   if (replace == subject) {
      return search;
   }

	subject = subject.toString();
	var flag = subject.indexOf(replace) == -1 ? true : false;
   var replace_location = search.indexOf(replace);
   var prev_sym = (replace_location > 0 ? search.substr(replace_location-1, 1) : "");
   var next_sym = replace_location+replace.length < search.length ? search.substr(replace_location+replace.length, 1) : "";
   var temp_string  = search;
   var left_string  = '';
   var right_string = '';
   while (replace_location != -1) {
   		if(flag || (utils._str_replace_internal_check(prev_sym) && utils._str_replace_internal_check(next_sym)))
   		{
	    	left_string = temp_string.substring(0, replace_location);
		    right_string = temp_string.substring(replace_location + replace.length);
		    temp_string = left_string + subject + right_string;
		    replace_location = temp_string.indexOf(replace, replace_location+1);
		    if(replace_location != -1)
		    {
		    	prev_sym = temp_string.substr(replace_location-1, 1);
		    	next_sym = replace_location+replace.length < temp_string.length ? temp_string.substr(replace_location+replace.length, 1) : "";
	    	}
      	}
      	else {
      		replace_location = temp_string.indexOf(replace, replace_location+1);
      	}
   }
   return temp_string;
};

utils._str_replace_internal_check = function(char)
{
	var check_string = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
	if(check_string.indexOf(char) == -1 || char == "")
	{
		return true;
	}

	return false;
};

utils.get_top_pos = function (inputObj)
{
	//    ( ) -    valign=top
   var returnValue = inputObj.offsetTop;
   while((inputObj = inputObj.offsetParent) != null){
      if(inputObj.tagName!='HTML') returnValue += inputObj.offsetTop;
   }
   return returnValue;
};

utils.get_left_pos = function (inputObj)
{
	//    ( ) -    align=left
   var returnValue = inputObj.offsetLeft;
	while((inputObj = inputObj.offsetParent) != null){
	   if(inputObj.tagName!='HTML')returnValue += inputObj.offsetLeft;
	}
	return returnValue;
};

utils.get_array_size = function (array) {
   for (i = 0; i < array.length; i++) {
      if ((array[i] == "undefined") || (array[i] == "") || (array[i] == null)) {
         return i;
      }
   }
   return array.length;
}

utils.array_push = function (array, value) {
   array[utils.get_array_size(array)] = value;
}

utils.array_delete_last = function (array) {
   array_size = utils.get_array_size(array);
   retval = array[array_size - 1];
   delete array[array_size - 1];
   return retval;
}

utils.store_caret = function (textEl) {
   if (textEl.createTextRange) {
      textEl.caretPos = document.selection.createRange().duplicate();
   }
}

utils.open_popup_window = function (url)
{
	window.open(url,'full_window','height='+screen.availHeight+',width='+screen.availWidth+',scrollbars=yes,status=no,menubar=no,location=no,directories=no,fullscreen=yes,resizable=yes');
}

utils.show_hide = function (elmt_id)
{

   var new_element_id = elmt_id + '_body';
   if ((document.getElementById(new_element_id) == "undefined") ||
       (document.getElementById(new_element_id) == "") ||
       (document.getElementById(new_element_id) == null)) {
         return ;
   }
   if (document.getElementById(elmt_id + '_body').style.display == "none") {
      document.getElementById(elmt_id).className = 'click';
	   if (utils.is_ie) {
  	  	   document.getElementById(elmt_id + '_body').style.display = "block";
	   } else {
	    	document.getElementById(elmt_id + '_body').style.display = "table";
	   }
   } else {
      document.getElementById(elmt_id).className = 'faq';
	   document.getElementById(elmt_id + '_body').style.display = "none";
   }
}

utils.show = function (elmt_id)
{
   var new_element_id = elmt_id + '_body';

   if (utils.is_ie) {
  	 	   document.getElementById(elmt_id + '_body').style.display = "block";
	} else {
		   document.getElementById(elmt_id + '_body').style.display = "block";
	}
}

utils.hide = function (elmt_id)
{
   var new_element_id = elmt_id + '_body';

   document.getElementById(elmt_id + '_body').style.display = "none";
}


utils.mouse_position = function (event)
{
   event || (event = window.event);
   var x_pos = 0;
   var y_pos = 0;
   if (!document.attachEvent && document.addEventListener) {
      x_pos = event.clientX + window.scrollX;
      y_pos = event.clientY + window.scrollY;
   }

   if (document.attachEvent != null) {
      x_pos = window.event.clientX + (document.documentElement.scrollLeft ? document.documentElement.scrollLeft : document.body.scrollLeft);
      y_pos = window.event.clientY + (document.documentElement.scrollTop  ? document.documentElement.scrollTop  : document.body.scrollTop);
   }

   return {x_pos:x_pos, y_pos:y_pos};
}

wp_ajax = function wp_ajax()
{
};

wp_ajax.execute_scripts_hmtl = function(varr)
{
   var sct  = varr.getElementsByTagName('script');
   for( var h = 0; h < sct.length; h++) {
     if (utils.is_ie) {
       var scrpt = sct[h].innerHTML
       scrpt = scrpt.replace('//<![CDATA[', '');
       scrpt = scrpt.replace('//]]>', '');

       var src = document.createElement("div");
       src.style.display = 'none';
       var scrpt_src = '';
       if (sct[h].src != '') {
          scrpt_src = 'src="'+sct[h].src+'?1=1"';
       }
       var str = 'MSIE...<script defer type="text/javascript" '+scrpt_src+' >'+scrpt+'</'+'script>';
       src.innerHTML = str;
       var nS = sct[h].nextSibling;
       var pN = sct[h].parentNode;
       pN.removeChild(sct[h]);
       pN.insertBefore(src, nS);

     } else {

        var scr = document.createElement('script');

        scr.innerHTML = sct[h].innerHTML;

        scr.setAttribute('defer', '');
        scr.setAttribute('type', sct[h].type);
        if (sct[h].src != '') {
           scr.setAttribute('src', sct[h].src);
        }
        var pN = sct[h].parentNode;
        pN.replaceChild(scr, sct[h]);
     }
   }
};

wp_ajax.show_loading = function(text, tpl_path, el_id)
{

  if (document.getElementById('wp_loading') == null) {
     var div_layer = document.createElement("div");
     div_layer.id = 'wp_loading';
     div_layer.className = 'wp_loading';

     var div_text = document.createElement("div");
     div_text.id = 'wp_loading_text';
     div_text.className = 'wp_loading_text';
     var text_node = document.createTextNode(text);
     div_text.appendChild(text_node);

     div_layer.appendChild(div_text);

     var br = document.createElement("br");
     div_layer.appendChild(br);

     var img = document.createElement("img");
     img.setAttribute('src', tpl_path + 'images/common/loading.gif');
     img.setAttribute('alt', text);
     img.setAttribute('title', text);
     div_layer.appendChild(img);

     div_layer.style.display = 'block';
     if (el_id != null) {
        var el = document.getElementById(el_id);
        el.appendChild(div_layer);
     } else {
        document.body.appendChild(div_layer);
     }
  }

};

wp_ajax.hide_loading =  function(el_id)
{
   var div_layer = document.getElementById("wp_loading");
   if (div_layer) {
     div_layer.style.display = 'none';

     if (el_id != null) {
        var el = document.getElementById(el_id);
        el.removeChild(div_layer);
     } else {
        document.body.removeChild(div_layer);
     }
   }
};

wp_event = function wp_event()
{

};


wp_event.get_element = function(ev)
{
  // ev || (ev = window.event);

	if (utils.is_ie) {
		return ev.srcElement;
	} else {
		return ev.currentTarget;
	}
};

wp_event.get_target_element = function(ev)
{
   ev || (ev = window.event);
	if (utils.is_ie) {
		return ev.srcElement;
	} else {
		return ev.target;
	}
};

wp_event.prototype.add = function(el, evname, func)
{
	if (el.attachEvent) { // IE
		el.attachEvent("on" + evname, func);
	} else if (el.addEventListener) { // Gecko / W3C
		el.addEventListener(evname, func, true);
	} else {
		el["on" + evname] = func;
	}

};

wp_event.prototype.send = function(el, evname)
{
   if (el.fireEvent) {
      var ev = document.createEventObject();
      el.fireEvent("on" + evname, ev);
   } else if (el.dispatchEvent) {
      var ev = new Event();
      ev.initEvent(evname, true, true);
      el.dispatchEvent(ev);
   }
};

wp_event.prototype.remove = function(el, evname, func)
{
	if (el.detachEvent) { // IE
		el.detachEvent("on" + evname, func);
	} else if (el.removeEventListener) { // Gecko / W3C
		el.removeEventListener(evname, func, true);
	} else {
		el["on" + evname] = null;
	}
};

wp_event.prototype.stop = function(ev) {
	ev || (ev = window.event);
	if (utils.is_ie) {
		ev.cancelBubble = true;
		ev.returnValue = false;
	} else {
		ev.preventDefault();
		ev.stopPropagation();
	}
	return false;
};


/**  - **/

function wp_open_show(element_id)
{
   var element = document.getElementById(element_id);
   element.style.display = element.style.display == 'none' ? 'block' : 'none';
}

wp_modal_window = function wp_modal_window()
{
};

//   
wp_modal_window.open = function (width, height, title, content, mwindow, mwindow_hide, mwindow_content, mwindow_content_html, mwindow_end, mwindow_title_html)
{
   if (!width)  {
      width = screen.width / 2;
   }
   if (!height){
      height = screen.height / 2;
   }
   //   -         (    5   )     5      .
   var ypos_modal_window = document.body.scrollHeight > document.body.scrollTop + height + (screen.height / 100 * 5) ?  document.body.scrollTop + (screen.height / 100 * 5) : document.body.scrollTop;
   this.modal_window = document.getElementById(mwindow);
   this.modal_window.style.display = 'block';
   this.modal_window.style.width = '100%';
   this.modal_window_hide = document.getElementById(mwindow_hide);
   this.modal_window_hide.style.display = 'block';
   //   -             .
   this.modal_window.style.height = document.body.scrollHeight > ypos_modal_window + height ? document.body.scrollHeight : ypos_modal_window + height;
   this.modal_window_content = document.getElementById(mwindow_content);
   this.modal_window_content.style.display = 'block';
   this.modal_window_content.style.width = width;
   this.modal_window_content.style.height = height;
   this.modal_window_content.style.top = ypos_modal_window;
   //   
   this.modal_window_content.style.left = (width > screen.width ? 0 : ((screen.width / 2) - (width / 2)));
   //       
   this.modal_window_title_html = document.getElementById(mwindow_title_html);
   this.modal_window_title_html.innerHTML = (title || '');
   //       
   if (content) {
      wp_modal_window.set_content(content, mwindow_content_html, mwindow, mwindow_end);
   } else {
      wp_modal_window.set_content(WP_MODAL_WINDOW_WAIT, mwindow_content_html, mwindow, mwindow_end);
   }

};

wp_modal_window.set_content = function (content, mwindow_content_html, mwindow, mwindow_end)
{
   this.modal_window_content_html = document.getElementById(mwindow_content_html);
   this.modal_window_content_html.innerHTML = (content ? content : this.modal_window_content_html.innerHTML);
   document.getElementById(mwindow).style.height = (document.body.scrollHeight > document.getElementById(mwindow_end).offsetTop+6 ? document.body.scrollHeight : document.getElementById(mwindow_end).offsetTop+6);
}

//      ESC
wp_modal_window.keypress = function (e)
{
   e || (e = window.event);
   if ((e.keyCode == 27 || (e.charCode && e.charCode == 27)) && ($('#dialog').css('display') != 'none')) {
       $('#dialog').hide('transfer', { to: $('#dialog').attr('dialog_mnemonic'), className: 'transferer2' }, 400, setTimeout(function(){ $("#dialog:visible").hide().fadeOut();		}, 100)	);
 	}
};

wp_console_window = function wp_console_window()
{
};

//      ESC
wp_console_window.keypress = function (e)
{

};
//      
wp_modal_window.close = function (mwindow, modal_wcontent, mwindow_hide)
{
   $('#dialog').hide('transfer', { to: $('#dialog').attr('dialog_mnemonic'), className: 'transferer2' }, 400, setTimeout(function(){ $("#dialog:visible").hide().fadeOut();		}, 100)	);
};