<?PHP

###########################
##  AutoRank PHP v1.0.x  ##
###################################################
##  setup.php - variable setup interface         ##
###################################################


chdir('..');

include('ar.php');

if( !$REMOTE_USER )
  derr(1000, ".htaccess Validation Required");

if( $REQUEST_METHOD == 'POST' ) {
  parsePost();
  saveSettings();
}
else {
  displayMain();
}


function displayMain() {
  global $VARS, $SCRIPT_FILENAME;

  $opt = array( 'EREV', 'PCONN', 'SUD', 'FBS', 'DBN', 'DUP', 'DBC', 'GSP', 'BCR', 'REV', 'EML', 'ADM', 'EDT', 'H_RCK', 'H_BIP', 'H_CST', 'H_PXY', 'H_CLG', 'H_ILG', 'H_GAT', 'H_COK', 'V_RCK', 'V_BIP', 'V_CST', 'V_PXY', 'V_CLG', 'V_ILG', 'V_COK', 'RCP', 'LWP', 'CHU', 'CRN', 'FD1', 'FD2', 'FD3', 'FCP', 'OFL', 'CFL' );

  if( !$VARS[HD] )
    $VARS[HD] = str_replace('/admin/setup.php', '', $SCRIPT_FILENAME);

  if( !$VARS[GD] && $VARS[HD] )
    $VARS[GD] = $VARS[HD] . '/images';

  if( !$VARS[MDUMP] )
    $VARS[MDUMP] = `which mysqldump`;

  if( !$VARS[MYSQL] )
    $VARS[MYSQL] = `which mysql`;

  while( list($key, $val) = each($opt) )
    $VARS[$val] = getCheck( $val, $VARS[$val] );

  stripHTML( $VARS[NI] );
  stripHTML( $VARS[DI] );
  stripHTML( $VARS[UI] );
  stripHTML( $VARS[SI] );
  getRanking();

  include("$VARS[IDIR]/_admin_setup.inc");
}

function saveSettings() {
  global $FRM, $VARS, $host, $user, $pass, $db, $time;

  checkInput( $FRM );

  umask(0);
  ## Create directories
  if( !file_exists("$VARS[DDIR]/icons")  )  mkdir("$VARS[DDIR]/icons",  0777);
  if( !file_exists("$VARS[DDIR]/mails")  )  mkdir("$VARS[DDIR]/mails",  0777);
  if( !file_exists("$VARS[DDIR]/times")  )  mkdir("$VARS[DDIR]/times",  0777);
  if( !file_exists("$VARS[DDIR]/html")   )  mkdir("$VARS[DDIR]/html",   0777);
  if( !file_exists("$VARS[DDIR]/breaks") )  mkdir("$VARS[DDIR]/breaks", 0777);
  if( !file_exists("$VARS[DDIR]/temp")   )  mkdir("$VARS[DDIR]/temp",   0777);

  ## Create files
  if( !file_exists("$VARS[DDIR]/times/start")      )  writef("$VARS[DDIR]/times/start",  $time);
  if( !file_exists("$VARS[DDIR]/times/backup")     )  writef("$VARS[DDIR]/times/backup", $time);
  if( !file_exists("$VARS[DDIR]/times/rerank")     )  writef("$VARS[DDIR]/times/rerank", $time);
  if( !file_exists("$VARS[DDIR]/times/reset")      )  writef("$VARS[DDIR]/times/reset",  $time);
  if( !file_exists("$VARS[DDIR]/times/vclear")     )  writef("$VARS[DDIR]/times/vclear", $time);
  if( !file_exists("$VARS[DDIR]/times/hclear")     )  writef("$VARS[DDIR]/times/hclear", $time);
  if( !file_exists("$VARS[DDIR]/times/rerank.frm") )  writef("$VARS[DDIR]/times/rerank.frm", 'N/A');
  if( !file_exists("$VARS[DDIR]/times/reset.frm")  )  writef("$VARS[DDIR]/times/reset.frm", 'N/A');


  $def = freadall("$VARS[DDIR]/def.html");


  ## Generate overall ranking page names and datafiles  
  list($name, $ext) = explode('.', $FRM[RP]);
  if( !file_exists("$VARS[DDIR]/html/$FRM[RP]") )  writef("$VARS[DDIR]/html/$FRM[RP]", $def);
  $FRM[OP] = $FRM[RP];

  $mainHash = "'$FRM[RP]' => ";

  if( $FRM[SO] ) {
    $pages = substr_count($FRM[SO], ',') + 2;
    $split = explode(',', $FRM[SO]);

    $mainHash .= " '1-$split[0]";

    for( $i = 2; $i <= $pages; $i++ ) {
      $FRM[OP] .= ",$name$i.$ext";
      $mainHash .= "', '$name$i.$ext' => '" . ($split[$i-2]+1) . "-" . $split[$i-1];
      if( !file_exists("$VARS[DDIR]/html/$name$i.$ext") )  writef("$VARS[DDIR]/html/$name$i.$ext", $def);
    }

    $mainHash .= "$FRM[OL]'";
  }
  else {
    $mainHash .= " '1-$FRM[OL]'";
  }


  ## Generate category ranking page names and datafiles
  if( $FRM[GSP] ) {
    $pages = substr_count($FRM[SC], ',') + 2;

    $cats = explode(',', $FRM[CT]);
    while( list($key,$val) = each($cats) ) {

      $page = htmlName($val, $FRM[FE]);
      if( !file_exists("$VARS[DDIR]/html/$page") )  writef("$VARS[DDIR]/html/$page", $def);
      list($name, $ext) = explode('.', $page);
      $FRM[CP] .= "$page,";

      $catHash[$val] = "'$page' => ";

      if( $FRM[SC] ) {
        $split = explode(',', $FRM[SC]);
        $catHash[$val] .= " '1-$split[0]";
        for( $i = 2; $i <= $pages; $i++ ) {
          $FRM[CP] .= "$name$i.$ext,";
          $catHash[$val] .= "', '$name$i.$ext' => '" . ($split[$i-2]+1) . "-" . $split[$i-1];
          if( !file_exists("$VARS[DDIR]/html/$name$i.$ext") )  writef("$VARS[DDIR]/html/$name$i.$ext", $def);
        }
        $catHash[$val] .= "$FRM[CL]'";
      }
      else {
        $catHash[$val] .= " '1-$FRM[CL]'";
      }
    }
    $FRM[CP] = substr($FRM[CP], 0, (strlen($FRM[CP]) - 1));
  }

  $split = explode(',', $FRM[FO]);
  while( list($key,$val) = each($split) ) {
    list($ranks,$size) = explode('=>', $val);
    list($start,$end)  = explode('-', $ranks);

    $fontHash .= "'$start' => '$size', ";
  }
  $fontHash = substr($fontHash, 0, (strlen($fontHash) - 2));

  $split = explode(',', $FRM[FC]);
  while( list($key,$val) = each($split) ) {
    list($ranks,$size) = explode('=>', $val);
    list($start,$end)  = explode('-', $ranks);

    $cfontHash .= "'$start' => '$size', ";
  }
  $cfontHash = substr($cfontHash, 0, (strlen($cfontHash) - 2));


  $split = explode(',', $FRM[BO]);
  while( list($key,$val) = each($split) ) {
    $breakHash .= "'$val' => '1', ";
  }
  $breakHash = substr($breakHash, 0, (strlen($breakHash) - 2));

  $split = explode(',', $FRM[BC]);
  while( list($key,$val) = each($split) ) {
    $cbreakHash .= "'$val' => '1', ";
  }
  $cbreakHash = substr($cbreakHash, 0, (strlen($cbreakHash) - 2));


  ## Write the variables file
  $fh = @fopen("$VARS[DDIR]/vars.php", "w") or err('Cannot write to vars.php');
  fwrite( $fh, "<?PHP\n\n## DO NOT EDIT THIS FILE\n\n" );
  while( list( $key, $val ) = each( $FRM ) )
    fwrite($fh, "\$VARS[$key] = '$val';\n");

  fwrite( $fh, "\$VARS[OH] = array( $mainHash );\n");
  
  $cats = explode(',', $FRM[CT]);
  while( list($key,$val) = each($cats) )
    fwrite( $fh, "\$VARS['$val'] = array( $catHash[$val] );\n");

  fwrite( $fh, "\$VARS[LBO] = array( $breakHash );\n\$VARS[LBC] = array( $cbreakHash );\n" );
  fwrite( $fh, "\$VARS[TO] = array( $fontHash );\n\$VARS[TC] = array( $cfontHash );\n\$host = '$host';\n\$user = '$user';\n\$pass = '$pass';\n\$db = '$db';\n");
  fwrite( $fh, "\n?" . ">" );
  fclose( $fh );
  @chmod("$VARS[DDIR]/vars.php", 0666);

  $VARS[DDR]  = dirTest($VARS[DDIR]);
  $VARS[HDR]  = dirTest($FRM[HD]);
  $VARS[GDR]  = dirTest($FRM[GD]);
  $VARS[MDP]  = strstr(`$FRM[MDUMP] --version`, 'mysqldump') ? '<font color="blue">Found</font>' : '<font color="red">Not Found</font>';
  $VARS[MYS]  = strstr(`$FRM[MYSQL] --version`, 'mysql') ? '<font color="blue">Found</font>' : '<font color="red">Not Found</font>';
  $VARS[DATE] = date($FRM[DF], $time + (3600*$FRM[TZ]));
  $VARS[TIME] = date($FRM[TF], $time + (3600*$FRM[TZ]));

  include("$VARS[IDIR]/_admin_verify.inc");
}

function checkInput( &$FRM ) {
  $nam = array (
                 'HD' => 'HTML Directory',
                 'GD' => 'Image Directory',
                 'PU' => 'PHP URL',
                 'FU' => 'Forward URL',
                 'HU' => 'HTML URL',
                 'GU' => 'Image URL',
                 'IU' => 'In URL',
                 'OU' => 'Out URL',
                 'EM' => 'E-mail Address',
                 'OL' => 'Overall Sites To List',
                 'RP' => 'Main Ranking Page',
                 'CT' => 'Categories',
                 'OB' => 'Overall Banners To Show',
                 'BH' => 'Max Banner Height',
                 'BW' => 'Max Banner Width',
                 'BB' => 'Max Banner Byte Size',
                 'MH' => 'Minimum Hits or Ratings',
                 'HR' => 'Highest Rating',
                 'MT' => 'Max Title Length',
                 'MD' => 'Max Description Length',
                 'DP' => 'Decimal Places',
                 'RR' => 'Rerank Time',
                 'RS' => 'Reset Time',
                 'SR' => 'Search Results',
                 'RI' => 'Ranking Images',
                 'CL' => 'Category Sites To List',
                 'FE' => 'File Extension',
                 'CB' => 'Category Banners To Show',
                 'DR' => 'Average Rating Decimal Places',
                 'NRATE' => '"Not Rated" Text',
                 'NRANK' => '"Not Ranked" Text',
                 'MDUMP' => 'Full Path To mysqldump',
                 'MYSQL' => 'Full Path To mysql',
                 'DF' => 'Date Format',
                 'TF' => 'Time Format',
                 'TZ' => 'Time Zone Offset',
                 'CPP' => 'Comments Per Page',
                 'CNEXT' => '"Next" Comments Text',
                 'CPREV' => '"Previous" Comments Text',
                 'SNEXT' => '"Next" Search Text',
                 'SPREV' => '"Previous" Search Text'
               );

  $req = array('CNEXT', 'CPREV', 'SNEXT', 'SPREV', 'DF', 'TF', 'TZ', 'MDUMP', 'MYSQL', 'HD', 'GD', 'PU', 'FU', 'HU', 'GU', 'IU', 'OU', 'EM', 'OL', 'RP', 'CT', 'OB', 'BH', 'BW', 'BB', 'MH', 'HR', 'MT', 'MD', 'DP', 'RR', 'RS', 'SR', 'RI', 'DR', 'NRATE', 'NRANK', 'CPP' );
  $rec = array('CL', 'FE', 'CB');
  $spc = array('HD', 'GD', 'PU', 'FU', 'HU', 'GU', 'IU', 'OU', 'EM', 'OL', 'RP');

  if( $FRM[GSP] )
    $req = array_merge($req, $rec);

  for( $i = 0; $i < count( $req ); $i++ )
    if( $FRM[$req[$i]] == '' || ereg( "^[[:space:]]+$", $FRM[$req[$i]] ) )
      derr(1001, $nam[$req[$i]] . " Left Blank");

  for( $i = 0; $i < count( $spc ); $i++ )
    if( ereg( "[[:space:]]", $FRM[$spc[$i]] ) )
      derr(1030, "Invalid Space Found in " . $nam[$spc[$i]]);

  if( eregi( "^http://", $FRM[HD] ) )
    derr(1031, "Invalid HTML Directory");

  if( $FRM[H_GAT] && !$FRM[H_ST] )
    derr(1001, "Gateway Session Time Left Blank");

  while( list($key,$val) = each($FRM) ) {
    $FRM[$key] = stripslashes($FRM[$key]);
    $FRM[$key] = str_replace("'", "\'", $FRM[$key]);
  }

  reset($FRM);
}

function stripHTML( &$val ) {
  $val = str_replace("<", "&lt;", $val);
  $val = str_replace(">", "&gt;", $val);
  $val = str_replace("\"", "&quot;", $val);
}

function getCheck( $item, $value ) {
  if( $value == '1' ) return "<input type=\"checkbox\" name=\"FRM[$item]\" value=\"1\" checked>";
  return "<input type=\"checkbox\" name=\"FRM[$item]\" value=\"1\">";
}

function getRanking() {
  global $VARS;

  $opts = array (
                  'in'     => 'Hits In Since Last Reset',
                  'out'    => 'Hits Out Since Last Reset',
                  'tin'    => 'Total Hits In',
                  'tout'   => 'Total Hits Out',
                  'ipday'  => 'Average Hits In/Day',
                  'ipwek'  => 'Average Hits In/Week',
                  'ipmth'  => 'Average Hits In/Month',
                  'opday'  => 'Average Hits Out/Day',
                  'opwek'  => 'Average Hits Out/Week',
                  'opmth'  => 'Average Hits Out/Month',
                  'arat'   => 'Average Rating',
                  'trat'   => 'Number of Ratings'
                );

  $rank = $VARS[RB];
  $VARS[RB] = '';

  while( list($key,$val) = each($opts) ) {
    $VARS[RB] .= "<option value='$key'";
    if( $key == $rank ) $VARS[RB] .= ' selected'; 
    $VARS[RB] .= ">$val</option>\n";
  }
}

function dirTest( $dir ) {
  if( !file_exists( $dir ) )
    return '<font color="red">Directory Not Found</font>';

  if( !is_writeable( $dir ) )
    return '<font color="red">Incorrect Permissions</font>';

  return '<font color="blue">Passed!</font>';
}

?>