<?PHP

##################
##  HTTP Class  ##
##################

class HTTP {

  var $Host, $Port, $URL, $URI, $Location, $Status, $SCode, $Sock, $Errno, $Errstr, $HTML;

  // Perform a simple get with no redirection
  function Get( $url ) {
    $this->URL = $url;
    $this->_urlexpand();
    $this->_connect();
    fputs( $this->Sock, "GET $this->URI HTTP/1.0\r\nHost: $this->Host\r\nConnection: close\r\n\r\n" );

    $this->HTML = '';

    // Check URL status
    $this->HTML = fgets( $this->Sock, 256 );

    if( eregi(" ([[:digit:]][[:digit:]][[:digit:]]) ", $this->HTML, $regs) )
      if( $regs[0] >= 400 )
        $this->_error( substr($this->HTML, 1+strpos($this->HTML, ' ')) );


    // Strip off remaining headers
    while( $line = fgets( $this->Sock, 4096 ) ) {
      if( ereg("^[[:space:]][[:space:]]$", $line) )
        break;
    }

    $this->HTML = fread( $this->Sock, 262144 );

    $this->_disconnect();
  }

  // Check the status of a URL
  function Status( $url ) {
    $this->URL = $url;
    $this->_urlexpand();
    $this->_connect();

    fputs( $this->Sock, "GET $this->URI HTTP/1.0\r\nHost: $this->Host\r\nConnection: close\r\n\r\n" );
    $this->HTML = fgets( $this->Sock, 256 );

    if( eregi(" ([[:digit:]][[:digit:]][[:digit:]]) ", $this->HTML, $regs) )
      if( $regs[0] >= 400 )
        $this->_error( substr($this->HTML, 1+strpos($this->HTML, ' ')) );

    $this->_disconnect();    
  }

  // Check a reciprocal link
  function CheckRecip() {
  }

  // Print HTML to stdout or file pointer
  function PrintHTML( $fd = 0 ) {
    if( $fd )
      fwrite( $fd, $this->HTML );
    else
      print $this->HTML;    
  }

  #############################################
  ##  Private (sort of) functions            ##
  #############################################


  // Connect to the HTTP server
  function _connect() {
    $this->Sock = fsockopen( $this->Host, $this->Port, $this->Errno, $this->Errstr, 30 );

    if( !$this->Sock )
      $this->_error("Could not connect to $this->Host");
  }

  // Disconnect from the HTTP server
  function _disconnect() {
    if( $this->Sock )
      fclose( $this->Sock );
  }

  // Break URL down into host, port, and URI
  function _urlexpand() {
    $url   = str_replace('http://', '', $this->URL);
    $slash = strpos($url, '/');

    if( $slash )
      $this->URI = substr( $url, $slash );
    else
      $this->URI = '/';

    list( $this->Host, $this->Port ) = explode(':', substr( $url, 0, $slash ) );

    if( $this->Host == '' )
      $this->Host = $url;

    if( $this->Port == '' )
      $this->Port = 80;

  }

  // Handle errors
  function _error( $msg ) {
    $this->_disconnect();

    $tpl[ERR] = $msg;
    $tpl[URL] = $this->URL;

    fparse('_error_http.htmlt', $tpl);
    exit;
  }

}


?>