<?PHP

###########################
##  AutoRank PHP v1.0.x  ##
###################################################
##  accounts.php - member account interface      ##
###################################################

require('ar.php');
require('http.php');

$funct = array (
                 'addAccount'   => 'addAccount',
                 'login'        => 'displayLogin',
                 'remind'       => 'displayRemind',
                 'displayEdit'  => 'displayEdit',
                 'displayStats' => 'displayStats',
                 'displayFarm'  => 'displayFarm',
                 'editAccount'  => 'editAccount',
                 'sendPassword' => 'sendPassword'
               );

if( $REQUEST_METHOD == 'POST' ) {
  parsePost(true);
  if( $funct[$fnct] )
    $funct[$fnct]();
  else
    displayMain();
}
else {
  if( $funct[$QUERY_STRING] )
    $funct[$QUERY_STRING]();
  else
    displayMain();
}

function displayMain() {
  global $VARS;

  $cats = explode(',', $VARS[CT]);
  while( list($key,$val) = each($cats) )
    $tpl[CATS] .= "<option value='$val'>$val</option>";

  $tpl[NFD1] = $VARS[F1];
  $tpl[NFD2] = $VARS[F2];
  $tpl[NFD3] = $VARS[F3];

  fparse('_account_add.htmlt', $tpl);
}

function displayLogin() {
  global $VARS;
  readfile("$VARS[TDIR]/_account_login.htmlt");
}

function displayRemind() {
  global $VARS;
  readfile("$VARS[TDIR]/_account_remind.htmlt");
}

function displayEdit() {
  global $FRM, $VARS;

  $row = $VARS[DBH]->db_row("SELECT * FROM arp_accts WHERE user='$FRM[USER]' and pass='$FRM[PASS]'");

  if( $row ) {
    if( $row[18] == 'Y' )
      derr(1005, "Account Suspended");

    if( $row[19] == 'Y' )
      derr(1006, "Account Locked");

    $FRM[NFD1]  = $VARS[F1];
    $FRM[NFD2]  = $VARS[F2];
    $FRM[NFD3]  = $VARS[F3];
    $FRM[EMAIL] = $row[1];
    $FRM[SURL]  = $row[2];
    $FRM[BURL]  = $row[3];
    $FRM[BHT]   = $row[4] == 0 ? '' : $row[4];
    $FRM[BWD]   = $row[5] == 0 ? '' : $row[5];
    $FRM[RURL]  = $row[6];
    $FRM[TITLE] = $row[7];
    $FRM[SDES]  = $row[8];
    $FRM[PASS]  = $row[13]; 
    $FRM[FLD1]  = $row[14];
    $FRM[FLD2]  = $row[15];
    $FRM[FLD3]  = $row[16];

    $cats = explode(',', $VARS[CT]);
    while( list($key,$val) = each($cats) ) {
      $FRM[CATS] .= "<option value='$val'";
      $FRM[CATS] .= $row[9] == $val ? ' selected' : '';
      $FRM[CATS] .= ">$val</option>\n";
    }

    fparse('_account_edit.htmlt', $FRM);
  }
  else
    derr(1004, "Invalid Username/Password Combination");
  
}

function displayStats() {
  global $FRM, $VARS, $time;

  $row = $VARS[DBH]->db_row("SELECT * FROM arp_accts,arp_hits,arp_votes,arp_rank WHERE arp_accts.user=arp_hits.user AND arp_accts.user=arp_rank.user AND arp_accts.user=arp_votes.user AND arp_accts.user='$FRM[USER]' AND arp_accts.pass='$FRM[PASS]'");

  if( $row ) {

    $tpl[SIGNUP] = date("$VARS[DF] $VARS[TF]", $row[11] + (3600*$VARS[TZ]));
    $tpl[START]  = date("$VARS[DF] $VARS[TF]", $row[20] + (3600*$VARS[TZ]));
    $tpl[IN]     = round($row[22]*$row[12]);
    $tpl[OUT]    = $row[23];
    $tpl[TIN]    = round($row[24]*$row[12]);
    $tpl[TOUT]   = $row[25];
    $tpl[IPDAY]  = getAvg( round($row[24]*$row[12]), $time-$row[20], 86400);
    $tpl[IPWEK]  = getAvg( round($row[24]*$row[12]), $time-$row[20], 604800);
    $tpl[IPMTH]  = getAvg( round($row[24]*$row[12]), $time-$row[20], 2592000);
    $tpl[OPDAY]  = getAvg( $row[25], $time-$row[20], 86400);
    $tpl[OPWEK]  = getAvg( $row[25], $time-$row[20], 604800);
    $tpl[OPMTH]  = getAvg( $row[25], $time-$row[20], 2592000);
    $tpl[TRAT]   = $row[33];
    $tpl[ARAT]   = $row[33] > 0 ? sprintf("%.$VARS[DR]f", $row[34]/$row[33]) : $VARS[NRATE];
    $tpl[ORANK]  = $row[36] == 9999999 ? $VARS[NRANK] : $row[36];
    $tpl[CRANK]  = $row[37] == 9999999 ? $VARS[NRANK] : $row[37];

    fparse('_account_statst.htmlt', $tpl);


    $res = $VARS[DBH]->db_query("SELECT * FROM arp_mstat WHERE user='$FRM[USER]'");
    while( $row = $VARS[DBH]->db_nextrow($res) ) {
      $tpl[DATE]   = date("$VARS[DF] $VARS[TF]", $row[1] + (3600*$VARS[TZ]));
      $tpl[IN]     = round($row[2]*$row[8]);
      $tpl[OUT]    = $row[3];
      $tpl[TIN]    = round($row[4]*$row[8]);
      $tpl[TOUT]   = $row[5];
      $tpl[IPDAY]  = getAvg( round($row[4]*$row[8]), $row[1]-$row[9], 86400);
      $tpl[IPWEK]  = getAvg( round($row[4]*$row[8]), $row[1]-$row[9], 604800);
      $tpl[IPMTH]  = getAvg( round($row[4]*$row[8]), $row[1]-$row[9], 2592000);
      $tpl[OPDAY]  = getAvg( $row[5], $row[1]-$row[9], 86400);
      $tpl[OPWEK]  = getAvg( $row[5], $row[1]-$row[9], 604800);
      $tpl[OPMTH]  = getAvg( $row[5], $row[1]-$row[9], 2592000);
      $tpl[ORANK]  = $row[6] == 9999999 ? $VARS[NRANK] : $row[6];
      $tpl[CRANK]  = $row[7] == 9999999 ? $VARS[NRANK] : $row[7];

      fparse('_account_statsm.htmlt', $tpl);
    }


    fparse('_account_statsb.htmlt', $tpl);
  }
  else
    derr(1004, "Invalid Username/Password Combination");
}

function displayFarm() {
  global $FRM, $VARS;

  if( !$FRM[USER] ) derr(1001, "No Username Entered");
  $FRM[TURL] = $VARS[IU] . "?id=$FRM[USER]";
  $FRM[IURL] = $VARS[PU] . "/image.php?id=$FRM[USER]";

  fparse('_account_farm.htmlt', $FRM);
}

##########################################################################################
##########################################################################################
##########################################################################################

function addAccount() {
  global $FRM, $VARS;

  checkInput(true);
  checkDup();

  $FRM[NFD1] = $VARS[F1];
  $FRM[NFD2] = $VARS[F2];
  $FRM[NFD3] = $VARS[F3];
  $FRM[TURL] = $VARS[IU] . "?id=$FRM[USER]";
  $FRM[IURL] = $VARS[PU] . "/image.php?id=$FRM[USER]";
  $FRM[LURL] = $VARS[PU] . "/accounts.php?login";

  $time = time();
  $VARS[DBH]->db_query("INSERT INTO arp_accts VALUES ( '$FRM[USER]', '$FRM[EMAIL]', '$FRM[SURL]', '$FRM[BURL]', '$FRM[BHT]', '$FRM[BWD]', '$FRM[RURL]', '$FRM[TITLE]', '$FRM[SDES]', '$FRM[CAT]', '', '$time',  '1.000',  '$FRM[PASS]',  '$FRM[FLD1]', '$FRM[FLD2]', '$FRM[FLD3]', '$FRM[APP]', 'N', 'N', $time )");
  $VARS[DBH]->db_query("INSERT INTO arp_hits  VALUES ( '$FRM[USER]', 0, 0, 0, 0, 0, 0, 0, 9999999, 9999999, 0 )");
  $VARS[DBH]->db_query("INSERT INTO arp_votes VALUES ( '$FRM[USER]', 0, 0 )");
  $VARS[DBH]->db_query("INSERT INTO arp_rank  VALUES ( '$FRM[USER]', 9999999, 9999999 )");
  $VARS[DBH]->db_query("INSERT INTO arp_hcheat VALUES ( '$FRM[USER]', 0, 0, 0, 0, 0, 0, 0, 0 )");
  $VARS[DBH]->db_query("INSERT INTO arp_vcheat VALUES ( '$FRM[USER]', 0, 0, 0, 0, 0, 0, 0, 0 )");

  $sub = false;
  $row = array("$FRM[USER]", "$FRM[EMAIL]", "$FRM[SURL]", "$FRM[BURL]", "$FRM[BHT]", "$FRM[BWD]", "$FRM[RURL]", "$FRM[TITLE]", "$FRM[SDES]", "$FRM[CAT]", "", "$time",  "1.000",  "$FRM[PASS]",  "$FRM[FLD1]", "$FRM[FLD2]", "$FRM[FLD3]", "Y", "N", "N", "$time");
  $tmp = $VARS[REV] ? '_email_review.etmpl' : '_email_added.etmpl';

  if( $VARS[EML] )
    mailMember($FRM[EMAIL], $sub, freadall("$VARS[TDIR]/$tmp"), $VARS[EM], $row);
    
  if( $VARS[ADM] )
    mailMember($VARS[EM], $sub, freadall("$VARS[TDIR]/_email_admin.etmpl"), $VARS[EM], $row);

  fparse( $VARS[REV] ? '_account_review.htmlt' : '_account_added.htmlt', $FRM );
}

function editAccount() {
  global $FRM, $VARS, $pass;

  checkInput();

  $row = $VARS[DBH]->db_row("SELECT * FROM arp_accts WHERE user='$FRM[USER]' and pass='$FRM[OPASS]'");

  if( $row ) {
    if( $row[18] == 'Y' )
      derr(1005, "Account Suspended");

    if( $row[19] == 'Y' )
      derr(1006, "Account Locked");

    $FRM[NFD1] = $VARS[F1];
    $FRM[NFD2] = $VARS[F2];
    $FRM[NFD3] = $VARS[F3];
    $FRM[TURL] = $VARS[IU] . "?id=$FRM[USER]";
    $FRM[IURL] = $VARS[PU] . "/image.php?id=$FRM[USER]";

    if( !$FRM[CAT] )  $FRM[CAT]   = $row[9];
    if( !$FRM[FLD1] ) $FRM[FLD1]  = $row[14];
    if( !$FRM[FLD2] ) $FRM[FLD2]  = $row[15];
    if( !$FRM[FLD3] ) $FRM[FLD3]  = $row[16];

    ## Reviewing member account editing
    if( $VARS[EREV] ) {
      $VARS[DBH]->db_query("DELETE FROM arp_edit WHERE user='$FRM[USER]'");      
      $VARS[DBH]->db_query("INSERT INTO arp_edit VALUES ( '$FRM[USER]', '$FRM[EMAIL]', '$FRM[SURL]', '$FRM[BURL]', '$FRM[BHT]', '$FRM[BWD]', '$FRM[RURL]', '$FRM[TITLE]', '$FRM[SDES]', '$FRM[CAT]', '$FRM[PASS]', '$FRM[FLD1]', '$FRM[FLD2]', '$FRM[FLD3]' )");

      fparse('_account_revedit.htmlt', $FRM);
    }

    ## Not reviewing member account editing
    else {
      $VARS[DBH]->db_query("UPDATE arp_accts SET email='$FRM[EMAIL]',surl='$FRM[SURL]',burl='$FRM[BURL]',bht='$FRM[BHT]',bwd='$FRM[BWD]',rurl='$FRM[RURL]',title='$FRM[TITLE]',sdes='$FRM[SDES]',cat='$FRM[CAT]',pass='$FRM[PASS]',fld1='$FRM[FLD1]',fld2='$FRM[FLD2]',fld3='$FRM[FLD3]' WHERE user='$FRM[USER]'");
      fparse('_account_edited.htmlt', $FRM);
    }

    $row = array("$FRM[USER]", "$FRM[EMAIL]", "$FRM[SURL]", "$FRM[BURL]", "$FRM[BHT]", "$FRM[BWD]", "$FRM[RURL]", "$FRM[TITLE]", "$FRM[SDES]", "$FRM[CAT]", "", "$time",  "1.000",  "$FRM[PASS]",  "$FRM[FLD1]", "$FRM[FLD2]", "$FRM[FLD3]", "Y", "N", "N", "$time");
  
    if( $VARS[ADM] )
      mailMember($VARS[EM], $sub, freadall("$VARS[TDIR]/_email_edit.etmpl"), $VARS[EM], $row);   
  }
  else
    derr(1004, "Invalid Username/Password Combination");

}

function sendPassword() {
  global $FRM, $VARS;

  $res = $VARS[DBH]->db_query("SELECT * FROM arp_accts WHERE email='$FRM[EMAIL]'");

  if( $VARS[DBH]->db_numrows($res) ) {
    
    $sub = false;

    while( $row = $VARS[DBH]->db_nextrow($res) ) {
      mailMember($row[1], $sub, freadall("$VARS[TDIR]/_email_remind.etmpl"), $VARS[EM], $row);
    }

    fparse('_account_reminded.htmlt', $FRM);

  }
  else {
    derr(1013, 'E-mail Address Not Found');
  }
}


function checkInput( $adding = false ) {
  global $FRM, $VARS;

  if( $adding && $VARS[DBH]->db_count("SELECT COUNT(*) FROM arp_accts WHERE user='$FRM[USER]'") )
    derr(1012, "Username Taken");

  // Make sure no one overwrites standard.gif
  if( $FRM[USER] == 'standard' )
    derr(1012, "Username Taken");

  checkBans();

  ## Check for properly formatted URLs and E-mails
  if( !eregi("^[[:alnum:]][[:alnum:]_.-]*@[[:alnum:].-]+\.[[:alnum:].-]+", $FRM[EMAIL]) )   derr(1008, "Invalid E-mail Address");
  if( !eregi("^http://[[:alnum:].-]+\.[[:alnum:].-]+", $FRM[SURL]) )                        derr(1009, "Invalid Site URL");
  if( $FRM[BURL] && !eregi("^http://[[:alnum:].-]+\.[[:alnum:].-]+", $FRM[BURL]) )          derr(1009, "Invalid Banner URL");
  if( $VARS[RCP] && !eregi("^http://[[:alnum:].-]+\.[[:alnum:].-]+", $FRM[RURL]) )          derr(1009, "Invalid Reciprocal Link URL");


  ## Other checks
  if( !$FRM[TITLE] || !$FRM[SDES] )           derr(1001, "Title or Description Blank") ;
  if( strlen($FRM[TITLE]) > $VARS[MT] )       derr(1010, "Site Title Oversized");
  if( strlen($FRM[SDES]) > $VARS[MD] )        derr(1010, "Description Oversized");
  if( $adding && strlen($FRM[USER]) < 4 )     derr(1010, "Username Too Short");
  if( $adding && strlen($FRM[USER]) > 15 )    derr(1010, "Username Too Long");
  if( strlen($FRM[PASS]) < 4 )                derr(1010, "Password Too Short");
  if( !ereg("^[[:alnum:]]+$", $FRM[USER]) )   derr(1011, "Invalid Character In Username");
  

  ## Check user defined fields
  if( $VARS[FD1] && !$FRM[FLD1] ) derr(1001, "$VARS[F1] Left Blank");
  if( $VARS[FD2] && !$FRM[FLD2] ) derr(1001, "$VARS[F2] Left Blank");
  if( $VARS[FD3] && !$FRM[FLD3] ) derr(1001, "$VARS[F3] Left Blank");

  ## Check URLs that were supplied
  if( $VARS[CHU] ) {
    $req = new HTTP;
    $req->Status($FRM[SURL]);

    if( $FRM[RURL] )
      $req->Status($FRM[RURL]);

    if( $FRM[BURL] )
      $req->Status($FRM[BURL]);
  }

  ## Download the banner if either option is enabled
  if( $FRM[BURL] && ($VARS[DBN] || $VARS[DBC]) ) {
    $req = new HTTP;
    $req->Get($FRM[BURL]);

    $fd = @fopen("$VARS[GD]/$FRM[USER]", 'w') or err("Could not write banner data to file");
    $req->PrintHTML($fd);
    fclose($fd);
    @chmod("$VARS[GD]/$FRM[USER]", 0666);

    ## width height type(1 = GIF, 2 = JPG, 3 = PNG, 4 = SWF)
    $dims = GetImageSize("$VARS[GD]/$FRM[USER]");

    if( !$dims ) {
      unlink("$VARS[GD]/$FRM[USER]");
      derr(1032, "Invalid Image Format");
    }

    if( filesize("$VARS[GD]/$FRM[USER]") > $VARS[BB] ) {
      unlink("$VARS[GD]/$FRM[USER]");
      derr(1033, "Banner Size Too Large");
    }

    $FRM[BWD] = $dims[0];
    $FRM[BHT] = $dims[1];

    ## If serving banners from this server, get the proper extension, and setup the banner URL
    if( $VARS[DBN] ) {
      $fe = $dims[2] == 1 ? 'gif' : 'jpg';
      rename("$VARS[GD]/$FRM[USER]", "$VARS[GD]/$FRM[USER].$fe");
      $FRM[BURL] = "$VARS[GU]/$FRM[USER].$fe";
    }
    else {
      unlink("$VARS[GD]/$FRM[USER]");
    }
  }


  ## If banner URL is supplied, check height and widths
  if( $FRM[BURL] ) {
    if( $FRM[BHT] > $VARS[BH] ) derr(1017, "Banner Height Too Large");
    if( $FRM[BWD] > $VARS[BW] ) derr(1017, "Banner Width Too Large");
    if( !$FRM[BHT] ) $FRM[BHT] = $VARS[BH];
    if( !$FRM[BWD] ) $FRM[BWD] = $VARS[BW];
  }

  ## If no banner is supplied, but a default banner has been setup, use the default
  if( !$FRM[BURL] && $VARS[DB] ) {
    $FRM[BURL] = $VARS[DB];
    $FRM[BHT]  = $VARS[DH];
    $FRM[BWD]  = $VARS[DW];
  }

  ## If forcing all banners to same size, do it
  if( $VARS[FBS] ) {
    $FRM[BHT] = $VARS[BH];
    $FRM[BWD] = $VARS[BW];
  }
    

  $FRM[APP] = $VARS[REV] ? 'N' : 'Y';

  ## add slashes so the database likes all input
  while( list($key, $val) = each($FRM) )
    $FRM[$key] = addslashes(stripslashes($val));

  reset($FRM);

  ## Make sure valid category was choosen
  $found = false;
  $cats = explode(',', $VARS[CT]);
  while( list($key,$val) = each($cats) )
    if( $FRM[CAT] == $val )
      $found = true;

  if( !$found ) derr(1034, "Invalid Category Selected");
}

function checkDup() {
  global $VARS, $FRM;

  if( $VARS[DBH]->db_count("SELECT COUNT(*) FROM arp_accts WHERE surl='$FRM[SURL]' OR sdes='$FRM[SDES]' OR title='$FRM[TITLE]'") )
    derr(1021, "Duplicate Account");
}

function checkBans() {
  global $VARS, $FRM, $REMOTE_ADDR;

  $res = $VARS[DBH]->db_query("SELECT * FROM arp_bans ORDER BY type");

  while( $row = $VARS[DBH]->db_nextrow($res) ) {

    switch( $row[0] ) {

      case 'IP':
        if( stristr($REMOTE_ADDR, $row[1]) ) derr(1007, "You Are Not Allowed To Add Accounts");
        break;

      case 'Word':
        if( stristr($FRM[TITLE], $row[1]) )  derr(1007, "Banned Word, Phrase, or Character '$row[1]'");
        if( stristr($FRM[SDES], $row[1]) )   derr(1007, "Banned Word, Phrase, or Character '$row[1]'");
        break;

      case 'URL':
        if( stristr($FRM[SURL], $row[1]) )   derr(1007, "Banned Website URL or Domain '$row[1]'");
        break;

      case 'E-mail':
        if( stristr($FRM[EMAIL], $row[1]) )  derr(1007, "Banned E-mail Address '$row[1]'");
        break;

    }

  }
}

?>