<?PHP

###########################
##  AutoRank PHP v1.0.x  ##
###################################################
##  rate.php - site rating interface             ##
###################################################

require('ar.php');


if( !$id )
  derr(1001, "No Member ID Provided");
  

if( $REQUEST_METHOD == 'POST' ) {
  processRating( $id );
}
else {
  displayRatePage( $id );
}

exit;

function processRating( $id ) {
  global $VARS, $HTTP_VIA, $HTTP_X_FORWARDED_FOR, $REMOTE_ADDR, $HTTP_COOKIE, $HTTP_ACCEPT, $HTTP_USER_AGENT, $HTTP_REFERER, $rating;

  if( $rating > $VARS[HR] || $rating < 1 )
    displayConfirm( $id, true );

  // If using the gateway, and requiring cookie enabled browser, check the rate_cookie_id cookie
  if( $VARS[V_RCK] && !strstr($HTTP_COOKIE, "ratecheck_$id=") )
    cheat( 'no_cook', $id );

  // If using cookies to track hits, check the rate_id cookie
  if( $VARS[V_COK] && strstr($HTTP_COOKIE, "ratemult_$id=") )
    cheat( 'mult_cook', $id );

  // If not allowing proxies, check for proxy server
  if( $VARS[V_PXY] && ($HTTP_VIA || $HTTP_X_FORWARDED_FOR) )
    cheat( 'use_proxy', $id );

  // Check for a valid browser
  if( !$HTTP_ACCEPT || !$HTTP_USER_AGENT )
    cheat( 'bad_brwsr', $id );
  
  // Check for valid referer
  if( !strstr($HTTP_REFERER, $VARS[PU]) )
    cheat( 'no_refer', $id );

  // If using banned IPs, check the banned list
  if( $VARS[V_BIP] )
    checkBannedIP( $id, $REMOTE_ADDR );

  // If using IP log, check it
  if( $VARS[V_ILG] )
    checkIP( $id, $REMOTE_ADDR );

  // Update hit count
  $VARS[DBH]->db_query("UPDATE arp_votes SET total=total+$rating,votes=votes+1 WHERE user='$id'");

  if( !$VARS[CRN] )
    checkTime();

  displayConfirm( $id );  
}


// Display the confirmation page to indicate vote has been recorded
function displayConfirm( $id, $cheat = false ) {
  global $VARS, $rating, $HTTP_COOKIE;

  if( $VARS[V_COK] && !$cheat )
    setcookie( "ratemult_$id", time(), time() + $VARS[V_ET] );

  $tpl[RATING] = $rating;

  fparse('_rate_confirm.htmlt', $tpl);
  exit;
}

// Display the gateway page
function displayRatePage( $id ) {
  global $VARS;

  // Set cookie so only cookie enabled browsers can rate sites
  if( $VARS[V_RCK] )
    setcookie( "ratecheck_$id", time(), time() + $VARS[V_ET] );

  for( $i = $VARS[HR]; $i >= 1; $i-- )
    $tpl[SELECT] .= "<option value='$i'>$i</option>\n";

  $row = $VARS[DBH]->db_row("SELECT title,surl,sdes FROM arp_accts WHERE user='$id'");

  if( !$row[0] )
    derr(1015, "Member '$id' Not Found");

  $tpl[USER]  = $id;
  $tpl[TITLE] = $row[0];
  $tpl[SURL]  = $row[1];
  $tpl[OURL]  = $VARS[OU] . "?id=$id&url=" . urlencode($row[1]);
  $tpl[SDES]  = $row[2];
  $tpl[MRATE] = $VARS[HR];

  fparse('_rate_main.htmlt', $tpl);
}

function checkIP( $id, $ip ) {
  global $VARS;

  $row = $VARS[DBH]->db_row("SELECT COUNT(*) FROM arp_vips WHERE user='$id' and ip='$ip'");

  if( $row[0] )
    cheat( 'mult_ip', $id );
  else
    $VARS[DBH]->db_query("INSERT INTO arp_vips VALUES ( '$id', '$ip' )");
}

function checkBannedIP( $id, $ip ) {
  global $VARS;

  $row = $VARS[DBH]->db_row("SELECT COUNT(*) FROM arp_proxy WHERE ip='$ip'");

  if( $row[0] )
    cheat( 'banned_ip', $id );
}

#malediven

function cheat( $msg, $id ) {
  global $HTTP_X_FORWARDED_FOR, $REMOTE_ADDR, $VARS;

  $cheats = array (
                    'mult_ip'   => 'Multiple Rating   -   IP',
                    'mult_cook' => 'Multiple Rating - Cookie',
                    'expr_gate' => 'Expired  Rating  Session',
                    'use_proxy' => 'Using    Proxy    Server',
                    'no_refer'  => 'Bad     Referring    URL',
                    'bad_brwsr' => 'Bad              Browser',
                    'no_cook'   => 'No     Cookie    Support',
                    'banned_ip' => 'Banned     IP    Address'
                  );

  if( $VARS[V_CLG] ) {
    $date = date("H:i m-d-Y");

    $fd = fopen("$VARS[DDIR]/vcheat.log", "a");
    fwrite( $fd, "[ $date ]  [ $cheats[$msg] ]  [ $id ] [ $REMOTE_ADDR ($HTTP_X_FORWARDED_FOR) ]\n" );
    fclose($fd);
  }

  if( $VARS[V_CST] ) {
    $VARS[DBH]->db_query("UPDATE arp_vcheat SET $msg=$msg+1 WHERE user='$id'");
  }

  if( !$VARS[CRN] )
    checkTime();

  displayConfirm( $id, true );
}

function checkTime() {
  global $VARS;

  $curtime = time();
  $vclear  = freadline("$VARS[DDIR]/times/vclear");

  if( $curtime - $vclear >= $VARS[V_CN] ) {
    $VARS[DBH]->db_query("DELETE FROM arp_vips");
    writef("$VARS[DDIR]/times/vclear", $curtime);
  }
}



?>