#!/usr/bin/perl
###########################
##  AutoRank PHP v1.0.x  ##
##########################################################
##  autorankpro.cgi - upgrade from AutoRank Pro v3.0.x  ##
##########################################################

use lib '.';
use strict;
use cgiworks;

$|++;

print "Content-type: text/html\n\n";
$HEADER = 1;

eval {
  require 'arp.pl';
  main();
};

err("$@", 'autorankpro.cgi') if( $@ );
exit;

sub main {
  print "<pre>\nAutoRank Pro v$arp::ver Installation Located\n\n\n";

  fwrite("$DDIR/arp-data.txt", '');
  fwrite("$DDIR/arp-sql.txt", '');

  members();
  bans();
  other();
  html();

  print "\n\nThe conversion process has been completed.\nPlease continue with the next step in the upgrade documentation.\n</pre>";
}

sub members {
  my $mems = dread("$DDIR/members", '\.dat$');
  print "Converting Your Members.......................";
  
  my $reset = freadline("$DDIR/dbs/start");

  for( @{$mems} ) {
    my $mem = $_;
    $mem =~ s/\.dat$//gi;

    my( %md, @junk );

    ( $md{'email'}, $md{'surl'}, $md{'burl'}, $md{'bht'}, $md{'bwd'}, $md{'rurl'}, $md{'title'}, $md{'sdes'}, $md{'cat'}, $md{'icons'}, $md{'time'}, $md{'junk'}, $md{'ratio'}, $md{'psort'}, $md{'precv'}, $md{'psent'}, $md{'porank'}, $md{'pcrank'}, $md{'junk'}, $md{'pass'}, $md{'susp'}, $md{'lckd'}, $md{'inact'}, $md{'fld1'}, $md{'fld2'}, $md{'fld3'} ) = split(/\|/, freadline("$DDIR/members/$mem.dat"));
    ( $md{'recv'}, $md{'sent'}, $md{'trecv'}, $md{'tsent'}, @junk ) = split(/\|/, freadline("$DDIR/members/$mem.cnt"));

    $md{'pass'} = unpack('u', $md{'pass'});
    $md{'cat'}  = 'General' if( $md{'cat'} eq '' );
    $md{'susp'} = $md{'susp'} eq '0' ? 'N' : 'Y';
    $md{'lckd'} = $md{'lckd'} eq '0' ? 'N' : 'Y';
    $md{'porank'} = '9999999' if( $md{'porank'} eq 'N/A' );
    $md{'pcrank'} = '9999999' if( $md{'pcrank'} eq 'N/A' );
    $md{'psort'} = '0' if( $md{'psort'} eq 'N/A' );
    $md{'psent'} = '0' if( $md{'psent'} eq 'N/A' );
    $md{'precv'} = '0' if( $md{'precv'} eq 'N/A' );
    
    for( keys %md ) {
      $md{$_} =~ s/\\//gi;
      $md{$_} =~ s/'/\\'/gi;
      chomp($md{$_});
    }

    fappend("$DDIR/arp-sql.txt", "INSERT INTO arp_accts VALUES ( '$mem', '$md{'email'}', '$md{'surl'}', '$md{'burl'}', '$md{'bht'}', '$md{'bwd'}', '$md{'rurl'}', '$md{'title'}', '$md{'sdes'}', '$md{'cat'}', '$md{'icons'}', '$md{'time'}', '$md{'ratio'}', '$md{'pass'}', '$md{'fld1'}', '$md{'fld2'}', '$md{'fld3'}', 'Y', '$md{'susp'}', '$md{'lckd'}', '$reset' );\n");
    fappend("$DDIR/arp-sql.txt", "INSERT INTO arp_hits  VALUES ( '$mem', '$md{'recv'}', '$md{'sent'}', '$md{'trecv'}', '$md{'tsent'}', '$md{'psort'}', '$md{'precv'}', '$md{'psent'}', '$md{'porank'}', '$md{'pcrank'}', '$md{'inact'}' );\n");
    fappend("$DDIR/arp-sql.txt", "INSERT INTO arp_votes VALUES ( '$mem', 0, 0 );\n");
    fappend("$DDIR/arp-sql.txt", "INSERT INTO arp_rank  VALUES ( '$mem', 9999999, 9999999 );\n");
    fappend("$DDIR/arp-sql.txt", "INSERT INTO arp_hcheat VALUES ( '$mem', 0, 0, 0, 0, 0, 0, 0, 0 );\n");
    fappend("$DDIR/arp-sql.txt", "INSERT INTO arp_vcheat VALUES ( '$mem', 0, 0, 0, 0, 0, 0, 0, 0 );\n");
  }

  print "Done (" . scalar( @{$mems} ) . ")\n";
}

sub bans {
  my $num = dbsize("$DDIR/dbs/email.ban");
  $num += dbsize("$DDIR/dbs/url.ban");
  $num += dbsize("$DDIR/dbs/word.ban");

  print "Converting Your Banned Items..................";
  
  my $line;

  for( @{ freadall("$DDIR/dbs/email.ban") } ) {
    chomp($line = $_);
    $line =~ s/'/\\'/gi;
    fappend("$DDIR/arp-sql.txt", "INSERT INTO arp_bans VALUES ( 'E-mail', '$line' );\n") if( $line ne '' );
  }

  for( @{ freadall("$DDIR/dbs/word.ban") } ) {
    chomp($line = $_);
    $line =~ s/'/\\'/gi;
    fappend("$DDIR/arp-sql.txt", "INSERT INTO arp_bans VALUES ( 'Word', '$line' );\n") if( $line ne '' );
  }

  for( @{ freadall("$DDIR/dbs/url.ban") } ) {
    chomp($line = $_);
    $line =~ s/'/\\'/gi;
    fappend("$DDIR/arp-sql.txt", "INSERT INTO arp_bans VALUES ( 'URL', '$line' );\n") if( $line ne '' );
  }

  print "Done ($num)\n";
}

sub html {
  print "Converting Your Ranking Page HTML.............";

  for( @{ dread("$DDIR/html", '^[^.]') } ) {
    fappend("$DDIR/arp-data.txt", "Database: html/$_\n");

    require "$DDIR/html/$_";

    $HTML::HEAD =~ s/#%CURL%#/#%PURL%#/gi;
    $HTML::HEAD =~ s/#%URL%#/#%OURL%#/gi;
    $HTML::HEAD =~ s/#%DESC%#/#%SDES%#/gi;
    $HTML::HEAD =~ s/#%SOMURL%#/#%SOMOURL%#/gi;
    $HTML::HEAD =~ s/#%SOMDESC%#/#%SOMSDES%#/gi;
    $HTML::HEAD =~ s/index\.cgi/quick\.php/gi;
    $HTML::HEAD =~ s/search\.cgi/search\.php/gi;

    $HTML::TEMP =~ s/#%CURL%#/#%PURL%#/gi;
    $HTML::TEMP =~ s/#%URL%#/#%OURL%#/gi;
    $HTML::TEMP =~ s/#%DESC%#/#%SDES%#/gi;
    $HTML::TEMP =~ s/#%SOMURL%#/#%SOMOURL%#/gi;
    $HTML::TEMP =~ s/#%SOMDESC%#/#%SOMSDES%#/gi;
    $HTML::TEMP =~ s/index\.cgi/quick\.php/gi;
    $HTML::TEMP =~ s/search\.cgi/search\.php/gi;

    $HTML::FOOT =~ s/#%CURL%#/#%PURL%#/gi;
    $HTML::FOOT =~ s/#%URL%#/#%OURL%#/gi;
    $HTML::FOOT =~ s/#%DESC%#/#%SDES%#/gi;
    $HTML::FOOT =~ s/#%SOMURL%#/#%SOMOURL%#/gi;
    $HTML::FOOT =~ s/#%SOMDESC%#/#%SOMSDES%#/gi;
    $HTML::FOOT =~ s/index\.cgi/quick\.php/gi;
    $HTML::FOOT =~ s/search\.cgi/search\.php/gi;

    fappend("$DDIR/arp-data.txt", "<?PHP\n\$HEAD = <<<HEAD\n$HTML::HEAD\nHEAD;\n\n\$TEMP = <<<TEMP\n$HTML::TEMP\nTEMP;\n\n\$FOOT = <<<FOOT\n$HTML::FOOT\nFOOT;\n\n?>\n");
  }

  print "Done\n";
}

sub other {
  print "Converting Your Icons.........................";

  for( @{ dread("$DDIR/icons", '^[^.]') } ) {
    fappend("$DDIR/arp-data.txt", "Database: icons/$_\n" . ${freadalls("$DDIR/icons/$_")} . "\n");
  }

  fappend("$DDIR/arp-data.txt", "Database: times/start\n" . freadline("$DDIR/dbs/start") . "\n"); 

  print "Done\n";
}