<?PHP

###########################
##  AutoRank PHP v1.0.x  ##
###################################################
##  admin.php - administrative interface         ##
###################################################

chdir('..');

include('ar.php');

if( !$REMOTE_USER )
  derr(1000, '.htaccess Validation Required');

if( !file_exists("$VARS[DDIR]/vars.php") )
  derr(1026, "Run setup.php First");

if( $REQUEST_METHOD == 'POST' ) {
  parsePost(false);
  $FRM[fnct]();
}
else {
  displayMain();
}


function displayMain( $msg = '' ) {
  global $VARS, $time;
  include("$VARS[IDIR]/_admin_main.inc");
}

function displayHCheat() {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_hcheat.inc");
}

function displayVCheat() {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_vcheat.inc");
}

function displayError() {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_error.inc");
}

function displayTemp() {
  global $VARS,$FRM;
  include("$VARS[IDIR]/_admin_temp.inc");
}

function displayChpass() {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_chpass.inc");
}

function displayBackup() {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_backup.inc");
}

function displayBannedIPs( $msg = '' ) {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_banips.inc");
}

function displayIcons( $msg = '' ) {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_icons.inc");
}

function displayReject( $msg = '' ) {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_reject.inc");
}

function displayBans( $msg = '' ) {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_bans.inc");
}

function displayComments( $msg = '' ) {
  global $VARS, $FRM, $id;
  include("$VARS[IDIR]/_admin_comments.inc");
}

function displayEditCmmt() {
  global $VARS, $FRM, $cid;
  include("$VARS[IDIR]/_admin_editcmmt.inc");
}

function displayList() {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_list.inc");
}

function displayRev( $msg = '' ) {
  global $VARS, $FRM;
  if( !$VARS[REV] ) derr(1018, "Not Reviewing New Accounts");
  include("$VARS[IDIR]/_admin_review.inc");
}

function displayRevEdit( $msg = '' ) {
  global $VARS, $FRM;
  if( !$VARS[EREV] ) derr(1018, "Not Reviewing Account Edits");
  include("$VARS[IDIR]/_admin_ereview.inc");
}

function displayGate() {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_gate.inc");
}

function displayRate() {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_rate.inc");
}

function displayMember( $msg = '' ) {
  global $VARS, $FRM, $id, $time;
  include("$VARS[IDIR]/_admin_member.inc");
}

function displayEditAcct() {
  global $VARS, $FRM, $id;
  include("$VARS[IDIR]/_admin_editacct.inc");
}

function displayAll( $msg = '' ) {
  global $VARS, $FRM, $time;
  include("$VARS[IDIR]/_admin_all.inc");
}

function displaySearch( $msg = '' ) {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_search.inc");
}

function displayHtml() {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_html.inc");
}

function displayManual( $msg = '' ) {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_manual.inc");
}

function displayBreaks( $msg = '' ) {
  global $VARS, $FRM;
  include("$VARS[IDIR]/_admin_breaks.inc");
}

function displayStats() {
  global $VARS, $FRM, $time;
  include("$VARS[IDIR]/_admin_stats.inc");
}

function displayMail() {
  global $VARS, $FRM, $id;
  include("$VARS[IDIR]/_admin_mail.inc");
}

function displayHTally() {
  global $VARS, $FRM, $id;
  include("$VARS[IDIR]/_admin_htally.inc");
}

function displayVTally() {
  global $VARS, $FRM, $id;
  include("$VARS[IDIR]/_admin_vtally.inc");
}

#############################################################################################
#############################################################################################
#############################################################################################

function backupData() {
  global $VARS, $FRM, $time, $host, $user, $pass, $db;

  if( !$FRM[file] || !$FRM[sql] )
    derr(1001, "You must enter filenames for both");

  $dirs = array( 'html', 'icons', 'breaks', 'mails', 'times' );

  writef("$VARS[DDIR]/$FRM[file]", '');

  while( list($key,$dir) = each($dirs) ) {
    $dh = opendir("$VARS[DDIR]/$dir"); 
    while( $file = readdir($dh) ) { 
      if( $file != '.' && $file != '..' && is_file("$VARS[DDIR]/$dir/$file") ) { 
        fappend("$VARS[DDIR]/$FRM[file]", "Database: $dir/$file\n" . freadall("$VARS[DDIR]/$dir/$file") . "\n");
      } 
    }
  }
  closedir($dh);

  system("$VARS[MDUMP] -t -h$host -u$user -p$pass $db >$VARS[DDIR]/$FRM[sql]");

  writef("$VARS[DDIR]/times/backup", $time);
  displayMain("HTML Data Has Been Backed Up To $FRM[file]<br>SQL Data Has Been Backed Up To $FRM[sql]");
}

function restoreData() {
  global $VARS, $FRM, $host, $user, $pass, $db;

  if( !$FRM[file] || !$FRM[sql] )
    derr(1001, "You must enter filenames for both");

  $fd = @fopen("$VARS[DDIR]/$FRM[file]", 'r') or err("Cannot read from $VARS[DDIR]/$FRM[file]");
  while( $line = fgets($fd, 4096) ) {
    if( eregi("^Database: (.*)\n", $line, $regs) ) {
      $file = $regs[1];
      writef("$VARS[DDIR]/$file", '');
      continue;
    }
    fappend("$VARS[DDIR]/$file", $line);
  }
  fclose($fd);

  system("$VARS[MYSQL] -f -h$host -u$user -p$pass $db <$VARS[DDIR]/$FRM[sql]");

  displayMain("Data Has Been Restored");
}


function createGate() {
  global $FRM, $VARS;

  $FRM[html] = str_replace("\r", '', $FRM[html]);
  $FRM[html] = str_replace('#%URL%#', '<'.'?PHP echo $VARS[IU] ?'.'>', $FRM[html]);
  $FRM[html] = str_replace('#%CAT%#', '<'.'?PHP echo $cat ?\>', $FRM[html]);
  $FRM[html] = str_replace('#%ID%#', '<'.'?PHP echo $id ?\>', $FRM[html]);
  $FRM[html] = str_replace('#%SES%#', '<'.'?PHP echo $ses ?\>', $FRM[html]);

  $tpl[GATE] = $FRM[html];
  
  writef("$VARS[DDIR]/in.php", vparseRet( freadall("$VARS[TDIR]/_in.phpt"), $tpl ));

  displayMain("Custom Version of in.php Has Been Created");
}

function listEmails() {
  global $VARS, $FRM;

  $special = array ('\t' => "\t", '\n' => "\n", '\r\n' => "\r\n");

  $ch = $FRM[ch];
  if( $special[$ch] )
     $ch = $special[$ch];

  writef("$VARS[DDIR]/emails.txt", '');

  $res = $VARS[DBH]->db_query("SELECT distinct(email) FROM arp_accts");

  while( $row = $VARS[DBH]->db_nextrow($res) ) {
    if( $FRM[file] )
      fappend("$VARS[DDIR]/emails.txt", "$row[0]$ch");
    else
      print "$row[0]$ch";
  }

  if( $FRM[file] )
    displayMain("All E-mails Written To emails.txt In the Data Directory");
}

function updateComment() {
  global $VARS, $FRM;

  $FRM[cmmt] = str_replace('>', '&gt;', $FRM[cmmt]);
  $FRM[cmmt] = str_replace('<', '&lt;', $FRM[cmmt]);

  while( list($key,$val) = each($FRM) )
    $FRM[$key] = addslashes(stripslashes($val));

  $VARS[DBH]->db_query("UPDATE arp_cmmts SET cmmt='$FRM[cmmt]',email='$FRM[email]',ip='$FRM[ip]',name='$FRM[name]' WHERE id='$FRM[cid]'");

  displayComments("Selected Comment Has Been Updated");
}

function deleteComment() {
  global $VARS, $FRM, $cid;

  if( !is_array($cid) )
    derr(1001, "No Comment Selected");

  while( list($key,$val) = each($cid) )
    $VARS[DBH]->db_query("DELETE FROM arp_cmmts WHERE id='$val'");

  displayComments("Selected Comment(s) Have Been Deleted");
}

function sendMail() {
  global $FRM, $VARS;

  if( $FRM[ids] == 'ALLMEMBERS' ) {
    
    $res = $VARS[DBH]->db_query("SELECT * FROM arp_accts");

    while( $row = $VARS[DBH]->db_nextrow($res) ) {
      mailMember($row[1], stripslashes($FRM[sub]), stripslashes($FRM[msg]), $VARS[EM], $row);
    }

  }
  else {

    $id = explode(',', $FRM[ids]);
    while( list($key,$val) = each($id) ) {
      $row = $VARS[DBH]->db_row("SELECT * FROM arp_accts WHERE user='$val'");
      mailMember($row[1], stripslashes($FRM[sub]), stripslashes($FRM[msg]), $VARS[EM], $row);
    }
    
  }

  $FRM[from]("Selected Accounts Have Been E-mailed");
}

function processInactive() {
  global $VARS, $FRM, $id;

  if( !$FRM[inact] )
    derr(1001, "No Inactive Value Was Entered");

  $res = $VARS[DBH]->db_query("SELECT user FROM arp_hits WHERE inact >= $FRM[inact]");
  $num = $VARS[DBH]->db_numrows($res);

  if( !$num )
    derr(1020, "No Members Have Been Inactive For $FRM[inact] Or More Resets");

  if( !is_array($id) )
    $id = array();

  while( $row = $VARS[DBH]->db_nextrow($res) )
    array_push($id, $row[0]);

  $FRM[what] == 'mail' ? displayMail() : deleteMember();
}

function listRerank() {
  global $VARS, $time;

  rerankList(true);

  writef("$VARS[DDIR]/times/rerank", $time);
  writef("$VARS[DDIR]/times/rerank.frm", 'Manual');
  displayMain("List Has Been Reranked");
}

function listReset() {
  global $VARS, $time;
  resetList();
  writef("$VARS[DDIR]/times/reset", $time);
  writef("$VARS[DDIR]/times/reset.frm", 'Manual');
  displayMain("List Has Been Reset");
}

function clearAdminStats() {
  global $VARS;

  $VARS[DBH]->db_query("DELETE FROM arp_astat");

  displayMain("Administrative Stats have Been Cleared");
}

function restoreDef() {
  global $VARS;

  $pages = array_merge( explode(',', $VARS[OP]), explode(',', $VARS[CP]) );
  $def   = freadall("$VARS[DDIR]/def.html");

  while( list($key,$val) = each($pages) )
    if( $val != '' )
      writef("$VARS[DDIR]/html/$val", $def);

  displayMain("Default HTML Has Been Restored");
}

function saveBreak() {
  global $VARS, $FRM;

  $break = $FRM[loc];

  if( $FRM[all] )
    $break = $FRM[bpages] == 'Overall' ? $VARS[BO] : $VARS[BC];

  $breaks = explode(',', $break);
  while( list($key,$val) = each($breaks) )
    writef("$VARS[DDIR]/breaks/$val.$FRM[bpages]", stripslashes($FRM[html]) . "\n");
  
  $FRM[loc] = '';
  displayBreaks("List Break(s) Have Been Saved");
}

function loadBreak() {
  displayBreaks("Selected List Break Has Been Loaded");
}

function updateHtml() {
  global $FRM, $VARS;

  $FRM[head] = str_replace("\r", "", stripslashes($FRM[head]));
  $FRM[foot] = str_replace("\r", "", stripslashes($FRM[foot]));
  $FRM[temp] = str_replace("\r", "", stripslashes($FRM[temp]));
  $FRM[fill] = str_replace("\r", "", stripslashes($FRM[fill]));

  $FRM[head] = str_replace('$', '\$', $FRM[head]);
  $FRM[foot] = str_replace('$', '\$', $FRM[foot]);
  $FRM[temp] = str_replace('$', '\$', $FRM[temp]);
  $FRM[fill] = str_replace('$', '\$', $FRM[fill]);
  
  $FRM[head] = ereg_replace("[[:space:]]+$", "", $FRM[head]); 
  $FRM[temp] = ereg_replace("[[:space:]]+$", "", $FRM[temp]); 
  $FRM[foot] = ereg_replace("[[:space:]]+$", "", $FRM[foot]);
  $FRM[fill] = ereg_replace("[[:space:]]+$", "", $FRM[fill]);

  $pages = explode(',', $FRM[pages]);
  while( list($key,$val) = each($pages) )
    if( $val )
      writef("$VARS[DDIR]/html/$val", "<" . "?PHP\n\n\$HEAD = <<<HEAD\n" . $FRM[head] . "\nHEAD;\n\n\$TEMP = <<<TEMP\n" . $FRM[temp] . "\nTEMP;\n\n\$FILL = <<<FILL\n" . $FRM[fill] . "\nFILL;\n\n\$FOOT = <<<FOOT\n" . $FRM[foot] . "\nFOOT;\n\n?" .">\n");

  displayMain("HTML Has Been Updated");
}


function addAccount() {
  global $FRM, $VARS;
  checkInput();

  $FRM[TURL] = $VARS[IU] . "?id=$FRM[USER]";
  $FRM[IURL] = $VARS[PU] . "/image.php?id=$FRM[USER]";

  $time = time();
  $VARS[DBH]->db_query("INSERT INTO arp_accts VALUES ( '$FRM[USER]', '$FRM[EMAIL]', '$FRM[SURL]', '$FRM[BURL]', '$FRM[BHT]', '$FRM[BWD]', '$FRM[RURL]', '$FRM[TITLE]', '$FRM[SDES]', '$FRM[CAT]', '', '$time',  '1.000',  '$FRM[PASS]',  '$FRM[FLD1]', '$FRM[FLD2]', '$FRM[FLD3]', 'Y', 'N', 'N', $time )");
  $VARS[DBH]->db_query("INSERT INTO arp_hits  VALUES ( '$FRM[USER]', 0, 0, 0, 0, 0, 0, 0, 9999999, 9999999, 0 )");
  $VARS[DBH]->db_query("INSERT INTO arp_votes VALUES ( '$FRM[USER]', 0, 0 )");
  $VARS[DBH]->db_query("INSERT INTO arp_rank  VALUES ( '$FRM[USER]', 9999999, 9999999 )");
  $VARS[DBH]->db_query("INSERT INTO arp_vcheat VALUES ( '$FRM[USER]', 0, 0, 0, 0, 0, 0, 0, 0 )");
  $VARS[DBH]->db_query("INSERT INTO arp_hcheat VALUES ( '$FRM[USER]', 0, 0, 0, 0, 0, 0, 0, 0 )");

  if( $FRM[send] ) {
    $sub = false;
    $row = array("$FRM[USER]", "$FRM[EMAIL]", "$FRM[SURL]", "$FRM[BURL]", "$FRM[BHT]", "$FRM[BWD]", "$FRM[RURL]", "$FRM[TITLE]", "$FRM[SDES]", "$FRM[CAT]", "", "$time",  "1.000",  "$FRM[PASS]",  "$FRM[FLD1]", "$FRM[FLD2]", "$FRM[FLD3]", "Y", "N", "N", "$time");
    mailMember($FRM[EMAIL], $sub, freadall("$VARS[TDIR]/_email_added.etmpl"), $VARS[EM], $row );
  }

  displayManual("Account '$FRM[USER]' Has Been Added");
}

function updateAccount() {
  global $FRM, $VARS, $icons;
  
  if( is_array($icons) )
    $icon = join(',', $icons);

  while( list($key,$val) = each($FRM) ) {
    $FRM[$key] = addslashes(stripslashes($FRM[$key]));
    $FRM[$key] = str_replace("<", "&lt;", $FRM[$key]);
    $FRM[$key] = str_replace(">", "&gt;", $FRM[$key]);
  }

  $VARS[DBH]->db_query("UPDATE arp_accts SET email='$FRM[email]',surl='$FRM[surl]',title='$FRM[title]',sdes='$FRM[sdes]',burl='$FRM[burl]',bht='$FRM[bht]',bwd='$FRM[bwd]',cat='$FRM[cat]',rurl='$FRM[rurl]',pass='$FRM[pass]',susp='$FRM[susp]',lckd='$FRM[lckd]',ratio='$FRM[ratio]',fld1='$FRM[fld1]',fld2='$FRM[fld2]',fld3='$FRM[fld3]',icons='$icon' WHERE user='$FRM[id]'");
  $VARS[DBH]->db_query("UPDATE arp_hits  SET recv='$FRM[recv]',sent='$FRM[sent]',trecv='$FRM[trecv]',tsent='$FRM[tsent]',inact='$FRM[inact]' WHERE user='$FRM[id]'");
  $VARS[DBH]->db_query("UPDATE arp_votes SET votes='$FRM[votes]',total='$FRM[total]' WHERE user='$FRM[id]'");

  if( $FRM[show] == 'All' )
    $FRM[start] = 0;
  else
    $FRM[start] = $FRM[start] - $FRM[show];

  $FRM[from]("Account '$FRM[id]' Has Been Updated");
}


function deleteMember() {
  global $VARS, $FRM, $id;

  if( !is_array($id) && !$FRM[id] )
    derr(1001, "No Member Selected");
    
  if( !is_array($id) )
    $id = array($FRM[id]);

  while( list($key,$val) = each($id) ) {
    $VARS[DBH]->db_query("DELETE FROM arp_accts WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_hits  WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_votes WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_hips  WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_vips  WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_hcheat WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_vcheat WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_mstat WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_rank  WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_cmmts WHERE user='$val'");

    if( file_exists("$VARS[GD]/$val.gif") )
      @unlink("$VARS[GD]/$val.gif");

    if( file_exists("$VARS[GD]/$val.jpg") )
      @unlink("$VARS[GD]/$val.jpg");
  }

  if( $FRM[show] == 'All' )
    $FRM[start] = 0;
  else
    $FRM[start] = $FRM[start] - $FRM[show];

  $FRM[from]("Selected Account(s) Have Been Deleted");
}


function approveEdit() {
  global $VARS, $FRM, $id;

  if( !is_array($id) )
    derr(1001, "No Accounts Selected");

  while( list($key,$val) = each($id) ) {
    $row = $VARS[DBH]->db_row("SELECT * FROM arp_edit WHERE user='$val'");

    while( list($num,$item) = each($row) ) {
      $row[$num] = addslashes(stripslashes($row[$num]));
    }

    $VARS[DBH]->db_query("UPDATE arp_accts SET email='$row[1]',surl='$row[2]',burl='$row[3]',bht='$row[4]',bwd='$row[5]',rurl='$row[6]',title='$row[7]',sdes='$row[8]',cat='$row[9]',pass='$row[10]',fld1='$row[11]',fld2='$row[12]',fld3='$row[13]' WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_edit WHERE user='$val'");
  }

  displayRevEdit("Selected Edits Have Been Approved");
}


function rejectEdit() {
  global $VARS, $FRM, $id;

  if( !is_array($id) )
    derr(1001, "No Accounts Selected");

  while( list($key,$val) = each($id) ) {
    $VARS[DBH]->db_query("DELETE FROM arp_edit WHERE user='$val'");
  }

  displayRevEdit("Selected Edits Have Been Rejected");
}


function approveAcct() {
  global $VARS, $FRM, $id;

  if( !is_array($id) )
    derr(1001, "No Accounts Selected");

  while( list($key,$val) = each($id) ) {
    $row = $VARS[DBH]->db_row("SELECT * FROM arp_accts WHERE user='$val'");
    $VARS[DBH]->db_query("UPDATE arp_accts SET app='Y' WHERE user='$val'");

    if( $VARS[EML] ) {
      $sub = false;
      mailMember( $row[1], $sub, freadall("$VARS[TDIR]/_email_approved.etmpl"), $VARS[EM], $row );
    }
  }

  displayRev("Selected Members Have Been Approved");
}

function rejectAcct() {
  global $VARS, $FRM, $id;

  if( !is_array($id) )
    derr(1001, "No Accounts Selected");

  while( list($key,$val) = each($id) ) {
    $row = $VARS[DBH]->db_row("SELECT * FROM arp_accts WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_accts WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_hits  WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_votes WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_hips  WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_vips  WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_hcheat WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_vcheat WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_mstat WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_rank  WHERE user='$val'");
    $VARS[DBH]->db_query("DELETE FROM arp_cmmts WHERE user='$val'");
    
    if( $VARS[EML] && $FRM["rej_$val"] != 'none' ) {
      $sub = false;
      mailMember( $row[1], $sub, freadall("$VARS[DDIR]/mails/" . $FRM["rej_$val"]), $VARS[EM], $row );
    }
  }

  displayRev("Selected Members Have Been Rejected");
}

function unlockMember() {
  global $VARS, $FRM;

  $VARS[DBH]->db_query("UPDATE arp_accts SET lckd='N' WHERE user='$FRM[id]'");

  displayMember("Account '$FRM[id]' Has Been Unlocked");
}

function lockMember() {
  global $VARS, $FRM;

  $VARS[DBH]->db_query("UPDATE arp_accts SET lckd='Y' WHERE user='$FRM[id]'");

  displayMember("Account '$FRM[id]' Has Been Locked");
}

function activateMember() {
  global $VARS, $FRM;

  $time = time();
  $VARS[DBH]->db_query("UPDATE arp_accts SET susp='N' WHERE user='$FRM[id]'");

  displayMember("Account '$FRM[id]' Has Been Activated");
}

function suspendMember() {
  global $VARS, $FRM;

  $VARS[DBH]->db_query("UPDATE arp_accts SET susp='Y' WHERE user='$FRM[id]'");
  $VARS[DBH]->db_query("UPDATE arp_rank SET rank=9999999,crank=9999999 WHERE user='$FRM[id]'");

  displayMember("Account '$FRM[id]' Has Been Suspended");
}

function addBanIP() {
  global $VARS, $FRM;

  if( !$FRM[ban] )
    derr(1001, "No Items Entered");

  $ban  = str_replace("\r", '', $FRM[ban]);
  $bans = explode("\n", $ban);

  while( list($key,$val) = each($bans) )
    if( $val && !$VARS[DBH]->db_count("SELECT COUNT(*) FROM arp_proxy WHERE ip='$val'") )
      $VARS[DBH]->db_query("INSERT INTO arp_proxy VALUES ( '$val' )");

  displayBannedIPs("Selected IPs Have Been Added");
}

function remBanIP() {
  global $VARS, $FRM;

  if( !$FRM[ban] )
    derr(1001, "No Items Entered");

  $ban  = str_replace("\r", '', $FRM[ban]);
  $bans = explode("\n", $ban);

  while( list($key,$val) = each($bans) )
    if( $val )
      $VARS[DBH]->db_query("DELETE FROM arp_proxy WHERE ip='$val'");

  displayBannedIPs("Selected IPs Have Been Removed");
}

function addBan() {
  global $VARS, $FRM;

  if( !$FRM[ban] )
    derr(1001, "No Items Entered");

  $ban  = str_replace("\r", '', $FRM[ban]);
  $bans = explode("\n", $ban);

  while( list($key,$val) = each($bans) )
    if( $val && !$VARS[DBH]->db_count("SELECT COUNT(*) FROM arp_bans WHERE type='$FRM[type]' AND ban='$val'") )
      $VARS[DBH]->db_query("INSERT INTO arp_bans VALUES ( '$FRM[type]', '$val' )");

  displayBans("Selected Items Have Been Added");
}

function remBan() {
  global $VARS, $FRM;

  if( !$FRM[ban] )
    derr(1001, "No Items Entered");

  $ban  = str_replace("\r", '', $FRM[ban]);
  $bans = explode("\n", $ban);

  while( list($key,$val) = each($bans) )
    if( $val )
      $VARS[DBH]->db_query("DELETE FROM arp_bans WHERE type='$FRM[type]' and ban='$val'");

  displayBans("Selected Items Have Been Removed");
}

function saveReject() {
  global $VARS, $FRM;

  if( !$FRM[id] )
    derr(1001, "No E-mail ID Entered");

  writef("$VARS[DDIR]/mails/$FRM[id]", stripslashes($FRM[html]));

  $msg = "E-mail '$FRM[id]' Has Been Saved";
  $FRM[id] = $FRM[html] = '';

  include("$VARS[IDIR]/_admin_reject.inc");
}

function loadReject() {
  global $VARS, $FRM;

  if( !$FRM[id] )
    derr(1001, "No E-mail ID Entered");

  if( !file_exists("$VARS[DDIR]/mails/$FRM[id]") )
    derr(1003, "E-mail Not Found");

  $msg = "E-mail '$FRM[id]' Has Been Loaded";
  
  include("$VARS[IDIR]/_admin_reject.inc");
}

function deleteReject() {
  global $VARS, $FRM;

  if( !$FRM[id] )
    derr(1001, "No E-mail ID Entered");

  if( file_exists("$VARS[DDIR]/mails/$FRM[id]") )
    unlink("$VARS[DDIR]/mails/$FRM[id]");

  $msg = "E-mail '$FRM[id]' Has Been Deleted";
  $FRM[html] = $FRM[id] = '';

  include("$VARS[IDIR]/_admin_reject.inc");
}


function saveIcon() {
  global $VARS, $FRM;

  if( !$FRM[id] )
    derr(1001, "No Icon ID Entered");

  writef("$VARS[DDIR]/icons/$FRM[id]", stripslashes($FRM[html]));

  $msg = "Icon '$FRM[id]' Has Been Saved";
  $FRM[id] = $FRM[html] = '';

  include("$VARS[IDIR]/_admin_icons.inc");
}

function loadIcon() {
  global $VARS, $FRM;

  if( !$FRM[id] )
    derr(1001, "No Icon ID Entered");

  if( !file_exists("$VARS[DDIR]/icons/$FRM[id]") )
    derr(1003, "Icon Not Found");

  $msg = "Icon '$FRM[id]' Has Been Loaded";
  
  include("$VARS[IDIR]/_admin_icons.inc");
}

function deleteIcon() {
  global $VARS, $FRM;

  if( !$FRM[id] )
    derr(1001, "No Icon ID Entered");

  if( file_exists("$VARS[DDIR]/icons/$FRM[id]") )
    unlink("$VARS[DDIR]/icons/$FRM[id]");

  $msg = "Icon '$FRM[id]' Has Been Deleted";
  $FRM[html] = $FRM[id] = '';

  include("$VARS[IDIR]/_admin_icons.inc");
}


function updatePass() {
  global $VARS, $FRM;

  if( $FRM[un] && $FRM[pw] )
    writef("./admin/.htpasswd", "$FRM[un]:" . crypt(stripslashes($FRM[pw])));
  else
    derr(1001, "Username or Password Left Blank");

  displayMain("Admin Username/Password Updated");
}

function clearMemStats() {
  global $VARS;
  $VARS[DBH]->db_query("DELETE FROM arp_mstat");
  displayMain("Member Stats Have Been Cleared");
}

function clearHTally() {
  global $FRM, $VARS;

  $VARS[DBH]->db_query("UPDATE arp_hcheat SET mult_ip=0,mult_cook=0,expr_gate=0,use_proxy=0,no_refer=0,bad_brwsr=0,no_cook=0,banned_ip=0 WHERE user='$FRM[id]'");

  $FRM[from]("Hit Cheat Tally Has Been Cleared For '$FRM[id]'");
}

function clearVTally() {
  global $FRM, $VARS;

  $VARS[DBH]->db_query("UPDATE arp_vcheat SET mult_ip=0,mult_cook=0,expr_gate=0,use_proxy=0,no_refer=0,bad_brwsr=0,no_cook=0,banned_ip=0 WHERE user='$FRM[id]'");

  $FRM[from]("Rate Cheat Tally Has Been Cleared For '$FRM[id]'");
}

function clearHIPs() {
  global $VARS;
  $VARS[DBH]->db_query("DELETE FROM arp_hips");
  writef("$VARS[DDIR]/times/hclear", time());
  displayMain("Hit IP Logs Have Been Cleared");
}

function clearVIPs() {
  global $VARS;
  $VARS[DBH]->db_query("DELETE FROM arp_vips");
  writef("$VARS[DDIR]/times/vclear", time());
  displayMain("Rate IP Logs Have Been Cleared");
}

function updateTemp() {
  global $VARS, $FRM; 
  writef("$VARS[TDIR]/$FRM[temp]", str_replace("\r", '', stripslashes($FRM[html])));
  displayMain("$FRM[temp] Template Updated");
}

function clearHCheat() {
  global $VARS;
  writef("$VARS[DDIR]/hcheat.log", '');
  displayMain("Hit Cheat Log Has Been Cleared");
}

function clearVCheat() {
  global $VARS;
  writef("$VARS[DDIR]/vcheat.log", '');
  displayMain("Rate Cheat Log Has Been Cleared");
}

function clearError() {
  global $VARS;
  writef("$VARS[DDIR]/error.log", '');
  displayMain("Error Log Has Been Cleared");
}

function resetRatings() {
  global $VARS;
  $VARS[DBH]->db_query("UPDATE arp_votes SET votes=0,total=0");
  displayMain("Ratings Have Been Reset");
}

function resetHits() {
  global $VARS, $FRM;

  $time = time();
  $VARS[DBH]->db_query("UPDATE arp_hits SET trecv=0,tsent=0");
  $VARS[DBH]->db_query("UPDATE arp_accts SET reset=$time");

  displayMain("Total and Average Hit Counts Have Been Reset");
}

function execute() {
  global $FRM;
  $FRM['function']();
}

## Check input when manually adding an account
function checkInput( ) {
  global $FRM, $VARS;

  if( $VARS[DBH]->db_count("SELECT COUNT(*) FROM arp_accts WHERE user='$FRM[USER]'") )
    derr(1012, "Username Taken");

  ## Check for properly formatted URLs and E-mails
  if( !eregi("^[[:alnum:]][[:alnum:].-]+@[[:alnum:].-]+\.[[:alnum:].-]+", $FRM[EMAIL]) )    derr(1008, "Invalid E-mail Address");
  if( !eregi("^http://[[:alnum:].-]+\.[[:alnum:].-]+", $FRM[SURL]) )                        derr(1009, "Invalid Site URL");
  if( $FRM[BURL] && !eregi("^http://[[:alnum:].-]+\.[[:alnum:].-]+", $FRM[BURL]) )          derr(1009, "Invalid Banner URL");
  if( $VARS[RCP] && !eregi("^http://[[:alnum:].-]+\.[[:alnum:].-]+", $FRM[RURL]) )          derr(1009, "Invalid Reciprocal Link URL");


  ## Other checks
  if( !$FRM[TITLE] || !$FRM[SDES] )           derr(1001, "Title or Description Blank") ;
  if( strlen($FRM[TITLE]) > $VARS[MT] )       derr(1010, "Site Title Oversized");
  if( strlen($FRM[SDES]) > $VARS[MD] )        derr(1010, "Description Oversized");
  if( $adding && strlen($FRM[USER]) < 4 )     derr(1010, "Username Too Short");
  if( $adding && strlen($FRM[USER]) > 15 )    derr(1010, "Username Too Long");
  if( strlen($FRM[PASS]) < 4 )                derr(1010, "Password Too Short");
  if( !ereg("^[[:alnum:]]+$", $FRM[USER]) )   derr(1011, "Invalid Character In Username");
  

  ## Check user defined fields
  if( $VARS[FD1] && !$FRM[FLD1] ) derr(1001, "$VARS[F1] Left Blank");
  if( $VARS[FD2] && !$FRM[FLD2] ) derr(1001, "$VARS[F2] Left Blank");
  if( $VARS[FD3] && !$FRM[FLD3] ) derr(1001, "$VARS[F3] Left Blank");

  include('http.php');

  ## Check URLs that were supplied
  if( $VARS[CHU] ) {
    $req = new HTTP;
    $req->Status($FRM[SURL]);

    if( $FRM[RURL] )
      $req->Status($FRM[RURL]);

    if( $FRM[BURL] )
      $req->Status($FRM[BURL]);
  }

  ## Download the banner if either option is enabled
  if( $FRM[BURL] && ($VARS[DBN] || $VARS[DBC]) ) {
    $req = new HTTP;
    $req->Get($FRM[BURL]);

    $fd = @fopen("$VARS[GD]/$FRM[USER]", 'w') or err("Could not write banner data to file");
    $req->PrintHTML($fd);
    fclose($fd);
    @chmod("$VARS[GD]/$FRM[USER]", 0666);

    ## width height type(1 = GIF, 2 = JPG, 3 = PNG, 4 = SWF)
    $dims = GetImageSize("$VARS[GD]/$FRM[USER]");

    if( !$dims ) {
      unlink("$VARS[GD]/$FRM[USER]");
      derr(1032, "Invalid Image Format");
    }

    if( filesize("$VARS[GD]/$FRM[USER]") > $VARS[BB] ) {
      unlink("$VARS[GD]/$FRM[USER]");
      derr(1033, "Banner Size Too Large");
    }

    $FRM[BWD] = $dims[0];
    $FRM[BHT] = $dims[1];

    ## If serving banners from this server, get the proper extension, and setup the banner URL
    if( $VARS[DBN] ) {
      $fe = $dims[2] == 1 ? 'gif' : 'jpg';
      rename("$VARS[GD]/$FRM[USER]", "$VARS[GD]/$FRM[USER].$fe");
      $FRM[BURL] = "$VARS[GU]/$FRM[USER].$fe";
    }
    else {
      unlink("$VARS[GD]/$FRM[USER]");
    }
  }


  ## If banner URL is supplied, check height and widths
  if( $FRM[BURL] ) {
    if( $FRM[BHT] > $VARS[BH] ) derr(1017, "Banner Height Too Large");
    if( $FRM[BWD] > $VARS[BW] ) derr(1017, "Banner Width Too Large");
    if( !$FRM[BHT] ) $FRM[BHT] = $VARS[BH];
    if( !$FRM[BWD] ) $FRM[BWD] = $VARS[BW];
  }

  ## If no banner is supplied, but a default banner has been setup, use the default
  if( !$FRM[BURL] && $VARS[DB] ) {
    $FRM[BURL] = $VARS[DB];
    $FRM[BHT]  = $VARS[DH];
    $FRM[BWD]  = $VARS[DW];
  }

  $FRM[APP] = 'Y';

  ## add slashes so the database likes all input
  while( list($key, $val) = each($FRM) )
    $FRM[$key] = addslashes(stripslashes($val));

  reset($FRM);

  ## Make sure valid category was choosen
  $found = false;
  $cats = explode(',', $VARS[CT]);
  while( list($key,$val) = each($cats) )
    if( $FRM[CAT] == $val )
      $found = true;

  if( !$found ) derr(1034, "Invalid Category Selected");
}


?>