<?PHP

##########################################################
##  PHP Works Library v1.0.0                 5/31/2001  ##
##########################################################

$VARS[DDIR] = './data';             ## The path to your data directory
$VARS[TDIR] = './templates';        ## The path to your templates directory
$VARS[IDIR] = './inc';              ## The path to your inc directory

function checkpass( $entered, $good ) {
  if( crypt( $entered, substr($good, 0, 2) ) != $good )
    derr(1000, "Invalid Password Entered");
}

function fparse( $file, &$tpl ) {
  global $VARS;
  $fh = @fopen( "$VARS[TDIR]/$file", 'r' ) or err("Cannot open $file for reading");

  while( !feof( $fh ) )
    $line .= fgets( $fh, 4096 );  

  fclose( $fh );
  
  // Replace all known template values
  while( list( $key, $val ) = each( $tpl ) ) {
    $val  = stripslashes($val);
    $line = str_replace("#%$key%#", "$val", $line);
  }

  // Delete any leftover template values
  $line = ereg_replace( "#%([^%]+)%#", "", $line );

  reset($tpl);

  print $line;
}

function vparse( $data, &$tpl ) {
  global $VARS;
  
  // Replace all known template values
  while( list( $key, $val ) = each( $tpl ) ) {
    $val  = stripslashes($val);
    $data = str_replace("#%$key%#", "$val", $data);
  }

  // Delete any leftover template values
  $data = ereg_replace("#%([^%]+)%#", "", $data);

  reset($tpl);

  print $data;
}

function vparseRet( $data, &$tpl ) {
  global $VARS;
  
  // Replace all known template values
  while( list( $key, $val ) = each( $tpl ) ) {
    $val  = stripslashes($val);
    $data = str_replace("#%$key%#", "$val", $data);
  }

  // Delete any leftover template values
  $data = ereg_replace("#%([^%]+)%#", "", $data);

  reset($tpl);

  return $data;
}

function parsePost( $rem = false ) {
  global $FRM;

  if( is_array($FRM) ) {
    while( list($key,$val) = each($FRM) ) {
      if( $rem ) {
        $FRM[$key] = str_replace("<", "&lt;", $FRM[$key]);
        $FRM[$key] = str_replace(">", "&gt;", $FRM[$key]);
      }
    }

    reset($FRM);
  }
}

function freadline($file) {
  $fd = @fopen($file, 'r') or err("Cannot read from $file");
  $line = fgets($fd, 4096);
  fclose($fd);
  chop($line);
  return $line;
}

function freadall($file) {
  $fd = @fopen($file, 'r') or err("Cannot read from $file");
  while( $line = fgets($fd, 4096) )
    $html .= $line;
  fclose($fd);
  return $html;
}

function writef($file, $data) {
  $fd = @fopen($file, 'w') or err("Cannot write to $file");
  flock($fd, 2);
  fwrite($fd, $data);
  fclose($fd);
  @chmod($file, 0666);
}

function fappend($file, $data) {
  $fd = @fopen($file, 'a') or err("Cannot append to $file");
  flock($fd, 2);
  fwrite($fd, $data);
  fclose($fd);
  @chmod($file, 0666);
}

function filetofile( $source, $destin ) {
  $src  = @fopen( $source, 'r') or err("Cannot read from $source");
  $dest = @fopen( $destin, 'a') or err("Cannot append to $destin");

  fputs( $dest, fread($src, filesize($source)) );

  fclose( $src );
  fclose( $dest );
}

function timetostr($time) {
  $time   = time() - $time;
  $days   = intval($time / (60*60*24));
  $string = "";
  
  if ($days > 0) $string .= $days . "d ";
  $time   -= $days * 60*60*24;
  $hours   = intval($time / (60*60));
  if ($hours > 0) $string .= $hours."h ";
  $time   -= $hours *60*60;
  $minutes = intval($time / 60);
  if ($minutes > 0) $string .= $minutes."m ";
  $time   -= $minutes * 60;
  $seconds = $time . "s";
  $string .= $seconds;
  
  return $string;
}

function derr( $num, $desc ) {
  global $VARS;

  require("$VARS[DDIR]/errors.php");

  $tpl['LERR'] = $err[$num];
  $tpl['SERR'] = $desc;
  fparse('_error_data.htmlt', $tpl);

  exit;
}

function err( $msg ) {
?>

<html>
<head>
  <title>A Fatal Error Has Occurred</title>
</head>
<body>

<pre>
A FATAL ERROR HAS OCCURRED
==========================
Description  :   <?PHP echo "$msg\n" ?>
</pre>

</body>
</html>

<?PHP
    exit;
}

?>