<?PHP

###########################
##  AutoRank PHP v1.0.x  ##
###################################################
##  sort.php - sorting functions                 ##
###################################################

$ranks = "FROM arp_accts,arp_hits,arp_votes WHERE arp_accts.user=arp_hits.user AND arp_accts.user=arp_votes.user AND arp_accts.app='Y' AND arp_accts.susp='N'";
$sort_ranks = array (

                 'in'    => "SELECT *,(arp_hits.recv * arp_accts.ratio) as sort $ranks AND (arp_hits.recv * arp_accts.ratio) >= $VARS[MH] ORDER BY sort DESC",
                 'out'   => "SELECT *,arp_hits.sent as sort $ranks AND arp_hits.sent >= $VARS[MH] ORDER BY arp_hits.sent DESC",
                 'tin'   => "SELECT *,(arp_hits.trecv * arp_accts.ratio) as sort $ranks AND (arp_hits.trecv * arp_accts.ratio) >= $VARS[MH] ORDER BY sort DESC",
                 'tout'  => "SELECT *,arp_hits.tsent as sort $ranks AND arp_hits.tsent >= $VARS[MH] ORDER BY sort DESC",
                 'ipday' => "SELECT *,(IF( ($time - reset) > 86400, ((arp_hits.trecv * arp_accts.ratio) / (($time - reset) / 86400) ), (arp_hits.trecv * arp_accts.ratio) )) as sort $ranks AND (IF( ($time - reset) > 86400, ((arp_hits.trecv * arp_accts.ratio) / (($time - reset) / 86400) ), (arp_hits.trecv * arp_accts.ratio) )) >= $VARS[MH] ORDER BY sort DESC",
                 'ipwek' => "SELECT *,(IF( ($time - reset) > 604800, ((arp_hits.trecv * arp_accts.ratio) / (($time - reset) / 604800) ), (arp_hits.trecv * arp_accts.ratio) )) as sort $ranks AND (IF( ($time - reset) > 604800, ((arp_hits.trecv * arp_accts.ratio) / (($time - reset) / 604800) ), (arp_hits.trecv * arp_accts.ratio) )) >= $VARS[MH] ORDER BY sort DESC",
                 'ipmth' => "SELECT *,(IF( ($time - reset) > 2592000, ((arp_hits.trecv * arp_accts.ratio) / (($time - reset) / 2592000) ), (arp_hits.trecv * arp_accts.ratio) )) as sort $ranks AND (IF( ($time - reset) > 2592000, ((arp_hits.trecv * arp_accts.ratio) / (($time - reset) / 2592000) ), (arp_hits.trecv * arp_accts.ratio) )) >= $VARS[MH] ORDER BY sort DESC",
                 'opday' => "SELECT *,(IF( ($time - reset) > 86400, (arp_hits.tsent / (($time - reset) / 86400) ), arp_hits.tsent )) as sort $ranks AND (IF( ($time - reset) > 86400, (arp_hits.tsent / (($time - reset) / 86400) ), arp_hits.tsent )) >= $VARS[MH] ORDER BY sort DESC",
                 'opwek' => "SELECT *,IF( ($time - reset) > 604800, (arp_hits.tsent / (($time - reset) / 604800) ), arp_hits.tsent ) as sort $ranks AND (IF( ($time - reset) > 604800, (arp_hits.tsent / (($time - reset) / 604800) ), arp_hits.tsent )) >= $VARS[MH] ORDER BY sort DESC",
                 'opmth' => "SELECT *,IF( ($time - reset) > 2592000, (arp_hits.tsent / (($time - reset) / 2592000) ), arp_hits.tsent ) as sort $ranks AND (IF( ($time - reset) > 2592000, (arp_hits.tsent / (($time - reset) / 2592000) ), arp_hits.tsent )) >= $VARS[MH] ORDER BY sort DESC",
                 'trat'  => "SELECT *,arp_votes.votes as sort $ranks AND arp_votes.votes >= $VARS[MH] ORDER BY sort DESC",
                 'arat'  => "SELECT *,(IF( arp_votes.votes > 0, (arp_votes.total/arp_votes.votes), 0 )) as sort $ranks AND arp_votes.votes >= $VARS[MH] ORDER BY sort DESC"

               );

$sort_reset = array (

                 'in'    => "SELECT *,(arp_hits.recv * arp_accts.ratio) as sort $ranks ORDER BY sort DESC",
                 'out'   => "SELECT *,arp_hits.sent as sort $ranks ORDER BY sort DESC",
                 'tin'   => "SELECT *,(arp_hits.trecv * arp_accts.ratio) as sort $ranks ORDER BY sort DESC",
                 'tout'  => "SELECT *,arp_hits.tsent as sort $ranks ORDER BY sort DESC",
                 'ipday' => "SELECT *,(IF( ($time - reset) > 86400, ((arp_hits.trecv * arp_accts.ratio) / (($time - reset) / 86400) ), (arp_hits.trecv * arp_accts.ratio) )) as sort $ranks ORDER BY sort DESC",
                 'ipwek' => "SELECT *,(IF( ($time - reset) > 604800, ((arp_hits.trecv * arp_accts.ratio) / (($time - reset) / 604800) ), (arp_hits.trecv * arp_accts.ratio) )) as sort $ranks ORDER BY sort DESC",
                 'ipmth' => "SELECT *,(IF( ($time - reset) > 2592000, ((arp_hits.trecv * arp_accts.ratio) / (($time - reset) / 2592000) ), (arp_hits.trecv * arp_accts.ratio) )) as sort $ranks ORDER BY sort DESC",
                 'opday' => "SELECT *,(IF( ($time - reset) > 86400, (arp_hits.tsent / (($time - reset) / 86400) ), arp_hits.tsent )) as sort $ranks ORDER BY sort DESC",
                 'opwek' => "SELECT *,(IF( ($time - reset) > 604800, (arp_hits.tsent / (($time - reset) / 604800) ), arp_hits.tsent )) as sort $ranks ORDER BY sort DESC",
                 'opmth' => "SELECT *,(IF( ($time - reset) > 2592000, (arp_hits.tsent / (($time - reset) / 2592000) ), arp_hits.tsent )) as sort $ranks ORDER BY sort DESC",
                 'trat'  => "SELECT *,arp_votes.votes as sort $ranks ORDER BY sort DESC",
                 'arat'  => "SELECT *,(IF( arp_votes.votes > 0, (arp_votes.total/arp_votes.votes), 0 )) as sort $ranks ORDER BY sort DESC"

               );

$admin = "FROM arp_accts,arp_hits,arp_votes WHERE arp_accts.user=arp_hits.user AND arp_accts.user=arp_votes.user AND arp_accts.app='Y' $cat";
$sort_admin = array (

                 'in'    => "SELECT *,(arp_hits.recv * arp_accts.ratio) as sort $admin ORDER BY sort DESC",
                 'out'   => "SELECT *,arp_hits.sent as sort $admin ORDER BY sort DESC",
                 'tin'   => "SELECT *,(arp_hits.trecv * arp_accts.ratio) as sort $admin ORDER BY sort DESC",
                 'tout'  => "SELECT *,arp_hits.tsent as sort $admin ORDER BY sort DESC",
                 'ipday' => "SELECT *,(IF( ($time - reset) > 86400, ((arp_hits.trecv * arp_accts.ratio) / (($time - reset) / 86400) ), (arp_hits.trecv * arp_accts.ratio) )) as sort $admin ORDER BY sort DESC",
                 'ipwek' => "SELECT *,(IF( ($time - reset) > 604800, ((arp_hits.trecv * arp_accts.ratio) / (($time - reset) / 604800) ), (arp_hits.trecv * arp_accts.ratio) )) as sort $admin ORDER BY sort DESC",
                 'ipmth' => "SELECT *,(IF( ($time - reset) > 2592000, ((arp_hits.trecv * arp_accts.ratio) / (($time - reset) / 2592000) ), (arp_hits.trecv * arp_accts.ratio) )) as sort $admin ORDER BY sort DESC",
                 'opday' => "SELECT *,(IF( ($time - reset) > 86400, (arp_hits.tsent / (($time - reset) / 86400) ), arp_hits.tsent )) as sort $admin ORDER BY sort DESC",
                 'opwek' => "SELECT *,(IF( ($time - reset) > 604800, (arp_hits.tsent / (($time - reset) / 604800) ), arp_hits.tsent )) as sort $admin ORDER BY sort DESC",
                 'opmth' => "SELECT *,(IF( ($time - reset) > 2592000, (arp_hits.tsent / (($time - reset) / 2592000) ), arp_hits.tsent )) as sort $admin ORDER BY sort DESC",
                 'trat'  => "SELECT *,arp_votes.votes as sort $admin ORDER BY sort DESC",
                 'arat'  => "SELECT *,(IF( arp_votes.votes > 0, (arp_votes.total/arp_votes.votes), 0 )) as sort $admin ORDER BY sort DESC",
                 'date'  => "SELECT *,arp_accts.time as sort $admin ORDER BY sort DESC",
                 'id'    => "SELECT *,arp_votes.user as sort $admin ORDER BY sort",
                 'act'   => "SELECT *,arp_hits.inact as sort $admin ORDER BY sort DESC"

               );


$opts = array (

                'in'     => 'Hits In Since Last Reset',
                'out'    => 'Hits Out Since Last Reset',
                'tin'    => 'Total Hits In',
                'tout'   => 'Total Hits Out',
                'ipday'  => 'Average Hits In/Day',
                'ipwek'  => 'Average Hits In/Week',
                'ipmth'  => 'Average Hits In/Month',
                'opday'  => 'Average Hits Out/Day',
                'opwek'  => 'Average Hits Out/Week',
                'opmth'  => 'Average Hits Out/Month',
                'arat'   => 'Average Rating',
                'trat'   => 'Number of Ratings',
                'id'     => 'Username',
                'act'    => 'Inactivity',
                'date'   => 'Signup Date'

              );


function sortval( &$row, $sort ) {
  global $VARS, $time;

  //$time = time();

  switch( $sort ) {
    case 'in':
      return round($row[22] * $row[12]);
      break;
    case 'out':
      return $row[23];
      break;
    case 'tin':
      return round($row[24] * $row[12]);
      break;
    case 'tout':
      return $row[25];
      break;
    case 'ipday':
      return getavg( round($row[24] * $row[12]), $time - $row[20], 86400 );
      break;
    case 'ipwek':
      return getavg( round($row[24] * $row[12]), $time - $row[20], 604800 );
      break;
    case 'ipmth':
      return getavg( round($row[24] * $row[12]), $time - $row[20], 2592000 );
      break;
    case 'opday':
      return getavg( $row[25], $time - $row[20], 86400 );
      break;
    case 'opwek':
      return getavg( $row[25], $time - $row[20], 604800 );
      break;
    case 'opmth':
      return getavg( $row[25], $time - $row[20], 2592000 );
      break;
    case 'trat':
      return $row[33];
      break;
    case 'arat':
      return $row[33] ? sprintf("%.$VARS[DR]f", $row[34]/$row[33]) : 0;
      break;
    case 'id':
      return $row[0];
      break;
    case 'act':
      return $row[31];
      break;
    case 'date':
      return date("$VARS[DF] $VARS[TF]", $row[11] + ($VARS[TZ] * 3600));
      break;
  }
}


?>