<?php
  // Filename: ADMIN_HILFE.php
  //
  // Modul: ADMIN_HILFE
  //
  // Autoren: Jos Fontanil & Reto Glanzmann
  //
  // Zweck: Beinhaltet alle Hilfe-Texte fr USER und ADMIN Pages
  //
  // Sicherheitsstatus:        *** ADMIN ***
  //
  // Version: 1.2
  //
  // CVS-Version / Datum: $Id: ADMIN_HILFE.php,v 1.15 2002/09/20 19:59:10 fontajos Exp $
  //
  // -----------------------------------------------------------------------
  //
  // Lizenz
  // ======
  // PhPepperShop Shopsystem
  // Copyright (C) 2001  Reto Glanzmann, Jos Fontanil
  //
  // This program is free software; you can redistribute it and/or modify
  // it under the terms of the GNU General Public License as published by
  // the Free Software Foundation; either version 2 of the License, or
  // (at your option) any later version.
  //
  // This program is distributed in the hope that it will be useful,
  // but WITHOUT ANY WARRANTY; without even the implied warranty of
  // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  // GNU General Public License for more details.
  //
  // You should have received a copy of the GNU General Public License
  // along with this program; if not, write to the Free Software
  // Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  //
  // -----------------------------------------------------------------------  
  // Damit jedes andere Modul ueberpruefen kann ob dieses hier schon "included" ist
  // wird folgende Vairable auf true gesetzt (Name = Name des Moduls ohne .php)
  $ADMIN_HILFE = true;

  // -----------------------------------------------------------------------
  // include Pfad anpassen. Dabei werden die unterschiedlichen Delimiter-Zeichen fuer
  // Windows und UNIX/Linux beruecksichtigt. Danke fuer die Idee an Eduard Mas Walgram.
  // Windows --> Delimiter = Strichpunkt | UNIX/Linux --> Delimiter = Doppelpunkt
  if (PHP_OS == "WINNT" || PHP_OS == "WIN32" || strlen($HTTP_ENV_VARS["WINDIR"]) > 0) {$pd = ";";} else {$pd = ":";}
  ini_set("include_path", "./$pd../$pd../../$pd../Frameset$pd./shop/Admin$pd./Admin$pd../Admin$pd/usr/local/lib/php");

  // Einbinden der benoetigten Module (PHP-Scripts)
  // Bei Unklarheiten, siehe include-Hierarchie in der Dokumentation
  if (!isset($initialize)) {include("initialize.php");}
  if (!isset($USER_SQL_BEFEHLE)) {include("USER_SQL_BEFEHLE.php");}
  if (!isset($USER_ARTIKEL_HANDLING)) {include("USER_ARTIKEL_HANDLING.php");}

  // Damit der PhPepperShop auch mit der PHP-Einstellung Register Globals = Off funktioniert, werden die Request Arrays
  // $HTTP_GET_VARS und dann $HTTP_POST_VARS in die Standardsymboltabellen ausgelesen. (Post ueberschreibt dabei GET!)
  extract($HTTP_GET_VARS);
  extract($HTTP_POST_VARS);

  // -----------------------------------------------------------------------
  // HTML_HEAD + body open
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta http-equiv="content-language" content="de">
<meta name="author" content="Jos Fontanil and Reto Glanzmann">
<title>Shophilfe</title>
<LINK REL=STYLESHEET HREF="shopstyles.css" TYPE="text/css">
</head>
<body class="content">
    <P>
<?php

  // -----------------------------------------------------------------------
  // Diese Funktion liefert einen String der den entsprechenden Hilfetext
  // der angeforderten Seite enthaelt
  // Hilfe_ID = Filename und optionalem suffix:  _1 _2 ...
  // Argument: Hilfe_ID
  // Rueckgabewert: Text zur aktuellen Seite (String)
  function getHilfe($Hilfe_ID) {
      global $Database;
      global $sql_getHilfe_1_1;
      global $sql_getHilfe_1_2;
      if (! is_object($Database)) {
          die("<P><H1>USER_ADMIN_HILFE_Error: Datenbank nicht erreichbar</H1></P><BR>\n");
      }
      else {
          // Query ausfuehren und in ResultSet schreiben (Typ ResultSet, siehe database.php)
          $RS = $Database->Query("$sql_getHilfe_1_1".$Hilfe_ID."$sql_getHilfe_1_2");
          if (is_object($RS) && $RS->NextRow()){
              $Hilfetext = $RS->Getfield("Hilfetext");
          }
          else {
              echo "USER_ADMIN_HILFE: getHilfe: Konnte Hilfetext nicht auslesen / Kein Text vorhanden <BR>";
              die("Query: $sql_getHilfe_1_1.$Hilfe_ID.$sql_getHilfe_1_2<BR>");
          }
      }
      return $Hilfetext;
  }// End getHilfe

  //Funktion aufrufen --> Hilfetext einfuegen
  echo "<B>".getHilfe($Hilfe_ID)."</B><BR>";

  // Wenn der Aufruf aus der Artikeleingabemaske erfolgt, folgenden dynamisch erzeugten Zusatz hinzufuegen.
  // Hier werden die Link(s) zusammengestellt um von aussen DIREKT den Artikel anzeigen zu lassen (deep link):
  if ($Hilfe_ID == "Shop_Artikel") {
      // Wenn es sich um einen neuen Artikel handelt, Info ausgeben und beenden:
      if ($Artikel_ID == "") {
          echo "<center>Dies ist ein neuer Artikel, es bestehen noch keine Verweise auf ihn.</center>";
      }
      else {
          // Erstellen des Links von index.php aus
          $Pfadarray = pathinfo($PHP_SELF); // Pfad von PHP_SELF parsen
          $LinkURL = "http://".$HTTP_HOST.str_replace("shop/Admin","",$Pfadarray["dirname"])."index.php";
          $Kategorienarray = getKategorieID_eines_Artikels($Artikel_ID); // Kategorien des Artikels auslesen
          // Fuer jede Kategorie, in welcher sich dieser Artikel befindet einen Deep-Link erstellen:
          foreach ($Kategorienarray as $value) {
              $aktuelleKategorie = new Unterkategorie(); // Kategorieobjekt instanzieren
              $aktuelleKategorie = getKategorie($value); // Kategoriedaten auslesen
              echo "Kategorie: "; // Ausgabestring zusammenstellen...
              if ($aktuelleKategorie->Unterkategorie_von != "") {
                  echo "<i>".$aktuelleKategorie->Unterkategorie_von."</i><tt> --> </tt>";
              }
              echo $aktuelleKategorie->Name.":<br><small>$LinkURL?Kategorie_ID=$value&Artikel_ID=$Artikel_ID</small><br>";
          }
          echo "<br>";
      }
  } // End if Hilfe_ID = Shop_Artikel
  echo '<center><p><A href="javascript:window.close();">Fenster schliessen</a>&nbsp;&nbsp;&nbsp;<a href="javascript:window.print();">Hilfe ausdrucken</a></p></center>';
?>
    </P>
</body>
</html>
<?php
  // End of file------------------------------------------------------------
?>
