<?php
  // Filename: SHOP_KONFIGURATION.php
  //
  // Modul: PhPeppershop, Shopadministration, Konfiguration Menu
  //
  // Autoren: Jos Fontanil & Reto Glanzmann, Zuercher Hochschule Winterthur
  //
  // Zweck: Zeigt die Frames des Backup-Managements an
  //
  // Sicherheitsstatus:        *** ADMIN ***
  //
  // Version: 1.2
  //
  // CVS-Version / Datum: $Id: SHOP_KONFIGURATION.php,v 1.17 2002/09/17 18:26:45 fontajos Exp $
  //
  // -----------------------------------------------------------------------
  //
  // Lizenz
  // ======
  // PhPepperShop Shopsystem
  // Copyright (C) 2001  Reto Glanzmann, Jos Fontanil
  //
  // This program is free software; you can redistribute it and/or modify
  // it under the terms of the GNU General Public License as published by
  // the Free Software Foundation; either version 2 of the License, or
  // (at your option) any later version.
  //
  // This program is distributed in the hope that it will be useful,
  // but WITHOUT ANY WARRANTY; without even the implied warranty of
  // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  // GNU General Public License for more details.
  //
  // You should have received a copy of the GNU General Public License
  // along with this program; if not, write to the Free Software
  // Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  //
  // -----------------------------------------------------------------------  
  // Damit jedes andere Modul ueberpruefen kann ob dieses hier schon "included" ist
  // wird folgende Vairable auf true gesetzt (Name = Name des Moduls ohne .php)
  $SHOP_KONFIGURATION = true;

  // include Pfad anpassen. Dabei werden die unterschiedlichen Delimiter-Zeichen fuer
  // Windows und UNIX/Linux beruecksichtigt. Danke fuer die Idee an Eduard Mas Walgram.
  // Windows --> Delimiter = Strichpunkt | UNIX/Linux --> Delimiter = Doppelpunkt ($pd = path delimiter)
  if (PHP_OS == "WINNT" || PHP_OS == "WIN32" || strlen($HTTP_ENV_VARS["WINDIR"]) > 0) {$pd = ";";} else {$pd = ":";}
  ini_set("include_path", "./$pd../$pd../../$pd../Frameset$pd./shop/Admin$pd./Admin$pd../Admin$pd/usr/local/lib/php");

  // Einbinden der benoetigten Module (PHP-Scripts)
  // Bei Unklarheiten, siehe include-Hierarchie in der Dokumentation
  if (!isset($SHOP_ADMINISTRATION)){include("SHOP_ADMINISTRATION.php");}

  // Damit der PhPepperShop auch mit der PHP-Einstellung Register Globals = Off funktioniert, werden die Request Arrays
  // $HTTP_GET_VARS und dann $HTTP_POST_VARS in die Standardsymboltabellen ausgelesen. (Post ueberschreibt dabei GET!)
  extract($HTTP_GET_VARS);
  extract($HTTP_POST_VARS);

  // Anzeigevariablen initialisieren
  $dbtype = "MySQL"; // Im Moment fix eingegeben, wird noch nicht verwendet
  $dbhost = "localhost";
  $dbname = "phpeppershop";
  $dbadmin = "dbadmin";
  $dbuser = "dbuser";
  $backupadmin = "backupadmin";
  $Shopsettings = getshopsettings();
  $shopversion = $Shopsettings[ShopVersion];

  // Auslesen der Konfigurationsdaten

  // Auslesen der Datei initialize.php (User-DB-Informationen)
  $initialize_file = fopen("../initialize.php","r");
  // Wenn die Datei erfolgreich geoeffnet wurde:
  if ($initialize_file <>0) {
      // Solange kein EOF...
      while ($zeile = fgets($initialize_file,4096)) {
          // Ausgelesene Zeile nach dem Wort TMySQLDatabase absuchen
          $interessant = strstr($zeile, "TMySQLDatabase");
          if (strlen($interessant) > 0) {
              // Abpacken der gefundenen Eintraege in die entsprechenden Variablen:
              $wordarray1 = explode("\"", $interessant);
              $dbhost = $wordarray1[1];
              $dbname = $wordarray1[3];
              $dbuser = $wordarray1[5];
          }// End if interessant
      }// End while zeile
  }// End if initialize_file
  else {
      echo "<HTML><BODY><H1>initialize.php Datei (shop/initialize.php) konnte nicht gelesen werden! --> Abbruch</H1><BR></BODY></HTML>";
      exit;
  }// End else
  fclose($initialize_file);

  // Auslesen der ADMIN_initialize.php (Admin-DB-Informationen
  $ADMIN_initialize_file = fopen("ADMIN_initialize.php","r");
  // Wenn die Datei erfolgreich geoeffnet wurde:
  if ($ADMIN_initialize_file <>0) {
      // Solange kein EOF...
      while ($zeile = fgets($ADMIN_initialize_file,4096)) {
          // Ausgelesene Zeile nach dem Wort TMySQLDatabase absuchen
          $interessant = strstr($zeile, "TMySQLDatabase");
          if (strlen($interessant) > 0) {
              // Abpacken der gefundenen Eintraege in die entsprechenden Variablen:
              $wordarray2 = explode("\"", $interessant);
              $dbadmin = $wordarray2[5];
          }// End if interessant
      }// End while zeile
  }// End if ADMIN_initialize_file
  else {
      echo "<HTML><BODY><H1>ADMIN_initialize.php Datei (shop/Admin/ADMIN_initialize.php) konnte nicht gelesen werden! --> Abbruch</H1><BR></BODY></HTML>";
      exit;
  }// End else
  fclose($ADMIN_initialize_file);

  // Auslesen der Datei ADMIN_backup.php (Backup-DB-Anbindung)
  $ADMIN_backup_file = fopen("ADMIN_backup.php","r");
  // Wenn die Datei erfolgreich geoeffnet wurde:
  if ($ADMIN_backup_file <>0) {
      // Solange kein EOF...
      while ($zeile = fgets($ADMIN_backup_file,4096)) {
          // Ausgelesene Zeile nach dem Wort TMySQLDatabase absuchen
          $interessant = strstr($zeile, "\$dbhost=");
          if (strlen($interessant) > 0) {
              // Abpacken der gefundenen Eintraege in die entsprechenden Variablen:
              $wordarray3 = explode("\"", $interessant);
              $backuparray[0] = $wordarray3[1];
          }// End if interessant
          $interessant = strstr($zeile, "\$dbname=");
          if (strlen($interessant) > 0) {
              // Abpacken der gefundenen Eintraege in die entsprechenden Variablen:
              $wordarray4 = explode("\"", $interessant);
              $backuparray[1] = $wordarray4[1];
          }// End if interessant
          $interessant = strstr($zeile, "\$dbuser=");
          if (strlen($interessant) > 0) {
              // Abpacken der gefundenen Eintraege in die entsprechenden Variablen:
              $wordarray5 = explode("\"", $interessant);
              $backuparray[2] = $wordarray5[1];
              $backupadmin = $wordarray5[1];
          }// End if interessant
      }// End while zeile
  }// End if ADMIN_backup_file
  else {
      echo "<HTML><BODY><H1>ADMIN_backup.php Datei (shop/Admin/ADMIN_backup.php) konnte nicht gelesen werden! --> Abbruch</H1><BR></BODY></HTML>";
      exit;
  }// End else
  fclose($ADMIN_backup_file);

  // Diagnose (Vergleich der drei Woerterlisten auf Diskrepanzen:
  // Datenbank-Hostnamen
  if ($wordarray1[1] <> $wordarray2[1]) {
      $Diagnose[] = "In der Datei initialize.php ist der Datenbank-Hostname verschieden zum Hostnamen in der Datei ADMIN_initialize.php [".$wordarray1[1]." <> ".$wordarray2[1]."]<BR>";
  }
  if ($wordarray1[1] <> $backuparray[0]) {
      $Diagnose[] = "In der Datei initialize.php ist der Datenbank-Hostname verschieden zum Hostnamen in der Datei ADMIN_backup.php [".$wordarray1[1]." <> ".$backuparray[0]."]<BR>";
  }
  if ($wordarray2[1] <> $backuparray[0]) {
      $Diagnose[] = "In der Datei ADMIN_initialize.php ist der Datenbank-Hostname verschieden zum Hostnamen in der Datei ADMIN_backup.php [".$wordarray2[1]." <> ".$backuparray[0]."]<BR>";
  }
  if ($wordarray2[1] == "127.0.0.1" || $backuparray[0] == "127.0.0.1") {
      $Diagnose[] = "Ihr Datenbank Hostrechner wird mit 127.0.0.1 angesprochen. Falls Sie Datenbank-Verbindungsprobleme haben, &auml;ndern Sie diesen Eintrag zu localhost (Dateien: ADMIN_initialize.php, ADMIN_backup.php)<BR>";
  }
  // Datenbanknamen
  if ($wordarray1[3] <> $wordarray2[3]) {
      $Diagnose[] = "In der Datei initialize.php ist der Datenbankname verschieden zum Namen in der Datei ADMIN_initialize.php [".$wordarray1[3]." <> ".$wordarray2[3]."]<BR>";
  }
  if ($wordarray1[3] <> $backuparray[1]) {
      $Diagnose[] = "In der Datei initialize.php ist der Datenbankname verschieden zum Namen in der Datei ADMIN_backup.php [".$wordarray1[3]." <> ".$backuparray[1]."]<BR>";
  }
  if ($wordarray2[3] <> $backuparray[1]) {
      $Diagnose[] = "In der Datei ADMIN_initialize.php ist der Datenbankname verschieden zum Namen in der Datei ADMIN_backup.php [".$wordarray2[3]." <> ".$backuparray[1]."]<BR>";
  }
  // Datenbank Admin Usernamen
  if ($wordarray2[5] <> $backuparray[2]) {
      $Diagnose[] = "In der Datei ADMIN_initialize.php ist der Datenbank Administrator Name verschieden zum Namen in der Datei ADMIN_backup.php [".$wordarray2[5]." <> ".$backuparray[2]."]<BR>";
  }


  // HTML-Darstellung
?>

<HTML>
    <HEAD>
        <TITLE>Shop-Konfiguration</TITLE>
        <META HTTP-EQUIV="content-type" CONTENT="text/html;charset=iso-8859-1">
        <META HTTP-EQUIV="language" CONTENT="de">
        <META HTTP-EQUIV="author" CONTENT="Jose Fontanil & Reto Glanzmann">
        <META NAME="robots" CONTENT="all">
        <LINK REL=STYLESHEET HREF="./shopstyles.css" TYPE="text/css">

        <SCRIPT LANGUAGE="JavaScript">
            <!-- Begin
                function popUp(URL) {
                    day = new Date();
                    id = day.getTime();
                    eval("page" + id + " = window.open(URL, '" + id + "', 'toolbar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=0,width=400,height=300,left = 312,top = 234');");
                }
            // End -->
        </SCRIPT>
    </HEAD>
    <BODY>
    <h1>SHOP KONFIGURATION</h1>
    <h3>Information</h3>
    <P>Hier werden die Konfigurationsdaten dieser PhPepperShop-Installation angezeigt.<BR>
    Sie helfen bei Problemen einfacher an Informationen heran zu kommen.<BR>
    Die Diagnose-Ausgaben bez&uuml;glich der DB-Anbindung funktionieren nur korrekt <BR>
    mit einer MySQL-Datenbank.</P>
    <hr>
    <h3>PhPepperShop Konfigurationsdaten</h3>
    <table border='0' cellpadding='5' cellspacing='0'>
        <tr>
            <td colspan="4">
                <B>PhPepperShop Version</B>
            </td>
        </tr>
        <tr>
            <td>
                Shopversion:
            </td>
            <td>
                &nbsp;
            </td>
            <td>
                <?= $shopversion ?>
            </td>
        </tr>
        <tr>
            <td colspan="4">
                <BR>
                <B>Webserver</B>
            </td>
        </tr>
        <tr>
            <td>
                Webserver Rechnertyp:
            </td>
            <td>
                &nbsp;
            </td>
            <td>
<?php
                // Auslesen des OS-Typs. Anscheinend gibt es dafuer zwei verschiedene Env. Variablen:
                // Mac Erkennung (Basierend auf Erkenntnissen von PHP 4.06, MacOS-X)
                // Windows Erkennung (Basierend auf Erkenntnissen von WinNT 4.0, PHP 4.04pl)
                if (strlen($HTTP_ENV_VARS["WINDIR"]) > 0) {
                    // Bei Windows NT Installationen steht hier oft noch etwas im OS-Feld... falls ja, dann auslesen.
                    $webserver = "Microsoft Windows Betriebssystem";
                    $wintype = ""; // Variable initialisieren
                    if (strlen($HTTP_ENV_VARS["OS"]) > 0) {
                        $wintype = "OS = ".$HTTP_ENV_VARS["OS"]." | ";
                    }
                    $ostype = "$wintype Windowsverzeichnis = ".$HTTP_ENV_VARS["WINDIR"];
                }
                else if (strlen($HTTP_ENV_VARS["HTTP_UA_OS"]) > 0) {
                    $webserver = "Apple Macintosh";
                    if ((strlen($HTTP_ENV_VARS["HTTP_UA_OS"]) > 0) && (strlen($HTTP_ENV_VARS["HTTP_UA_OS"]) > 0)) {
                        $ostype = "UA_OS = ".$HTTP_ENV_VARS["HTTP_UA_OS"]." | UA_CPU = ".$HTTP_ENV_VARS["HTTP_UA_CPU"];
                    }
                }
                // UNIX/Linux Erkennung basierend auf Erkenntnissen von (SuSE Linux 7.1, PHP 4.06)
                else {
                    $webserver = "UNIX/Linux Betriebssystem";
                    $ostype = "OSTYPE = ".$HTTP_ENV_VARS["OSTYPE"];
                }
               echo $webserver." [".$ostype."]";
?>
            </td>
        </tr>
        <tr>
            <td>
                Webserver Software:
            </td>
            <td>
                &nbsp;
            </td>
            <td>
<?php
                echo $HTTP_SERVER_VARS["SERVER_SOFTWARE"];
?>
            </td>
        </tr>
        <tr>
            <td>
                PHP Version:
            </td>
            <td>
                &nbsp;
            </td>
            <td>
<?php
                echo "PHP ".phpversion();
?>
            </td>
        </tr>
        <tr>
            <td colspan="4">
                <BR>
                <B>MySQL-Datenbankanbindung</B>
            </td>
        </tr>
        <tr>
            <td>
                Datenbank Hostrechner:
            </td>
            <td>
                &nbsp;
            </td>
            <td>
                <?= $dbhost ?>
            </td>
        </tr>
        <tr>
            <td>
                Datenbankname:
            </td>
            <td>
                &nbsp;
            </td>
            <td>
                <?= $dbname ?>
            </td>
        </tr>
        <tr>
            <td>
                Datenbank Administrator:
            </td>
            <td>
                &nbsp;
            </td>
            <td>
                <?= $dbadmin ?>
            </td>
        </tr>
        <tr>
            <td>
                Datenbank Backup Administrator:
            </td>
            <td>
                &nbsp;
            </td>
            <td>
                <?= $backupadmin ?>
            </td>
        </tr>
        <tr>
            <td>
                Datenbank User:
            </td>
            <td>
                &nbsp;
            </td>
            <td>
                <?= $dbuser ?>
            </td>
        </tr>
        <tr>
            <td valign="top">
<?php           if (count($Diagnose) == 0) {
                    echo "<font color='009900'>";
                }
                else {
                    echo "<font color='FF0000'>";
                }
?>
                Diagnose:</font>
            </td>
            <td>
                &nbsp;
            </td>
            <td>
<?php
                if (count($Diagnose) == 0) {
                    echo "<font color='009900'> Die Datenbank Konfiguration ist konsistent</font><BR>";
                }
                else {
                    foreach($Diagnose as $value) {
                        echo "<font color='ff0000'>".$value."</font>";
                    }
                    echo "<font color='ff0000'><tt>&nbsp;&nbsp;&nbsp;--></tt> Bitte die entsprechenden Dateien korrigieren, sonst wird der Shop nicht korrekt funktionieren!</font><BR>";
                }
                // Warnung, wenn PhPepperShop im Ein-User-Modus laeuft:
                if ($wordarray1[5] == $wordarray2[5]) {
                    echo "<font color='0000AA'><I>Warnung</I>: Der Shop l&auml;uft im Ein-DB-User-Modus, dies reduziert die Sicherheit, da die Shop-Kunden mit dem gleichen Datenbank Benutzer auf die Datenbank zugreifen, wie der Administrator</font><BR>";
                    echo "<font color='0000AA'><tt>&nbsp;&nbsp;&nbsp;--></tt> Weitere Informationen dazu finden Sie in der Dokumentation (Kapitel Security). Der Shop funktioniert aber auch mit reduzierter Sicherheit uneingeschr&auml;nkt.</font><BR>";
                }
?>
            </td>
        </tr>
        <tr>
            <td colspan="4">
                <BR>
                <B>Grafikunterst&uuml;tzung (GD-Library)</B>
            </td>
        </tr>
        <tr>
            <td valign="top">
<?php
                // Ermitteln, welche Grafikformate mit der aktuellen GD-Library verwendet werden koennen und
                // ob ueberhaupt eine GD-Library installiert ist --> Ausgabe des Resultats
                $gd_png = 0;
                $gd_jpg = 0;
                $gd_gif = 0;
                // bildcheck nur ausfhren, wenn eine gd-library installiert ist
                if (function_exists(ImageTypes)){
                    if (ImageTypes() & IMG_PNG) { $gd_png = 1; }
                    if (ImageTypes() & IMG_JPG) { $gd_jpg = 1; }
                    if (ImageTypes() & IMG_GIF) { $gd_gif = 1; }
                } // end of if function_exists
                if (!$gd_png && !$gd_gif && !$gd_jpg) {
                    echo "<font color='ff0000'>Diagnose:</font>";
                }
                else {
                    echo "<font color='009900'>Diagnose:</font>";
                }
?>
            </td>
            <td>
                &nbsp;
            </td>
            <td>
<?php
                // Ausgabe der Resultate (unterstuetzte Bildformate)
                if ($gd_jpg == 1) { echo "<font color='009900'>Artikelbilder im JPG-Format unterst&uuml;tzt(.jpg oder .jpeg)<br></font>"; }
                if ($gd_png == 1) { echo "<font color='009900'>Artikelbilder im PNG-Format unterst&uuml;tzt(.png)<br></font>"; }
                if ($gd_gif == 1) { echo "<font color='009900'>Artikelbilder im GIF-Format unterst&uuml;tzt(.gif)<br></font>"; }
                if (!$gd_png && !$gd_gif && !$gd_jpg) {
                    echo "<font color='ff0000'>Es ist weder PNG noch JPEG noch GIF Support auf diesem Webserver vorhanden. Es k&ouml;nnen somit keine Produktebilder hochgeladen werden. Wenden Sie sich mit diesem Problem an ihren Webserver-Administrator (GD-Library Problem).</font>";
                }// End if
?>
            </td>
        </tr>
        <tr>
            <td valign="middle">
                <BR>
                <B><font color="000011">Zur&uuml;ck zum Hauptmen&uuml; &nbsp;</font></B>
            </td>
            <td>
                &nbsp;
            </td>
            <td>
                <BR>
                <a href="./Shop_Einstellungen_Menu_1.php" target=_top><img src="../Buttons/bt_zurueck_admin.gif" border="0" alt="Zur&uuml;ck" align="absmiddle"></a>
            </td>
        </tr>
    </table>
    <hr>
    <h3>PHP Konfigurationsinformation</h3>
    <P>Folgende Daten wurden &uuml;ber die PHP-interne Funktion phpinfo() geladen und dargestellt:</P>
    <?php phpinfo(); ?>
    <hr>
    <BR><B><font color="0000AA">Zur&uuml;ck zum Hauptmen&uuml; &nbsp;</font></B>
    <a href="./Shop_Einstellungen_Menu_1.php" target=_top><img src="../Buttons/bt_zurueck_admin.gif" border="0" alt="Zur&uuml;ck" align="absmiddle"></a>
    </BODY>
    </HTML>
<?php
  // End of file-------------------------------------------------------------------------
?>
