<?php
  // Filename: bild_up.php
  //
  // Modul: PHP-Funktionen - SHOP_ADMINISTRATION
  //
  // Autoren: Jos Fontanil & Reto Glanzmann, Zuercher Hochschule Winterthur
  //
  // Zweck: Ein Bild in die Datenbank laden (und Thumbnail davon erzeugen),
  //        sowie der Update eines Artikels (letzter Teil) / neuer Artikel einfuegen.
  //        Diese Funktion musste als eigene Datei ausprogrammiert werden (HTML).
  //
  // Sicherheitsstufe:                     *** ADMIN ***
  //
  // Version: 1.2
  //
  // CVS-Version / Datum: $Id: bild_up.php,v 1.32 2002/10/19 13:02:52 fontajos Exp $
  //
  // -----------------------------------------------------------------------
  //
  // Lizenz
  // ======
  // PhPepperShop Shopsystem
  // Copyright (C) 2001  Reto Glanzmann, Jos Fontanil
  //
  // This program is free software; you can redistribute it and/or modify
  // it under the terms of the GNU General Public License as published by
  // the Free Software Foundation; either version 2 of the License, or
  // (at your option) any later version.
  //
  // This program is distributed in the hope that it will be useful,
  // but WITHOUT ANY WARRANTY; without even the implied warranty of
  // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  // GNU General Public License for more details.
  //
  // You should have received a copy of the GNU General Public License
  // along with this program; if not, write to the Free Software
  // Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  //
  // -----------------------------------------------------------------------  
  // Damit jedes andere Modul ueberpruefen kann ob dieses hier schon "included" ist
  // wird folgende Vairable auf true gesetzt (Name = Name des Moduls ohne .php)
  $bild_up = true;

  // include Pfad anpassen. Dabei werden die unterschiedlichen Delimiter-Zeichen fuer
  // Windows und UNIX/Linux beruecksichtigt. Danke fuer die Idee an Eduard Mas Walgram.
  // Windows --> Delimiter = Strichpunkt | UNIX/Linux --> Delimiter = Doppelpunkt
  if (PHP_OS == "WINNT" || PHP_OS == "WIN32" || strlen($HTTP_ENV_VARS["WINDIR"]) > 0) {$pd = ";";} else {$pd = ":";}
  ini_set("include_path", "./$pd../$pd../../$pd../Frameset$pd./shop/Admin$pd./Admin$pd../Admin$pd/usr/local/lib/php");

  // include, damit wir eine DB-Connection aufbauen koennen und Zugriff auf
  // die verwendeten Funktionen haben:
  // Einbinden der benoetigten Module (PHP-Scripts)
  // Bei Unklarheiten, siehe include-Hierarchie in der Dokumentation
  if (!isset($ADMIN_Database)) {include("ADMIN_initialize.php");}
  if (!isset($SHOP_ADMINISTRATION)) {include("SHOP_ADMINISTRATION.php");}

  // Damit der PhPepperShop auch mit der PHP-Einstellung Register Globals = Off funktioniert, werden die Request Arrays
  // $HTTP_GET_VARS und dann $HTTP_POST_VARS in die Standardsymboltabellen ausgelesen. (Post ueberschreibt dabei GET!)
  extract($HTTP_GET_VARS);
  extract($HTTP_POST_VARS);

  // -----------------------------------------------------------------------
  // Kopf der HTML-Seite (unabhaengig von dem was angezeigt werden soll)
  // inkl. eroeffnendem BODY-Tag
  echo "<HTML><HEAD>";
  echo "<TITLE>Shop</TITLE>";
  echo "<META HTTP-EQUIV=\"content-type\" CONTENT=\"text/html;charset=iso-8859-1\">";
  echo "<META HTTP-EQUIV=\"Expires\" CONTENT=\"Fri, Jan 01 1900 00:00:00 GMT\">";
  echo "<META HTTP-EQUIV=\"Pragma\" CONTENT=\"no-cache\">";
  echo "<META HTTP-EQUIV=\"Cache-Control\" CONTENT=\"no-cache\">";
  echo "<META HTTP-EQUIV=\"language\" CONTENT=\"de\">";
  echo "<META HTTP-EQUIV=\"author\" CONTENT=\"Jos Fontanil & Reto Glanzmann\">";
  echo "<LINK REL=STYLESHEET HREF=\"./shopstyles.css\" TYPE=\"text/css\">";
  echo "<title>Shop</title>";
  echo "</HEAD><BODY>";

  // -----------------------------------------------------------------------
  // Damit wir Zugriff auf in anderen Modulen deklarierte Variablen haben (z.B. SQL-Queries)
  global $Admin_Database;
  global $sql_bild_up_1_1; //Teil 1 der Query 1
  global $sql_bild_up_1_2; //Teil 2 der Query 1

  // -----------------------------------------------------------------------
  // Weiche (siehe hidden-input-Feld im Formular unten), wenn SUBMIT-Button gedrueckt
  // wurde, dann wird per hidden-Field diese Variable true gesetzt und es wird hierhin gesprungen.
  // Code, der nach Ausfllen der Formulardaten ausgefhrt wird: (Nach Submit-Button)
  if ($Speichern) {
         if (! is_object($Admin_Database)) {
             die("<P><H1>b_up_Error: Datenbank nicht erreichbar!</H1></P><BR>");
         }

         // Bild von Formular einlesen (aus temporaer erstellter Datei)
         if(!($form_data == 'none')){
             $gross_temp = "../Bilder/grossbild"; // Tempraerdatei, wo grosses Bild hineingespeichert wird
             $prod_dir = "../ProdukteBilder"; // Verzeichnis, wo sich die Produktebilder befinden
             $file_gr = $Artikel_ID."_gr"; // Dateiname fuer grosses Bild
             $file_kl = $Artikel_ID."_kl"; // Dateiname fuer kleines Bild

             // ueberpruefen, ob hochgeladenes File nicht manipuliert wurde und das File dann in eine temporaere
             // Datei kopieren ($gross_temp)
             if (!move_uploaded_file($form_data, $gross_temp)){
                     echo "<h4>Das Bild wurde nicht korrekt hochgeladen!</h4>";
                     echo "<a href=".$PHP_SELF."?darstellen=20><img src=../Buttons/bt_zurueck_admin.gif border=0></a>";
                 } // end of if

             // Groesse des hochgeladenen Bildes ermitteln
             $groesse = getimagesize($gross_temp);
             $breite=$groesse[0];
             $hoehe=$groesse[1];
             $neueBreite=getThumbnail_Breite(); //Funktion in SHOP_ADMINISTRATION.php definiert
             $neueHoehe=intval($hoehe*$neueBreite/$breite);

             # falls es sich um ein gif-bild handelt
             if($groesse[2]==1) {
                 // GIF
                 $file_gr .= ".gif";
                 $file_kl .= ".gif";
                 $altesBild=ImageCreateFromGIF($gross_temp);
                 $neuesBild=ImageCreate($neueBreite,$neueHoehe);
                 ImageCopyResized($neuesBild,$altesBild,0,0,0,0,$neueBreite,$neueHoehe,$breite,$hoehe);
                 // neu erstelltes Thumbnail ins Produktebilder-Verzeichnis speichern
                 if (!ImageGIF($neuesBild,"$prod_dir/$file_kl")){
                    echo "<h4>Problem beim Speichern des Thumbnails!<br>Die Datei $prod_dir/$file_kl konnte nicht geschrieben werden!</h4>";
                 } // end of if
                 // grosses Produktbild ins Produktebilder-Verzeichnis kopieren
                 if (!copy($gross_temp,"$prod_dir/$file_gr")) {
                    echo "<h4>Kopiervorgang gescheitert!<br>$gross_temp konnte nicht in $prod_dir/$file_gr kopiert werden!</h4>";
                 } // end of if
             }

             # falls es sich um ein jpg-bild handelt
             else if($groesse[2]==2) {
                 // JPG
                 $file_gr .= ".jpg";
                 $file_kl .= ".jpg";
                 $altesBild=ImageCreateFromJPEG($gross_temp);
                 $neuesBild=ImageCreate($neueBreite,$neueHoehe);
                 ImageCopyResized($neuesBild,$altesBild,0,0,0,0,$neueBreite,$neueHoehe,$breite,$hoehe);
                 // neu erstelltes Thumbnail ins Produktebilder-Verzeichnis speichern
                 if (!ImageJPEG($neuesBild,"$prod_dir/$file_kl")){
                    echo "<h4>Problem beim Speichern des Thumbnails!<br>Die Datei $prod_dir/$file_kl konnte nicht geschrieben werden!</h4>";
                 } // end of if
                 // grosses Produktbild ins Produktebilder-Verzeichnis kopieren
                 if (!copy($gross_temp,"$prod_dir/$file_gr")) {
                    echo "<h4>Kopiervorgang gescheitert!<br>$gross_temp konnte nicht in $prod_dir/$file_gr kopiert werden!</h4>";
                 } // end of if

             }

             # falls es sich um ein png-bild handelt
             else if($groesse[2]==3) {
                 // PNG
                 $file_gr .= ".png";
                 $file_kl .= ".png";
                 $altesBild=ImageCreateFromPNG($gross_temp);
                 $neuesBild=ImageCreate($neueBreite,$neueHoehe);
                 ImageCopyResized($neuesBild,$altesBild,0,0,0,0,$neueBreite,$neueHoehe,$breite,$hoehe);
                 // neu erstelltes Thumbnail ins Produktebilder-Verzeichnis speichern
                 if (!ImagePNG($neuesBild,"$prod_dir/$file_kl")){
                    echo "<h4>Problem beim Speichern des Thumbnails!<br>Die Datei $prod_dir/$file_kl konnte nicht geschrieben werden!</h4>";
                 } // end of if
                 // grosses Produktbild ins Produktebilder-Verzeichnis kopieren
                 if (!copy($gross_temp,"$prod_dir/$file_gr")) {
                    echo "<h4>Kopiervorgang gescheitert!<br>$gross_temp konnte nicht in $prod_dir/$file_gr kopiert werden!</h4>";
                 } // end of if
             }

             else {
                 die("kein g&uuml;ltiges Bildformat!");
             }

             // aktuelle Bilddaten des Artikels auslesen:
             // [0] -> Bild_gross
             // [1] -> Bild_klein
             // [2] -> Bildtyp
             // [3] -> Bild_last_modified
             $bilddaten = getArtikelBilder($Artikel_ID);

             // ermitteln, ob das alte Produktbild noch von einem anderen Artikel verwendet wird
             // wenn als Resultat 1 zurckgegeben wurde, wird das Bild nur von einem (diesem) Artikel verwendet
             $anzahl = bildmehrmals($bilddaten[0]);
             if ($anzahl < 2 && $bilddaten[0] != "" && $bilddaten[0] != $file_gr ){
                 // grosses Bild lschen
                 if (!unlink ($prod_dir."/".$bilddaten[0])){
                     echo "<br><b>Das grosse Bild $bilddaten[0] konnte nicht gel&ouml;scht werden!";
                 } // end of if
                 // kleines Bild lschen
                 if (!unlink ($prod_dir."/".$bilddaten[1])){
                     echo "<br><b>Das kleine Bild $bilddaten[1] konnte nicht gel&ouml;scht werden!";
                 } // end of if
             } // end of if


             // Informationen, welche Bilder zum Artikel gehoeren, in die Datenbank speichern
             $RS = $Admin_Database->Exec("$sql_bild_up_1_1".addslashes($file_gr)."$sql_bild_up_1_2".addslashes($file_kl)."$sql_bild_up_1_3".addslashes($form_data_type)."$sql_bild_up_1_4".$Artikel_ID."$sql_bild_up_1_5");
             if ($RS) {
                 // Die Query konnte ausgefuehrt werden und es wird true fuer das geglueckte Update zurueck
                 // gemeldet
             echo "<P><H1><B>SHOP ADMINISTRATION</B></H1></P><BR>";
             echo "<P>Der Artikel konnte erfolgreich gespeichert werden</P>";
             echo "<BR><BR><a href='./Shop_Einstellungen_Menu_1.php'><IMG src='../Buttons/bt_weiter_admin.gif' border='0'></a><BR>";
             }
             else {
                echo "<P><H1>b_up_Error: $RS kein Objekt, die Bildlinks konnten nicht in die Datenbank gespeichert werden!</H1></P><BR>";
                die("<P>Query: $sql_bild_up_1_1".$data."$sql_bild_up_1_2".$mini_pic."$sql_bild_up_1_3".$form_data_type."$sql_bild_up_1_4".$Artikel_ID."$sql_bild_up_1_5</P><BR>");
             }
         }
         else {
             echo "<P><H1><B>SHOP ADMINISTRATION</B></H1></P><BR>";
             echo "<P><B><H3>Fehler! Die Datei wurde nicht korrekt hochgeladen</H3></B></P>";
             echo "<BR><BR><a href='./Shop_Einstellungen_Menu_1.php'><IMG src='../Buttons/bt_weiter_admin.gif' border='0'></a><BR>";
         }
  }
  // Weiche: wenn loeschen_Bild uebergeben wird (per Bild-loeschen-Button (ist ein Link), dann
  // wird hierhin gesprungen und das Bild des aktuell bearbeiteten Artikels geloescht
  else if($loeschen_Bild == 1) {
      // aktuelle Bilddaten des Artikels auslesen:
      // [0] -> Bild_gross
      // [1] -> Bild_klein
      // [2] -> Bildtyp
      // [3] -> Bild_last_modified
      $bilddaten = getArtikelBilder($Artikel_ID);
      $anzahl = bildmehrmals($bilddaten[0]);
      if ($anzahl < 2 && $bilddaten[0] != ""){
          // grosses Bild lschen
          if (!unlink ("../ProdukteBilder/".$bilddaten[0])){
              echo "<br><b>Das grosse Bild $bilddaten[0] konnte nicht gel&ouml;scht werden!";
          } // end of if
          // kleines Bild lschen
          if (!unlink ("../ProdukteBilder/".$bilddaten[1])){
              echo "<br><b>Das kleine Bild $bilddaten[1] konnte nicht gel&ouml;scht werden!";
          } // end of if
      } // end of if

      // Eintrag der Bilddaten fr den Artikel lschen
      delBild($Artikel_ID); //Funktion in SHOP_ADMINISTRATION.php definiert
      echo "<P><H1><B>SHOP ADMINISTRATION</B></H1></P><BR>";
      echo "<P>Der Artikel wurde ohne Bild erfolgreich gespeichert!</P>";
      echo "<BR><BR><a href='./Shop_Einstellungen_Menu_1.php'><IMG src='../Buttons/bt_zurueck_admin.gif' border='0'></a><BR>";

  }
  // Weiche --> Eingabeformular anzeigen (Bild-Eingabe)
  else {
    // Um einen neuen Artikel in der DB abzuspeichern, wird er an einer neuen
    // Position (ein SQL-INSERT) eingefuegt.

    // Bevor wir den Artikel der Funktion newArtikel uebergeben koennen, muessen wir aus
    // allen Formularfeldern alle Daten in Variablen speichern. Wenn wir einen bestehenden
    // Artikel updaten, so benoetigt die Funktion upd_Artikel_2(...) dieselben Parameter wie
    // newArtikel(...), nur noch $Artikel_ID dazu. Wir gehen also analog vor.

    // Das aktuelle Datum (Datum des Servers!!!) einfuegen:
    $mydate = array();
    $mydate = getdate();
    $letzteAenderung = $mydate[year]."-".$mydate[mon]."-".$mydate[mday];// Format yyyy-mm-dd

    // Nun gibt es eine Fallunterscheidung: Entweder es handelt sich um einen neuen Artikel,
    // dann muss ein neuer Artikel ge-inserted werden, andernfalls geht es um ein Update eines
    // Artikels. Dementsprechend anders muss man vorgehen.
    // Wenn empty($Artikel_ID) true ist, so handelt es sich um einen neuen Artikel!

    $Optionenarray = array();
    $Variationsarray = array();

    // Optionen und Variationen in Arrays verpacken:
    // Optionen:
    $opt_counter = 1;
    $Optionsname = "Option$opt_counter";
    $Preisname = "Preisdifferenz$opt_counter";
    while (isset($$Optionsname)) {
        $Optionsname = "Option$opt_counter";
        $Preisname = "Preisdifferenz$opt_counter";
        $Optionenarray[urldecode($$Optionsname)] = $$Preisname;
        $Gewichte_Opt[urldecode($$Optionsname)] = $Gewicht_Opt[$opt_counter];
        $opt_counter++;
    }
    // Dasselbe Spiel um herauszufinden wieviele Variationen dieses Artikels existieren
    $var_counter = 1;
    $Variationsname = "Variation$var_counter";
    $Preisname = "Aufpreis$var_counter";
    $Gruppenname = "Gruppe$var_counter";
    while (isset($$Variationsname)) {
        $Variationsname = "Variation$var_counter";
        $Preisname = "Aufpreis$var_counter";
        $Gruppenname = "Gruppe$var_counter";
        $Variationsarray[urldecode($$Variationsname)] = $$Preisname;
        $Variationsgruppenarray[urldecode($$Variationsname)] = $$Gruppenname;
        $Gewichte_Var[urldecode($$Variationsname)] = $Gewicht_Var[$var_counter];
        $var_counter++;
    }

    // Url-encodierte Variablen wieder decodieren

    $Name = urldecode($Name);
    $Artikel_Nr = urldecode($Artikel_Nr);
    $Beschreibung = urldecode($Beschreibung);
    $Link = urldecode($Link);
    $Eingabefeld_text = addslashes(urldecode($Eingabefeld_text));
    $Eingabefeld_param = urldecode($Eingabefeld_param);


    if (!empty($Artikel_ID)) {
        // Einen bestehenden Artikel updaten:
        // Nun wird der bestehende Artikel upgedated. Nur das Bild wird erst spaeter behandelt:
        if (($new_ID = updArtikel_2($Kategorie_IDarray, $Artikel_ID, $Artikel_Nr, $Name, $Beschreibung, $letzteAenderung,
             $Preis, $Aktionspreis, $Gewicht, $MwSt, $Link, $Optionenarray, $Variationsarray, $Variationsgruppenarray, $Gruppentext,
             $Gruppe_darstellen , $Eingabefeld_text, $Eingabefeld_param, $Gewichte_Opt, $Gewichte_Var, true))) {

            $erfolg = true; // Diese Variable liefert weiter unten (HTML-Teil) eine Meldung
        }
/*        else {
            die("<B><H1>Artikel-Update: Es gab ein Problem beim Einfuegen in die Datenbank! (bild_up.php->updArtikel_2)</H1></B><BR>");
        }*/
    }
    else {
        // Da jetzt bekannt ist, in welche(r) Kategorie(n) der neue Artikel eingefuegt wird, muss noch der MwSt-default-Satz der Kategorie
        // uebernommen werden (falls angewaehlt). Wenn der Artikel in mehrere Kategorien kommt, so wird der MwSt-Satz der ersten Kategorie
        // gewaehlt
        if ($MwSt == "MwSt_default_Satz") {
            reset($Kategorie_IDarray);
            $MwSt = getDefaultMwStSatz(key($Kategorie_IDarray));
        }

        // Einen neuen Artikel in die Datenbank einfuegen:
        // Nun wird der neue Artikel in der DB gespeichert
        if (($new_ID = newArtikel($Kategorie_IDarray, $Artikel_Nr, $Name, $Beschreibung, $letzteAenderung,
             $Preis, $Aktionspreis, $Gewicht, $MwSt, $Link, $Optionenarray, $Variationsarray, $Variationsgruppenarray, $Gruppentext,
             $Gruppe_darstellen, $Eingabefeld_text, $Eingabefeld_param, $Gewichte_Opt, $Gewichte_Var, true))) {

            $erfolg = true; // Diese Variable liefert weiter unten (HTML-Teil) eine Meldung
        }
/*        else {
            die("<B><H1>Artikel-Update: Es gab ein Problem beim Einfuegen in die Datenbank! (bild_up.php->newArtikel)</H1></B><BR>");
        }*/
    }

    // Im weiteren Script wird die neue Artikel_ID verwendet, aber unter dem Namen der alten ID
    $Artikel_ID = $new_ID;

  // ermitteln, welche Grafikformate mit der aktuellen GD-Library verwendet werden koennen und
  // ob ueberhaupt eine GD-Library installiert ist
  $gd_png = 0;
  $gd_jpg = 0;
  $gd_gif = 0;

  // bildcheck nur ausfhren, wenn eine gd-library installiert ist
  if (function_exists(ImageTypes)){
      if (ImageTypes() & IMG_PNG) { $gd_png = 1; }
      if (ImageTypes() & IMG_JPG) { $gd_jpg = 1; }
      if (ImageTypes() & IMG_GIF) { $gd_gif = 1; }
  } // end of if function_exists

  // aktuelle Bilddaten des Artikels auslesen:
  // [0] -> Bild_gross
  // [1] -> Bild_klein
  // [2] -> Bildtyp
  // [3] -> Bild_last_modified
  $bilddaten = getArtikelBilder($Artikel_ID);


?>

<script language="JavaScript">

function NeuFenster(bild_gr){
 MeinFenster = window.open("pop_up_admin.php?bild_gross="+bild_gr+"", "GrossesBild", "width=640,height=480,scrollbars");
 MeinFenster.focus();
} // end of function NeuFenster

function chkFormular() {
    // ueberpruefen, ob eine .jpg oder .jpeg Datei hochgeladen werden soll
    pfad_datei = document.Formular.form_data.value.toLowerCase();

    // check, ob ueberhaupt ein string eingegeben wurde
    if(pfad_datei == "") {
        alert("Bitte zuerst eine Datei auswhlen!");
        document.Formular.form_data.focus();
        return false;
    } // end of if

    // check, ob eingegebener string mit .jpg oder .jpeg aufhrt
    file3_string = pfad_datei.substring(pfad_datei.length-4,pfad_datei.length);
    file4_string = pfad_datei.substring(pfad_datei.length-5,pfad_datei.length);
    format = 0;

    <?php
    if ($gd_png == 1){
        echo 'if(file3_string == ".png"){'."\n";
        echo "    format = 1;\n";
        echo "} // end of if\n";
    } // end of if

    if ($gd_jpg == 1){
        echo 'if(file3_string == ".jpg" || file4_string == ".jpeg"){'."\n";
        echo "    format = 1;\n";
        echo "} // end of if\n";
    } // end of if

    if ($gd_gif == 1){
        echo 'if(file3_string == ".gif"){'."\n";
        echo "    format = 1;\n";
        echo "} // end of if\n";
    } // end of if

    ?>
    if (format == 0){
        document.Formular.form_data.focus();
        alert("Ungltiges Dateiformat!");
        return false;
    } // end of if

} // end of function chkFormular

</script>

<p><h1><b>SHOP ADMINISTRATION</b></h1></p>
<center>
<form method='post' name='Formular' action='./bild_up.php?Speichern=true&Artikel_ID=<?php echo "$Artikel_ID";?>' enctype='multipart/form-data' onSubmit="return chkFormular()">
<table border=0 width=80%>
  <tr>
    <td colspan=3>
      Der Artikel <?php echo"<B>".stripslashes($Name)."</B>";?> wurde erfolgreich in der Datenbank gespeichert
    </td>
  </tr>
  <tr><td colspan=3><hr></td></tr>
  <tr>
    <td valign=top>
      <b>Momentan aktuelles Produktbild:</b><br>
      Folgendes Artikelbild ist momentan zum Artikel <?php echo"<B>".stripslashes($Name)."</B>";?> gespeichert:<br><br><i>(Falls Sie im Rahmen rechts kein Bild sehen, wurde f&uuml;r diesen Artikel noch kein Artikelbild hochgeladen).</i>
    </td>
    <?php
    if ($bilddaten[1] != ""){
        ?>
        <td width=20% bgcolor=#CCCCCC align=center colspan=2><a href="javascript:NeuFenster('<?php echo "$bilddaten[0]";?>')"><img src="../ProdukteBilder/<?php echo "$bilddaten[1]";?>" border="0"></a></td>
        <?php
    } // end of if
    else{
        echo "<td width=20% bgcolor=#CCCCCC align=center colspan=2>&nbsp;</td>";
    } // end of else
    ?>
  </tr>
  <tr><td colspan=3><hr></td></tr>
  <?php
  // falls, eine GD-Library installiert ist, die mindestens eines der Bildformate jpg, png oder gif untersttzt
  if ($gd_png == 1 || $gd_jpg == 1 || $gd_gif == 1){
      ?>
      <tr>
        <td colspan=3>
          <b>Ein (anderes) Produktbild hochladen:</b><br>
          Wenn Sie f&uuml;r diesen Artikel ein (anderes) Artikelbild hochladen wollen, dr&uuml;cken Sie auf den &quot;Durchsuchen-&quot; bzw. &quot;Browse&quot;-Knopf und w&auml;hlen dann ein Bild auf Ihrer Festplatte aus. Danach klicken Sie auf den Knopf  &quot;Bild hochladen&quot;, damit das Produktbild in die Datenbank gespeichert wird.
          <br><br>
          Folgende(s) Bildformat(e) werden von Ihrem Server untersttzt:
          <br>
            <?php
            if ($gd_png == 1) { echo "- Bilder im PNG-Format (.png)<br>"; }
            if ($gd_jpg == 1) { echo "- Bilder im JPG-Format (.jpg oder .jpeg)<br>"; }
            if ($gd_gif == 1) { echo "- Bilder im GIF-Format (.gif)<br>"; }
            ?>
        </td>
      </tr>
      <tr valign=middle>
        <td colspan=2 valign=middle>
            <input type="hidden" name="MAX_FILE_SIZE" value="1000000">
            <input type="file" name="form_data"  size="40" accept="image/jpeg" align=absmiddle>
        </td>
        <td valign=middle align=center>
          <input type='image' src='../Buttons/bt_neues_bild_hochladen_admin.gif' border='0'>
        </td>
      </tr>
      <?php
  } // end of if
  // falls keine GD-Library auf dem Server installiert ist..
  else{
      ?>
      <tr>
        <td colspan=3>
          <b style='color:#FF0000;'>Keine Grafikuntersttzung installiert!</b><br><br>
          Auf Ihrem Webserver ist keine GD-Library installiert. Diese Library braucht der PhPepperShop, um die Thumbnails (kleine Produktebilder) zu erzeugen. Wenden Sie sich an Ihren Serverbetreiber und bitten Sie Ihn, eine aktuelle GD-Library zu installieren, damit Sie zu Ihren Artikeln auch Bilder hochladen k&ouml;nnen.
          <br><br>
        </td>
      </tr>
  <?php
  } // end of else
  ?>

  <tr><td colspan=3><hr></td></tr>
  <tr>
    <td colspan=2>
      <b>Das Produktbild lschen:</b><br>
      Wenn Sie das zu diesem Artikel geh&ouml;rende Bild (falls vorhanden) l&ouml;schen wollen, dr&uuml;cken Sie auf den Knopf  &quot;vorhandenes Bild l&ouml;schen&quot;.
    </td>
    <td align=center>
      <a href="./bild_up.php?loeschen_Bild=1&Artikel_ID=<?php echo"$new_ID";?>" title="">
         <img src="../Buttons/bt_bild_loeschen_admin.gif" border="0" align="absmiddle"
         alt="Das vorhandene Bild loeschen"></a>
    </td>
  </tr>
  <tr><td colspan=3><hr></td></tr>
  <tr>
    <td colspan=2>
      <b>Weiter, ohne &Auml;nderungen am Produktbild vorzunehmen:</b><br>
      Falls Sie weder ein neues Bild f&uuml;r diesen Artikel hochladen, noch das aktuelle Bild l&ouml;schen wollen, dr&uuml;cken Sie den "Weiter" Knopf.
    </td>
    <td align=center>
      <a href="./Shop_Einstellungen_Menu_1.php" title="Kein Bild hinzufuegen">
         <img src="../Buttons/bt_weiter_admin.gif" border="0" align="absmiddle"
         alt="weiter, ohne &Auml;nderungen"></a>
    </td>
  </tr>
</table>
</form>
</center>
<?php
  }// End else

  // Seite HTML-maessig abschliessen
  echo "</BODY>";
  echo "</HTML>";

  // End of file-----------------------------------------------------------------------
?>
