<?php
  // Filename: bestellung_def.php
  //
  // Modul: Definitions
  //
  // Autoren: Jos Fontanil & Reto Glanzmann
  //
  // Zweck: Definiert die Klasse Bestellung und Artikel_info
  //
  // Sicherheitsstatus:                 *** USER ***
  //
  // Version: 1.2
  //
  // CVS-Version / Datum: $Id: bestellung_def.php,v 1.18 2002/09/20 16:49:55 fontajos Exp $
  //
  // -----------------------------------------------------------------------
  //
  // Lizenz
  // ======
  // PhPepperShop Shopsystem
  // Copyright (C) 2001  Reto Glanzmann, Jos Fontanil
  //
  // This program is free software; you can redistribute it and/or modify
  // it under the terms of the GNU General Public License as published by
  // the Free Software Foundation; either version 2 of the License, or
  // (at your option) any later version.
  //
  // This program is distributed in the hope that it will be useful,
  // but WITHOUT ANY WARRANTY; without even the implied warranty of
  // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  // GNU General Public License for more details.
  //
  // You should have received a copy of the GNU General Public License
  // along with this program; if not, write to the Free Software
  // Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  //
  // -----------------------------------------------------------------------  
  // Damit jedes andere Modul ueberpruefen kann ob dieses hier schon "included" ist
  // wird folgende Vairable auf true gesetzt (Name = Name des Moduls ohne .php)
  $bestellung_def = true;

  // -----------------------------------------------------------------------
  // Definition eines Artikel_info-Objekts:
  // Artikel_info Objekte werden (voraussichtlich) nur in der weiter unten
  // beschriebenen Klasse Bestellung benutzt. Artikel_info Objekte enthalten
  // die Informationen eines Artikels wie er bei einer Bestellung relevant ist
  // Artikel_info-Objekte werden in der Klasse Bestellung im Array Artikelarray
  // abgelegt
  class Artikel_info {
      var $Artikel_ID;
      var $Artikel_Nr;
      var $Name;
      var $Anzahl;
      var $Preis;
      var $Gewicht;
      var $Variationen = array();
      var $Optionen = array();
      var $Zusatzfelder = array();

      //Konstruktor
      function Artikel_info() {
      }

      //putoption legt eine Option eines Artikels im internen Array ab
      function putoption($cle, $wert){
          $this->Optionen[$cle] = $wert;
      }

      //putvariation legt eine Variation eines Artikels im internen Array ab
      function putvariation($cle, $wert){
          $this->Variationen[$cle] = $wert;
      }

      //getalloptionen liefert in einem assoz. Array alle Optionen zurck
      function getalloptionen(){
          $optpaar = array();
          foreach(($this->Optionen) as $keyname => $value){
              $optpaar[$keyname] = $value;
          }
          return $optpaar;
      }

      //getallvariationen liefert in einem assoz. Array alle Variationen zurck
      function getallvariationen(){
          $varpaar = array();
          foreach(($this->Variationen) as $keyname => $value){
              $varpaar[$keyname] = $value;
          }
          return $varpaar;
      }

      //Optionenanzahl liefert die Anzahl Elemente im Array $optionen
      //In v.1.05 wurde die Funktion sizeof() durch count() ersetzt!
      function Optionenanzahl(){
          return count($this->Optionen);
      }
  }// End class Artikel_info

  // -----------------------------------------------------------------------
  // Definition eines Bestellung-Objekts (Treuhandkosten sind nicht hier gespeichert):
  // Kann alle noetigen Information einer Bestellung aufnehmen (Wird fuer
  // Warenkorb-Operationen benoetigt)
  class Bestellung {
      var $Bestellungs_ID;
      var $Session_ID;
      var $Bestellung_abgeschlossen;
      var $Datum;
//      var $Name;    // Seit der Shopversion v.1.05 nicht mehr benoetigt
//      var $Vorname; // Wird spaeter mal entfernt werden
//      var $Adresse1;
//      var $Adresse2;
//      var $PLZ;
//      var $Ort;
//      var $Endpreis;
      var $Bezahlungsart;
      var $Kreditkarten_Hersteller;
      var $Kreditkarten_Nummer;
      var $Kreditkarten_Ablaufdatum;
      var $Kreditkarten_Vorname;
      var $Kreditkarten_Nachname;
      var $Attribut1;
      var $Attribut2;
      var $Attribut3;
      var $Attribut4;
      var $Attributwert1;
      var $Attributwert2;
      var $Attributwert3;
      var $Attributwert4;
      var $Versandkosten;
      var $Mindermengenzuschlag;
      var $Rechnungsbetrag;
      var $Nachnahmebetrag;
      var $Anmerkung;
      var $Artikelarray = array();// Ein Array von Artikel_infos
      var $temp_message_string; //Wenn mit Kreditkarten und externer Zahlungsabwicklung
                                //gearbeitet wird, so muss der E-Mail-Message-String temporaer
                                //zwischengespeichert werden.

      //Konstruktor
      function Bestellung() {
      }

      //putartikel legt einen Artikel (resp. dessen ID und Anzahl) im Array ab
      function putartikel($key, $value){
          $this->Artikelarray[$key] = $value;
      }

      //putallartikel kopiert den angegebenen Array in den eigenen Artikelarray
      function putallartikel($myarray){
          $this->Artikelarray = $myarray;
      }

      //getallartikel liefert in einem assoz. Array alle Artikel-IDs + Anzahlen zurueck
      function getallartikel(){
          $artpaar = array();
          foreach(($this->Artikelarray) as $keyname => $value){
              $artpaar[$keyname] = $value;
          }
          return $artpaar;
      }
     //artikelanzahl liefert die Anzahl Elemente im Array $Artikelarray
      function artikelanzahl(){
          return count($this->Artikelarray);
      }

  }// End class Bestellung
  // End of file-----------------------------------------------------------------------
?>
