<?php
  // Filename: USER_BESTELLUNG_1.php
  //
  // Modul: USER_BESTELLUNG
  //
  // Autoren: Jos Fontanil & Reto Glanzmann, Zuercher Hochschule Winterthur
  //
  // Sponsoren:
  // billBOX-Funktionalitaet gesponsert von der Firma billBOX AG, www.billbox.ch
  //
  // Zweck: Dies ist der erste Schritt nachdem der Kunde sich entschieden hat
  //        seine ausgewaehlten Produkte beim Shop zu kaufen
  //
  // Sicherheitsstatus:        *** USER ***
  //
  // Version: 1.2
  //
  // CVS-Version / Datum: $Id: USER_BESTELLUNG_1.php,v 1.45 2002/10/28 20:29:13 fontajos Exp $
  //
  // -----------------------------------------------------------------------
  //
  // Lizenz
  // ======
  // PhPepperShop Shopsystem
  // Copyright (C) 2001  Reto Glanzmann, Jos Fontanil
  //
  // This program is free software; you can redistribute it and/or modify
  // it under the terms of the GNU General Public License as published by
  // the Free Software Foundation; either version 2 of the License, or
  // (at your option) any later version.
  //
  // This program is distributed in the hope that it will be useful,
  // but WITHOUT ANY WARRANTY; without even the implied warranty of
  // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  // GNU General Public License for more details.
  //
  // You should have received a copy of the GNU General Public License
  // along with this program; if not, write to the Free Software
  // Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  //
  // -----------------------------------------------------------------------
  // Damit jedes andere Modul ueberpruefen kann ob dieses hier schon "included" ist
  // wird folgende Vairable auf true gesetzt (Name = Name des Moduls ohne .php)
  $USER_BESTELLUNG_1 = true;

  // -----------------------------------------------------------------------
  // Session_management: (Ueberpruefen ob eine Session_ID uebergeben wurde,
  // sonst eine neue erzeugen
  if(empty($mySession_ID)){
      session_name("mySession_ID");
      if (session_register("mySession_ID")) {
      }
      else {
          die("<P><H1 class='content'>USER_BESTELLUNG_AUFRUF.php: ACHTUNG session_register() = false, konnte keine Session_ID zuteilen</H1></P><BR><BR>");
      }
  }
  else {
      session_id($mySession_ID);
  }

  // include Pfad anpassen. Dabei werden die unterschiedlichen Delimiter-Zeichen fuer
  // Windows und UNIX/Linux beruecksichtigt. Danke fuer die Idee an Eduard Mas Walgram.
  // Windows --> Delimiter = Strichpunkt | UNIX/Linux --> Delimiter = Doppelpunkt
  if (PHP_OS == "WINNT" || PHP_OS == "WIN32" || strlen($HTTP_ENV_VARS["WINDIR"]) > 0) {$pd = ";";} else {$pd = ":";}
  ini_set("include_path", "./$pd../$pd../../$pd./Frameset$pd./shop$pd/usr/local/lib/php");

  // Einbinden der benoetigten Module (PHP-Scripts)
  // Bei Unklarheiten, siehe include-Hierarchie in der Dokumentation
  if (!isset($USER_ARTIKEL_HANDLING)) {include("USER_ARTIKEL_HANDLING.php");}
  if (!isset($USER_BESTELLUNG)) {include("USER_BESTELLUNG.php");}
  if (!isset($USER_BESTELLUNG_DARSTELLUNG)) {include("USER_BESTELLUNG_DARSTELLUNG.php");}
  if (!isset($payment_interface)) {include("payment_interface.php");}

  // Damit der PhPepperShop auch mit der PHP-Einstellung Register Globals = Off funktioniert, werden die Request Arrays
  // $HTTP_GET_VARS und dann $HTTP_POST_VARS in die Standardsymboltabellen ausgelesen. (Post ueberschreibt dabei GET!)
  extract($HTTP_GET_VARS);
  extract($HTTP_POST_VARS);
  extract($HTTP_SERVER_VARS);

  // -----------------------------------------------------------------------
  // HTML-Dokument Header ist fr alle Seiten gleich, darum wird er immer zuerst ausgegeben
?>

<HTML>
  <HEAD>
    <META HTTP-EQUIV="content-type" CONTENT="text/html;charset=iso-8859-1">
    <META HTTP-EQUIV="language" CONTENT="de">
    <META HTTP-EQUIV="author" CONTENT="Jose Fontanil & Reto Glanzmann">
    <META NAME="robots" CONTENT="all">
    <LINK REL=STYLESHEET HREF="shopstyles.css" TYPE="text/css">
    <TITLE>Shop</TITLE>
  </HEAD>

  <body class="content">

<?php


// -----------------------------------------------------------------------
// Bevor der Login-Screen ausgegeben wird, pruefen ob sich der Kunde schon
// eingeloggt hat
// ja -> direkt darstellen = 11 aufrufen
// nein -> Login-Screen ausgeben (darstellen=1)
// -----------------------------------------------------------------------
if ($darstellen == 1){

    // Test ob Cookies eingeschaltet sind:
    checkifCookiesenabled("","",1,0);

    // Zuerst von der Datenbank allenfalls schon vorhandene Daten auslesen und erst dann darstellen
    $meineBestellung = new Bestellung;
    $meineBestellung = getBestellung(session_id());

    if ($meineBestellung->artikelanzahl() == 0) {
        // 'Warenkorb ist leer' - Meldung ausgeben
        echo '<body class="content"><BR>'."\n";
        echo "<P><h3 class='content'><CENTER>Ihr Warenkorb ist leer!</CENTER></h3></P><BR>\n";
        echo '<h4 class="content"><CENTER>Sie k&ouml;nnen die Kasse erst betreten, wenn sie Artikel in Ihrem Warenkorb haben.</CENTER></h4>';
        die (); // damit nicht noch der Rest des Files abgearbeitet wird
    } // end of if
    else {
        if ($Kunden_ID != 'P'){
            // pruefen, ob der Kunde sich schon eingeloggt hat
            $Kunden_ID = checkSession(session_id());
            if ($Kunden_ID != ""){
                $darstellen = 11;
            } // end of if Kunden_ID
        } // end of if Kunden_ID
    } // end of else
} // end of erstes darstellen == 1


// -----------------------------------------------------------------------
// Login-Screen fuer Kunde
// -----------------------------------------------------------------------
if ($darstellen == 1){

?>
    <script language="JavaScript">
    <!--

    function chkFormular() {

      Benutzername = document.Formular.Benutzername.value;
      Passwort = document.Formular.Passwort.value;

      // ueberpruefen, ob der Benutzername mindestes 4 Zeichen hat
      if(Benutzername.length < 4 && Benutzername != "" && Benutzername !=" ") {
          alert("Benutzername muss mindestens 4 Zeichen haben!");
          document.Formular.Benutzername.focus();
          return false;
      }

      // ueberpruefen, ob der Passwort mindestes 6 Zeichen hat
      if(Passwort.length < 6 && Passwort != "" && Passwort !=" ") {
          alert("Passwort muss mindestens 6 Zeichen haben!");
          document.Formular.Passwort.focus();
          return false;
      }

      // falls nur ein Benutzername eingegeben wurde
      if(Benutzername.length > 3 && Passwort.length < 6) {
          alert("Bitte geben Sie ein Passwort ein!");
          document.Formular.Passwort.focus();
          return false;
      }

      // falls nur ein Passwort eingegeben wurde
      if(Passwort.length > 5 && Benutzername.length < 4) {
          alert("Bitte geben Sie einen Benutzernamen ein!");
          document.Formular.Benutzername.focus();
          return false;
      }

    }
    //-->

    </script>
    <form name="Formular" onSubmit="return chkFormular()" action='<?= getSSL($PHP_SELF, $HTTP_HOST, false); ?>?darstellen=11' method='POST' title='Formular' >
      <center>
      <table class="content" border="0" width="80%">
        <tr class='content'>
          <td class='content' colspan=3>
            <h3 class='content'>Anmeldung Benutzer/Neukunde</h3>
          </td>
        </tr>
        <tr><td colspan=3>&nbsp;</td></tr>
        <tr class='content'>
          <td class='content' colspan=3>
            <p>Falls Sie schon Kunde bei uns sind, k&ouml;nnen sie jetzt Ihren Benutzernamen und Ihr Passwort eingeben. Ihre Adressdaten&nbsp;
            werden danach geladen.</p>
            <p>Sind Sie Neukunde, k&ouml;nnen Sie einen beliebigen Benutzernamen (am besten Ihre E-Mail-Adresse, da sie weltweit&nbsp;
            eindeutig ist) und ein Passwort w&auml;hlen. Wenn Sie nicht wollen, dass wir Ihre Adressdaten f&uuml;r einen sp&auml;teren Einkauf speichern, lassen Sie das Benutzername- und Passwortfeld leer.</p>
          </td>
        </tr>
        <tr><td colspan=3>&nbsp;</td></tr>
        <tr class='content'>
          <td width=50%></td>
          <td class='content'>
            <nobr><b class='content' style='font-weight:bold'>Benutzername:</b>(mindestens 4 Zeichen)</nobr><br><input type=text name=Benutzername maxlength=50 size=30 value=""><br>
            <nobr><b class='content' style='font-weight:bold'>Passwort:</b>(mindestens 6 Zeichen)</nobr><br><input type=password name=Passwort maxlength=30 size=30>
          </td>
          <td width=50%></td>
        </tr>
        <tr><td colspan=3>&nbsp;</td></tr>
        <tr class='content'>
          <td class='content' align=center colspan=3>
            <input type=image src='Buttons/bt_weiter.gif' border="0"></center>
          </td>
        </tr>
      </table>
    </form>
<?php

} // ende von darstellen = 1

// -----------------------------------------------------------------------
// Eingabeformular, falls jemand sein Passwort vergessen hat
// -----------------------------------------------------------------------
else if ($darstellen == 9){

?>
    <script language="JavaScript">
    <!--

    function chkFormular() {

      Benutzername = document.Formular.Benutzername.value;


      // ueberpruefen, ob der Benutzername mindestes 4 Zeichen hat
      if(Benutzername.length < 4) {
          alert("Der Benutzername muss mindestens 4 Zeichen haben!");
          document.Formular.Benutzername.focus();
          return false;
      }
    } // end of function chkFormular
    //-->

    </script>
    <form name="Formular" onSubmit="return chkFormular()" action='<?= $PHP_SELF ?>?darstellen=10' method='POST' title='Formular' >
      <center>
      <table class="content" border="0" width="80%">
        <tr class='content'>
          <td class='content'>
            <h3 class='content'>Passwort vergessen</h3>
          </td>
        </tr>
        <tr class='content'>
          <td class='content' colspan=3>
            <b class='content' style='font-weight:bold'>Geben Sie Ihren Benutzernamen ein und klicken dann auf 'weiter'.</b>
          </td>
        </tr>
        <tr><td>&nbsp;</td></tr>
        <tr class='content'>
          <td class='content'>
            <nobr><b class='content' style='font-weight:bold'>Benutzername:</b>(mindestens 4 Zeichen)</nobr><br><input type=text name=Benutzername maxlength=50 size=30 value=""><br>
          </td>
        </tr>
        <tr><td>&nbsp;</td></tr>
        <tr class='content'>
          <td class='content' align=center colspan=3>
            <input type=image src='Buttons/bt_weiter.gif' border="0"></center>
          </td>
        </tr>
      </table>
    </form>

<?php
}  // end of darstellen == 9

// -----------------------------------------------------------------------
// Passwort einem User zuschicken
// -----------------------------------------------------------------------
else if ($darstellen == 10){
    if(mailPasswort($Benutzername)){
        //falls der Mailversand geklappt hat
?>
        <table border=0 width=80%>
          <tr class='content'>
            <td class='content'>
              <h3 class='content'>Passwort versendet</h3></td></tr>
            </td>
          </tr>
          <tr class='content'>
            <td class='content'>
              <b class='content' style='font-weight:bold'>Wir haben Ihnen Ihr Passwort zugesendet. Sie sollten es in den nchsten Minuten erhalten.</b>
            </td>
          </tr>
          <tr class='content'>
            <td class='content'>
              <p class='content'><center><a href="<?= $PHP_SELF ?>?darstellen=1"><img src="Buttons/bt_weiter.gif" border="0"></a></center></p>
            </td>
          </tr>
        </table>
<?php
    } // end of if
    else{
?>
        <table border=0 width=80%>
          <tr class='content'>
            <td class='content'>
              <h3 class='content'>Passwortversand gescheitert!</h3></td></tr>
            </td>
          </tr>
          <tr class='content'>
            <td class='content'>
              <b class='content' style='font-weight:bold'>Wir konnten Ihnen Ihr Passwort leider nicht zusenden. Dies kann folgende Gr&uuml;nde haben.</b>
                <ul>
                  <li>Der von Ihnen eingegebene Benutzername existiert nicht.<br></li>
                  <li>Sie haben bei Ihrer letzten Bestellung keine E-Mail Adresse angegeben.<br></li>
                </ul>
            </td>
          </tr>
          <tr><td>&nbsp;</td></tr>
          <tr class='content'>
            <td class='content'>
              <p class='content'><center><a href="<?= $PHP_SELF ?>?darstellen=1"><img src="Buttons/bt_weiter.gif" border="0"></a></center></p>
            </td>
          </tr>
        </table>

<?php
    } // end of else
} // end of darstellen == 10


// -----------------------------------------------------------------------
// Eingabeformular fr Lieferadresse und Zahlungsart
// -----------------------------------------------------------------------
else if ($darstellen == 11){

  // Test ob Cookies eingeschaltet sind:
  checkifCookiesenabled("","",1,0);

  // Kunde einloggen, falls er noch nicht eingeloggt ist
  if ($Kunden_ID == "") {
      $Kunden_ID = checkLogin($Benutzername, $Passwort, session_id());
  }  // end of if
      // Wenn das eingegebene Passwort nicht zum Login passt
      if ($Kunden_ID == "P"){
?>
          <center>
          <table border=0 width=80%>
            <tr class='content'>
              <td class='content'>
                <h3 class='content'>Das von Ihnen eingegebene Passwort ist falsch!</h3></td></tr>
              </td>
            </tr>
            <tr class='content'>
              <td class='content'>
                <b class='content' style='font-weight:bold'>Dies kann folgende Gr&uuml;nde haben:</b>
                <ul>
                  <li>Sie haben versucht, sich das erste Mal anzumelden. Der von Ihnen gew&auml;hlte Benutzername ist jedoch schon vergeben.<br></li>
                  <li>Sie versuchen sich mit einem richtigen Benutzernamen, aber falschen Passwort anzumelden. Falls Sie Ihre Passwort vergessen haben, klicken Sie auf  &quot;Passwort vergessen&quot;. Ihr Passwort wird Ihnen dann per E-Mail zugestellt (an die E-Mail Adresse, die Sie bei Ihrer letzten Bestellung angegeben haben).<br></li>
                  <li>Achten Sie bitte auf korrekte Gross- / Kleinschreibung!<br></li>
                </ul>
              </td>
            </tr>
            <tr class='content'>
              <td class='content'>
                <?php $css_string = 'class="content" style="text-decoration:'.getcssarg("main_link_d").'; color:'.getcssarg("main_link_c").'; font-style:'.getcssarg("main_link_i").'; font-size:'.getcssarg("main_link_s").'; font-weight:'.getcssarg("main_link_w").'"'; ?>
                <p class='content'><center><a href="<?= $PHP_SELF ?>?darstellen=9" <?= $css_string ?>><b class='content' style='font-weight:bold'>Passwort vergessen</b></a></center></p>
                <form action="<?= $PHP_SELF ?>" name="Formular" method="POST">
                  <input type=hidden name=Kunden_ID value='P'>
                  <input type=hidden name=darstellen value='1'>
                  <center><input type=image src='Buttons/bt_weiter.gif' border="0"></center>
                </form>
              </td>
            </tr>
          </table>
          </center>
<?php
          // Abarbeitung hier abbrechen
          die();
      } // end of if $Kunden_ID == "P"

  // An dieser Stelle hat jeder Kunde definitiv eine eindeutige Kunden-ID erhalten
  // (entweder von checkSession oder von checkLogin)
  $myKunde = getKunde($Kunden_ID);
  $myBestellung = getBestellung(session_id());

  // Anzahl fest vordefinierter Felder
  $anz_vordef = 14;

  // Attributobjekt aus Datenbank holen
  $myAttribut = getAttributobjekt();

  // Anzahl Zusatzfelder
  $gesamt = $myAttribut->attributanzahl();
  $anz_zusatz = ($gesamt-$anz_vordef);

  // Die verschiedenen Werte und Einstellungen in Arrays abfuellen
  $Namen = $myAttribut->getallName();
  $verwenden = $myAttribut->getallanzeigen();
  $speichern = $myAttribut->getallin_DB();
  $pruefen = $myAttribut->getallEingabe_testen();

?>

  <script language="JavaScript">
  <!--

  function chkFormular() {

<?php
  // einen Array abfuellen, wo jedes Eingabefeld eine Arravariable erhlt. Folgende Eintrge
  // werden gemacht:
  // Y -> dieses Feld auf Eingabe berprfen
  // N -> dieses Feld nicht auf Eingabe berprfen
  // M -> dieses Feld auf nach E-Mail-Kriterien auf Eingabe berprfen
  echo "var checkarray=new Array (";
  for ($zaehl = 0; $zaehl <= ($gesamt-1); $zaehl++){
      if ($verwenden[$zaehl] == "Y"){
          // E-Mail Eingabeberprfung
          if(($pruefen[$zaehl] == "Y") && ($Namen[$zaehl] == "E-Mail")){ echo "\"M\","; }
          // normale Eingabeberprfung
          else if($pruefen[$zaehl] == "Y"){ echo "\"Y\","; }
          // keine Eingabeberprfung
          else { echo "\"N\","; }
      } // end of if
  } // end of for
  echo "\"0\");";
?>

      for(count=0; count < (checkarray.length-2); count++){
          if (checkarray[count] == 'Y'){
              var wert = document.Formular[count].value;
              if ( wert == "" || wert == " "){
                  ersetz = /\+/gi;
                  feldname = document.Formular[count].name.replace(ersetz," ");
                  alert("Bitte fllen Sie das Feld "+unescape(feldname)+" aus!");
                  document.Formular[count].focus();
                  return false;
              } // end of if wert = ""
          }
          if (checkarray[count] == 'M'){
              var ok = 1;
              var email = document.Formular[count].value;
              var geteilt = email.split ("@");


              // falls mehr als ein oder gar kein '@' im string
              if (geteilt.length != 2){
                  ok = 0;
              }

              else{
                  // falls vor oder nach dem '@' nichts mehr kommt
                  if (geteilt[0] == "" || geteilt[1] == "" ) { ok = 0; }

                  // falls nach dem '@' kein Punkt mehr kommt
                  if (geteilt[1].indexOf(".") == "-1" ) { ok = 0; }

                  // falls direkt nach dem '@' oder ganz am Schluss ein Punkt kommt
                  var laenge = geteilt[1].length;
                  if (geteilt[1].indexOf(".") == "0" || geteilt[1].charAt(laenge-1) == ".") { ok = 0; }

                  // falls direkt vor dem '@' oder am Anfang ein Punkt kommt
                  var laenge = geteilt[0].length;
                  if (geteilt[0].indexOf(".") == "0" || geteilt[0].charAt(laenge-1) == ".") { ok = 0; }
              }

              if (ok == 0){
                  alert ("Keine gltige E-Mail-Adresse!");
                  document.Formular[count].focus();
                  return false;
              }
          }


      } // end of for
  }
  //-->
  </script>


  <FORM action='<?php echo $PHP_SELF; ?>' name='Formular' method='POST' onSubmit="return chkFormular()">
  <center>
  <TABLE class="content" border="0" cellpadding="0" cellspacing="0" width="80%">
    <tr>
      <td class='content' colspan=3>
        <h3 class='content'>Angaben zu Ihrer Bestellung</h3>
      </td>
    </tr>
    <tr>
      <td colspan=2 class='content'>
        <h5 class='content'>Bitte f&uuml;llen Sie alle mit <b class='content'>*</b> gekennzeichneten Felder korrekt aus,&nbsp;
                            damit wir Ihre Bestellung bearbeiten k&ouml;nnen</h5>
      </td>
    </tr>

<?php

  // hier werden in einem Array die Anzeigelaengen fr die Eingabefelder gespeichert
  // [0] = Anrede (wird natrlich nicht gebraucht) [1] = Vorname, usw.
  $laenge_array = array('0', '40', '40', '40', '40', '40', '10', '10', '40', '20', '16', '16', '40', '40', '40', '40', '40', '0');

  // hier werden in einem Array die maximalen Eingabelaengen fr die Eingabefelder gespeichert
  // [0] = Anrede (wird natrlich nicht gebraucht) [1] = Vorname, usw.
  $max_array = array('0', '128', '128', '128', '128', '128', '16', '32', '128', '128', '32', '32', '128', '128', '128', '128', '128', '0');

  // Kunden-Daten in einen Array abfuellen
  $daten_array = array($myKunde->Anrede, $myKunde->Vorname, $myKunde->Nachname, $myKunde->Firma, $myKunde->Abteilung, $myKunde->Strasse,
                $myKunde->Postfach, $myKunde->PLZ, $myKunde->Ort, $myKunde->Land, $myKunde->Tel, $myKunde->Fax, $myKunde->Email,
                $myKunde->Attributwert1, $myKunde->Attributwert2, $myKunde->Attributwert3, $myKunde->Attributwert4, $myBestellung->Anmerkung);
  // Ueberpruefen, ob die selbstkonfigurierbaren Felder nicht an die Bestellung gebunden wurden. Wenn ja, so sollen
  // sie aus der Bestellung ausgelesen werden (ist hier momentan ziemlich statisch geloest):
  for ($i=13;$i <= 16; $i++) {
      if ($daten_array[$i] == "") {
          $name = "Attributwert".($i-12);
          $daten_array[$i] = $myBestellung->$name;
      }
  }
  // Hauptfelder ausgeben
  for ($zaehl = 0; $zaehl <= ($gesamt-1); $zaehl++){
      // nur Felder ausgeben, die der Shopbetreiber auch aktiviert hat
      if($verwenden[$zaehl] == 'Y'){

          // Anrede-Dropdown-Liste ausgeben..
          if ($zaehl == 0){
              echo "<tr class='content'>\n";
              // Feldbezeichnungsnamen ausgeben
              echo "  <td class='content'>".$Namen[$zaehl].":";
              if($pruefen[$zaehl] == 'Y'){echo "*";};
              echo "</td><td class='content'>";
              echo "<select style='font-family: Courier, Courier New, Monaco' name='".$Namen[$zaehl]."'>\n";
              // default option -> keine Anrede
              echo "  <option ";
              if ($daten_array[$zaehl] == "") { echo "selected "; }
              echo "value=''> bitte ausw&auml;hlen&nbsp;&nbsp;&nbsp;\n";
              // Anrede: "Herr"
              echo "  <option ";
              if ($daten_array[$zaehl] == "Herr") { echo "selected "; }
              echo "value='Herr'>Herr\n";
              // Anrede: "Frau"
              echo "  <option ";
              if ($daten_array[$zaehl] == "Frau") { echo "selected "; }
              echo "value='Frau'>Frau\n";
              // Anrede: "Firma"
              echo "  <option ";
              if ($daten_array[$zaehl] == "Firma") { echo "selected "; }
              echo "value='Firma'>Firma\n";
              // Anrede: "Familie"
              echo "  <option ";
              if ($daten_array[$zaehl] == "Familie") { echo "selected "; }
              echo "value='Familie'>Familie\n";
              echo "</select>\n";
              echo "</td>\n</tr>\n";
          } // end of if $zaehl == 0

          // Standard-Textfelder Ausgeben, Name, Strasse,..
          if ($zaehl > 0 && $zaehl < ($anz_vordef-1)){
              echo "<tr class='content'>\n";
              // Feldbezeichnungsnamen ausgeben
              echo "  <td class='content'>".htmlspecialchars($Namen[$zaehl]).":";
              if($pruefen[$zaehl] == 'Y'){echo "*";};
              echo "</td>\n";
              $einsetzen = rawurlencode($Namen[$zaehl]);
              $einsetzen_1 = str_replace(".", "%2E", $einsetzen);
              echo "<td class='content'><input type=text name=\"".$einsetzen_1."\" size='".$laenge_array[$zaehl]."' maxlength='".$max_array[$zaehl]."' value=\"".htmlspecialchars($daten_array[$zaehl])."\"></td>\n";
              echo "</tr>\n";
          } //

          // frei konfigurierbare Zusatzfelder ausgeben
          if ($zaehl > 12 && $zaehl < 17){
              echo "<tr class='content'>\n";
              // Feldbezeichnungsnamen ausgeben
              echo "  <td class='content'>".htmlspecialchars($Namen[$zaehl]).":";
              if($pruefen[$zaehl] == 'Y'){echo "*";};
              echo "</td>\n";
              $einsetzen = rawurlencode($Namen[$zaehl]);
              $einsetzen_1 = str_replace(".", "%2E", $einsetzen);
              echo "<td class='content'><input type=text name=\"".$einsetzen_1."\" size='".$laenge_array[$zaehl]."' maxlength='".$max_array[$zaehl]."' value=\"".htmlspecialchars($daten_array[$zaehl])."\"></td>\n";
              echo "</tr>\n";
          } //

          // Bemerkungen-Textarea ausgeben
          if ($zaehl == 17){
              echo "<tr class='content'>\n";
              // Feldbezeichnungsnamen ausgeben
              $einsetzen = rawurlencode($Namen[$zaehl]);
              $einsetzen_1 = str_replace(".", "%2E", $einsetzen);
              echo "  <td class='content' valign=top>".htmlspecialchars($Namen[$zaehl]).":";
              if($pruefen[$zaehl] == 'Y'){echo "*";};
              echo "</td>\n";
              echo "<td class='content' style='font-family: Courier, Courier New, Monaco'><textarea style='font-family: Courier, Courier New, Monaco' name=\"".$einsetzen_1."\" cols='38' rows='5' wrap=physical>".htmlspecialchars($daten_array[$zaehl])."</textarea></td>\n";
              echo "</tr>\n";
          }

      } // end of if $verwenden[$zaehl] == 'Y'

  } // end of for $zaehl = 0; $zaehl <= ($anz_vordef-1); $zaehl++

  // fuer alle Zusatzattribute ermitteln, ob Sie zum Kundendatensatz oder zur Bestellung gespeichert werden
  // Information als Hidden-Feld weitergeben
  $attr_count = 1; // Attributzaehler

  for ($zaehl = 13; $zaehl <= 16; $zaehl++){
      if($verwenden[$zaehl] == 'Y'){
          if($speichern[$zaehl] == 'Y'){
              echo"<INPUT TYPE=hidden NAME=Attr_speichern[".$attr_count."] VALUE='Kunde'>\n";
          } // end of if speichern = Y
          else{
              echo"<INPUT TYPE=hidden NAME=Attr_speichern[".$attr_count."] VALUE='Bestellung'>\n";
          }
      $einsetzen = rawurlencode($Namen[$zaehl]);
      $einsetzen_1 = str_replace(".", "%2E", $einsetzen);
      echo"<INPUT TYPE=hidden NAME=Attr_name[".$attr_count."] VALUE=\"".$einsetzen_1."\">\n";
      } // end of if verwenden = Y
      else{
      echo"<INPUT TYPE=hidden NAME=Attr_name[".$attr_count."] VALUE=''>\n";
      }
      // Attributzaehler erhoehen
      $attr_count++;
  } // end of for

?>

    </TR><TR class='content'>
    <TD class='content' colspan=2><HR></TD>
    </TR><TR class='content'>

<?php
  // Versandkosten berechnen und in die Bestellung einfuegen
  berechneVersandkosten(session_id());

  // Bestellungsobjekt instanzieren
  $myBestellung = getBestellung(session_id());

  // Rechnungsdaten aus Bestellungsobjekt in Variablen abfuellen
  $Rechnungstotal = $myBestellung->Rechnungsbetrag;
  $Mindermengenzuschlag = $myBestellung->Mindermengenzuschlag;
  $Versandkosten = $myBestellung->Versandkosten;
  if ($myBestellung->Bezahlungsart == "Nachnahme") {
      $Nachnahmebetrag =$myBestellung->Nachnahmebetrag;
  }
  // Falls es sich NICHT um eine kostenlose Bestellung handelt:
  if ($Rechnungstotal - ($Mindermengenzuschlag + $Versandkosten + $Nachnahmebetrag) > 0.0) {
      echo "<TD class='content' VALIGN=top>Zahlungsart:</TD>";
      echo "<TD class='content' VALIGN=top>";
      // Dem Shop-Kunden duerfen nur die in den Shop-Settings erlaubten Zahlungsmethoden
      // zur Verfuegung gestellt werden (Funktion in USER_ARTIKEL_HANDLING.php definiert)
      $Bezahlungsarray = array();
      $Bezahlungsarray = getBezahlungsart();
      // Die vom Kunden gewaehlte Bezahlungsart wird in seiner Bestellung gespeichert, falls er den Zurueck-
      // Button anklickt, kann die vorher geawaehlte Bezahlungsart wieder erkannt werden, indem man die Bezahlungs-
      // art aus seinem Bestellobjekt ausliest.
      $Bezahlungsart = $myBestellung->Bezahlungsart;

      $defaultmarkieren = ""; //defaultmarkieren waehlt eine Bezahlungsart vor (damit sicher eine gewaehlt ist)
      if ($Bezahlungsart == "") {
          if ($Bezahlungsarray["Vorauskasse"] == 'Y') {
              $defaultmarkieren = "Vorauskasse";
          }
          elseif(($defaultmarkieren == "") && ($Bezahlungsarray["billBOX"] == 'Y')) {
              $defaultmarkieren = "billBOX";
          }
          elseif(($defaultmarkieren == "") && ($Bezahlungsarray["Treuhandzahlung"] == 'Y')) {
              $defaultmarkieren = "Treuhandzahlung";
          }
          elseif(($defaultmarkieren == "") && ($Bezahlungsarray["Rechnung"] == 'Y')) {
              $defaultmarkieren = "Rechnung";
          }
          elseif(($defaultmarkieren == "") && ($Bezahlungsarray["Nachnahme"] == 'Y')) {
              $defaultmarkieren = "Nachnahme";
          }
          else {
              $defaultmarkieren = "Kreditkarte";
          }
      }
      // Moeglichkeit, per Vorauskasse zu bezahlen anzeigen, wenn in Shopsettings freigeschaltet
      if ($Bezahlungsarray["Vorauskasse"] == 'Y') {
        echo "<INPUT TYPE=radio NAME='Bezahlungsart' ";
        if (($Bezahlungsart == "Vorauskasse") || ($defaultmarkieren == "Vorauskasse")) {echo "checked ";}
        echo " value='Vorauskasse'>Vorauskasse<br>\n";
      }

      // Moeglichkeit, per billBOX zu bezahlen anzeigen, wenn in Shopsettings freigeschaltet. Der Schriftzug
      // billBOX ist mit einem Link hinterlegt, der direkt auf eine Infoseite von billBOX zeigt.
      if ($Bezahlungsarray["billBOX"] == 'Y') {
        echo "<INPUT TYPE=radio NAME='Bezahlungsart' ";
        if (($Bezahlungsart == "billBOX") || ($defaultmarkieren == "billBOX")) {echo "checked ";}
        // Cascading Style Sheet Angaben fuer den Link (Weitere Informationen) auslesen und in Variable abpacken:
        $cssargumente = ' style="text-decoration:underline;
        color:'.getcssarg("main_font_c").'; font-style:'.getcssarg("main_font_i").'; font-size:'.getcssarg("main_font_s").';
        font-weight:'.getcssarg("main_font_w").'"';
        echo " value='billBOX'><a class='content' ".$cssargumente." href=\"http://www.billbox.ch/content/anmeldung.shtml\" target=_new>billBOX</a><br>\n";
      }

      // Moeglichkeit, per Treuhandzahlung zu bezahlen anzeigen, wenn in Shopsettings freigeschaltet.
      if ($Bezahlungsarray["Treuhandzahlung"] == 'Y') {
        echo "<INPUT TYPE=radio NAME='Bezahlungsart' ";
        if (($Bezahlungsart == "Treuhandzahlung") || ($defaultmarkieren == "Treuhandzahlung")) {echo "checked ";}
        echo " value='Treuhandzahlung'>Zahlung &uuml;ber Treuh&auml;nder<br>\n";
      }

      // Moeglichkeit, mit Rechnung zu bezahlen anzeigen, wenn in Shopsettings freigeschaltet
      if ($Bezahlungsarray["Rechnung"] == 'Y') {
        echo "<INPUT TYPE=radio NAME='Bezahlungsart' ";
        if (($Bezahlungsart == "Rechnung") || ($defaultmarkieren == "Rechnung")) {echo "checked ";}
        echo " value='Rechnung'>Rechnung<br>\n";
      }

      // Moeglichkeit, mit Nachnahme zu bezahlen anzeigen, wenn in Shopsettings freigeschaltet
      if ($Bezahlungsarray["Nachnahme"] == 'Y') {
        echo "<INPUT TYPE=radio NAME='Bezahlungsart'";
        if (($Bezahlungsart == "Nachnahme") || ($defaultmarkieren == "Nachnahme")) {echo "checked ";}
        echo " value='Nachnahme'>Nachnahme<br>\n";
      }

      // Moeglichkeit, mit Kreditkate zu bezahlen anzeigen, wenn in Shopsettings freigeschaltet
      if ($Bezahlungsarray["Kred_Post"] == 'Y'){
        echo "<INPUT TYPE=radio NAME='Bezahlungsart'";
        if (($Bezahlungsart == "Kreditkarte") || ($defaultmarkieren == "Kreditkarte")) {echo "checked ";}
        echo " value='Kreditkarte'>Kreditkarte\n";
        // Kreditkarten-Objekte auslesen
        $meineKreditkarten = getKreditkarten();
        // Darstellen der aktiven Kreditkarten in einem Pulldown-Menu
        // Dabei wird die vom Kunde gewaehlte Kreditkarte angewaehlt (Falls er das gemacht hat)
        echo "\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Kreditkarten Institut: &nbsp;\n";
        echo "<select name='Kreditkarten_ID' size='1'>\n";
        foreach ($meineKreditkarten as $key=>$val) {
            // Nur aktive Kreditkarten anzeigen
            if ($val->benutzen == 'Y') {
                echo "<option value='".$val->Kreditkarten_ID."'";
                if ($myBestellung->Kreditkarten_Hersteller == $val->Hersteller) {
                    echo "selected";
                }
                echo ">".$val->Hersteller."</option>\n";
            }
        }
        echo "</select><br>\n";
      }
      echo "</TD>";

  } // end of if rechnungstotal > 0

  else {
      $Bezahlungsart = "kostenlos";
      echo "<INPUT TYPE=hidden NAME=Bezahlungsart VALUE=$Bezahlungsart>";
      echo "<TD></TD>";
  } // end of else

?>
      </TR>
    </TABLE>
    </center>
    <INPUT TYPE=hidden NAME=darstellen VALUE=2>
    <INPUT TYPE=hidden NAME=Versandkosten VALUE=<?php echo "$Versandkosten"; ?>>
    <INPUT TYPE=hidden NAME=Mindermengenzuschlag VALUE=<?php echo "$Mindermengenzuschlag"; ?>>
    <INPUT TYPE=hidden NAME=Rechnungstotal VALUE=<?php echo "$Rechnungstotal"; ?>>
    <INPUT TYPE=hidden NAME=Datum VALUE=<?php echo "$Datum"; ?>><BR>
    <INPUT TYPE=hidden NAME=Kunden_ID VALUE=<?php echo "$Kunden_ID"; ?>><BR>
    <input type=hidden name=darstellen value=2>
    <CENTER><INPUT TYPE=image src='Buttons/bt_weiter.gif' border="0"></CENTER>
    </FORM>
<?php

} // ende von darstellen = 11



// -----------------------------------------------------------------------
// - Update der Kunden- und Bestellungsdaten.
// - Ausgabe der Bestellung zur Kontrolle fuer den Kunden (an den Browser).
// - Weiche fuer Bezahlungsarten. Je nachdem ob man entweder per Voraus-
//   kasse, Rechnung, Nachnahme oder per Kreditkarte bezahlt und weiter noch
//   je nachdem ob die Kreditkartenzahlung intern oder extern abgewickelt wird.
// -----------------------------------------------------------------------
else if ($darstellen == 2) {

  // frei konfigurierbare Zusatzattribute in einen Array abfuellen
  for ($zaehl = 1; $zaehl <= count($Attr_name); $zaehl++){
      if ($Attr_speichern[$zaehl] == "Kunde"){
          $bezeichner = $Attr_name[$zaehl];
          $attr_namen[$zaehl] = rawurldecode($bezeichner);
          $attr_wert[$zaehl] = $$bezeichner;
      } // end of if
      else{
          $attr_wert[$zaehl] = "";
      } // end of else
  } // end of for

  $email = "E-Mail";
  $telefon = "Tel%2E";

  //Kundenattribute speichern (Bestellungsfelder werden weiter unten upgedated)
  updKundenFelder(session_id(), $Anrede, $Vorname, $Nachname, $Firma, $Abteilung, $Strasse,
           $Postfach, $PLZ, $Ort, $Land, $$telefon, $Fax, $$email, $attr_namen[1], $attr_namen[2],
           $attr_namen[3], $attr_namen[4], $attr_wert[1], $attr_wert[2], $attr_wert[3], $attr_wert[4], $Kunden_ID);

  // Attributobjekt aus Datenbank holen
  $myAttribut = getAttributobjekt();

  // Anzahl Zusatzfelder
  $gesamt = $myAttribut->attributanzahl();
  $anz_zusatz = ($gesamt-$anz_vordef);

  // Die verschiedenen Werte und Einstellungen in Arrays abfuellen
  $Namen = $myAttribut->getallName();
  $verwenden = $myAttribut->getallanzeigen();

  // Alle Attributwerte der Zusatzattribute in einen Array abfuellen
  for ($zaehl = 1; $zaehl <= count($Attr_name); $zaehl++){
      $bezeichner = $Attr_name[$zaehl];
      $Attribut[$zaehl] = $$bezeichner;
  } // end of for

  // einen Array erstellen, der alle Feldinhalte enthaelt
  $adresse = array($Anrede, $Vorname, $Nachname, $Firma, $Abteilung, $Strasse,
           $Postfach, $PLZ, $Ort, $Land, $$telefon, $Fax, $$email, $Attribut[1], $Attribut[2], $Attribut[3], $Attribut[4], $Bemerkungen);

  // einen Array machen, der alle Namen der Felder enthaehlt, die verwendet werden, sowie einen
  // Array, der dessen Inhalte enthaelt
  $anzahl_total = count($Namen);
  for ($zaehl = 0; $zaehl <= $anzahl_total-1; $zaehl++){
      if ($verwenden[$zaehl] == 'Y'){
          // Array fuer die verwendeten Feldnamen
          $adresse_feld[] = stripslashes($Namen[$zaehl]);
          // Array fuer die Feldinhalte
          $adresse_inhalt[] = stripslashes($adresse[$zaehl]);
      } // end of if
  } // end of for

  echo "<h3 class='content'>Ihre Bestellung:</h3><br>\n";
  echo "<TABLE class='content' border='0' cellpadding='0' cellspacing='0'>\n";

  $anzahl_verwendet = count($adresse_feld);

  //  schauen, ob das letzte Feld "Bemerkungen" ist
  if ($adresse_feld[$anzahl_verwendet-1] == "Bemerkungen"){
      $bemerk = true;
      $wie_weit = $anzahl_verwendet-2;
  } // end of if
  else{
      $bemerk = false;
      $wie_weit = $anzahl_verwendet-1;
  } // end of else

  // Message-String fuer E-Mail
  $message_string_adr.="Lieferadresse:\n--------------";

  for ($zaehl = 0; $zaehl <= $anzahl_verwendet-2; $zaehl++){

      // Angaben, die in der linken Tabellenhaelfte angezeigt werden
      if ($zaehl % 2 == 0) {
          echo "<tr><td class='content'><b class='content' style='font-weight:bold'>".$adresse_feld[$zaehl].":&nbsp;&nbsp;</b><td>";
          echo "<td class='content'>".$adresse_inhalt[$zaehl]."</td><td>&nbsp;&nbsp;&nbsp;&nbsp;</td>";
      } // end of if

      // Angaben, die in der rechten Tabellenhaelfte angezeigt werden
      else {
          echo "<td class='content'><b class='content' style='font-weight:bold'>".$adresse_feld[$zaehl].":&nbsp;&nbsp;</b><td>";
          echo "<td class='content'>".$adresse_inhalt[$zaehl]."</td></tr>";
      } // end of else

      // Adressstring fr E-Mail um aktuelles Feld ergaenzen
      $message_string_adr.="\n".$adresse_feld[$zaehl].": ".$adresse_inhalt[$zaehl];

  } // end of for

  // falls erst eine halbe Zeile ausgegeben wurde
  if (($wie_weit) % 2 == 0){
      echo "<td colspan=2>&nbsp;<td>";
  } // end of if

  // falls existiert, Bemerkungsfeld ausgeben
  if ($bemerk == true){
      echo "<tr><td colspan=5>&nbsp;</td></tr>";
      echo "<tr><td class='content'><b class='content' style='font-weight:bold'>".$adresse_feld[$anzahl_verwendet-1].":&nbsp;&nbsp;</b><td>";
      echo "<td class='content' colspan=4>".$adresse_inhalt[$zaehl]."</td></tr>";

      // Adressstring fr E-Mail um aktuelles Feld ergaenzen
      $message_string_adr.="\n".$adresse_feld[$zaehl].": ".$adresse_inhalt[$zaehl];
  } // end of if

  // Zahlungsart ausgeben
  if ($Bezahlungsart != ""){
      echo "<tr><td class='content'><b class='content' style='font-weight:bold'>Zahlungsart:&nbsp;&nbsp;</b><td>";
      echo "<td class='content' colspan=4>".$Bezahlungsart."</td></tr>";
  } // end of if

  echo "</TABLE>\n";
  echo "<br><br>\n";

  // Bestellungsobjekt holen
  $myBestellung = getBestellung(session_id());

  // Bestellungsattribute aufbereiten (Bestellung ergaenzen) und speichern:
  // Nur Kreditkartendaten werden an dieser Stelle noch nicht gespeichert
  // Aktuelles Datum berechnen (wird dem Mailheader angehaengt)
  $mydate = getdate();
  $Datum = $mydate[year]."-".$mydate[mon]."-".$mydate[mday];// Format yyyy-mm-dd
  $myBestellung->Datum = $Datum;
  $myBestellung->Anmerkung = $Bemerkungen;
  $myBestellung->Bezahlungsart = $Bezahlungsart;

  // frei konfigurierbare Zusatzattribute in einen Array abfuellen
  for ($zaehl = 1; $zaehl <= count($Attr_name); $zaehl++){
      if ($Attr_speichern[$zaehl] == "Bestellung"){
          $bezeichner = $Attr_name[$zaehl];
          $attr_namen[$zaehl] = rawurldecode($bezeichner);
          $attr_wert[$zaehl] = $$bezeichner;
      } // end of if
      else{
          $attr_wert[$zaehl] = "";
          $attr_namen[$zaehl] = "";
      } // end of else
  } // end of for

/*  // Uebergebene Kreditkarten_ID auswerten und ausgewaehlte Kreditkarte in die
  // Bestellung speichern (TEMPORAER, da man sonst ev. gegen den Mail-Order Vertrag
  // mit dem jeweiligen Kreditkarteninstitut versoesst) */
/*  $meineKreditkarten = getKreditkarten();
  foreach ($meineKreditkarten as $key=>$val) {
      $myBestellung->Kreditkarten_Hersteller = $val->Hersteller;
      $myBestellung->Kreditkarten_Nummer = $val->;
      $myBestellung->Kreditkarten_Ablaufdatum = $;
      $myBestellung->Kreditkarten_Vorname = $;
      $myBestellung->Kreditkarten_Nachname = $;
  }*/

  $myBestellung->Attribut1 = $attr_namen[1];
  $myBestellung->Attribut2 = $attr_namen[2];
  $myBestellung->Attribut3 = $attr_namen[3];
  $myBestellung->Attribut4 = $attr_namen[4];
  $myBestellung->Attributwert1 =  $attr_wert[1];
  $myBestellung->Attributwert2 =  $attr_wert[2];
  $myBestellung->Attributwert3 =  $attr_wert[3];
  $myBestellung->Attributwert4 =  $attr_wert[4];
  // Bestellungsfelder updaten
  updBestellungsFelder(session_id(), $myBestellung);

  // Warenkorb darstellen, ohne die Moeglichkeit Artikel wieder daraus entfernen zu koennen! (und nicht fuer Admin)
  darstellenBestellung($myBestellung, false, false);

  // Weiche 1: Entscheidung, ob es sich um eine Kreditkartenzahlung oder eine andere Zahlung handelt:
  if ($Bezahlungsart == "Kreditkarte") {
      // Es handelt sich also um eine Kreditkarenzahlung. Wir lesen nun unsere Kreditkareneinstellungen aus und
      // suchen die vom Kunden gewaehlte Kreditkare aus. Dort lesen wir deren Handling aus und stellen danach die
      // zweite Weiche entsprechend
      $meineKreditkarten = getKreditkarten();
      foreach ($meineKreditkarten as $key=>$value) {
          if ($value->Kreditkarten_ID == $Kreditkarten_ID) {
              $Kreditkarten_Hersteller = $value->Hersteller;
              $Kreditkarten_Handling = $value->Handling;
              break;
          }
      }
      // Weiche 2: Entscheidung, ob es sich um eine interne oder externe Kreditkartenzahlung handelt:
      if ($Kreditkarten_Handling == "intern") {
          $darstellen_var = 5;    //intern
      }
      else {
          $darstellen_var = 6;    //extern
      }
  }

  else if ($Bezahlungsart == "billBOX") {
      $darstellen_var = 8;       // extern, billBOX
  }

  else {
      $darstellen_var = 3;       //intern, keine Kreditkarte
  }



  // Hidden-Formular, damit wir die Variablen per Post weitergeben koennen
?>
  <form action="<?= $PHP_SELF ?>" name="Formular" method="POST">
    <input type=hidden name=darstellen value=<?= $darstellen_var ?>>
    <input type=hidden name=message_string_adr value="<?= urlencode($message_string_adr) ?>">
    <input type=hidden name=email value="<?= urlencode($$email) ?>">
    <input type=hidden name=Bezahlungsart value="<?= urlencode($Bezahlungsart) ?>">
    <input type=hidden name=Vorname value="<?= urlencode($Vorname) ?>">
    <input type=hidden name=Nachname value="<?= urlencode($Nachname) ?>">
    <input type=hidden name=Kreditkarten_Hersteller value="<?= urlencode($Kreditkarten_Hersteller) ?>">
    <br>
    <center>
      <a href="<?= $PHP_SELF ?>?darstellen=1"><img src='Buttons/bt_zurueck.gif' border="0"></a>&nbsp;
      <input type=image src='Buttons/bt_weiter.gif' border="0">
    </center>
  </form>
<?php

}

// -----------------------------------------------------------------------
// Allgemeine Geschaeftsbedingungen aus Datenbank auslesen und Darstellen.
// Bestellung wird erst abgesendet, wenn Shopbenutzer die AGB's akzeptiert
// hat.
// -----------------------------------------------------------------------



else if ( $darstellen == 3 ){
?>
  <center>
  <table border=0 cellspacing=0 cellpadding=0 class=content width='80%'>
    <tr class=content>
      <td class=content>
<?php
  // AGB ausgeben
  echo "<h3 class='content'>Allgemeine Gesch&auml;ftsbedingungen</h3>";
  echo getAGB();

  // Hidden-Formular, damit wir die Variablen per Post weitergeben koennen
?>
      </td>
    </tr>
    <tr><td>&nbsp;</td></tr>
    <tr class=content>
      <td class=content>
        <form action="<?= $PHP_SELF ?>" name="Formular" method="POST">
          <input type=hidden name=darstellen value=4>
          <input type=hidden name=message_string_adr value="<?= $message_string_adr ?>">
          <input type=hidden name=email value="<?= $email ?>">
          <input type=hidden name=Erfolg value="1">
          <input type=hidden name=Zahlungsart value="<?= $Bezahlungsart ?>">
          <input type=radio name=agb value=ja>&nbsp;Ja, ich akzeptiere die allgemeinen Gesch&auml;ftsbedingungen und will bestellen<BR>
          <input type=radio name=agb value=nein checked>&nbsp;Nein, ich akzeptiere die allgemeinen Gesch&auml;ftsbedingungen <B style='font-weight:bold'>nicht</B><BR>
      </td>
    </tr>
    <tr><td>&nbsp;</td></tr>
    <tr class=content>
      <td class=content>
          <center><input type=image src='Buttons/bt_bestellung_absenden.gif' border="0"></center>
        </form>
      </td>
    </tr>
  </table>
  </center>
<?php

} // end of darstellen = 3

// -----------------------------------------------------------------------
// Kreditkartenhandling *** INTERN ***
// - Kreditkartendaten Eingabemaske und Weiterleitung an darstellen == 3
// -----------------------------------------------------------------------
else if ( $darstellen == 5){
?>
    <center>
    <form action="<?= $PHP_SELF ?>" name="Formular" method="POST">
    <table class='content' border='0' cellpadding='0' cellspacing='0' class='content'>
      <tr class='content'>
        <td class='content'>
          <h3 class='content'>Kreditkarten Datenerfassung</h3><br>
          <LI>Ihre Kreditkartendaten werden nicht dauerhaft gespeichert.</LI>
          <LI>Wenn Sie mit der Kreditkarte einer anderen Person zahlen wollen, so geben Sie bitte den entsprechenden Vor- und Nachnamen an.</LI>
        </td>
      </tr>
      <tr class='content'>
        <td class='content'>
    <table class='content' border='0' cellpadding='0' cellspacing='0' class='content'>
      <tr class='content'>
        <td class='content'>
            <BR>Kreditkarten Institut:
        </td>
        <td class='content'>
            <BR><b class='content' style='font-weight:bold'><?= urldecode($Kreditkarten_Hersteller) ?></b>
        </td>
        <td>&nbsp;</td>
      </tr>
      <tr class='content'>
        <td class='content'>
            Kreditkartennummer:
        </td>
        <td class='content'>
            <input type=text size=32 name=Kreditkarten_Nummer value="<?= $Kreditkarten_Nummer ?>">
        </td>
        <td>&nbsp;</td>
      </tr>
      <tr class='content'>
        <td class='content'>
            Ablaufdatum der Karte:
        </td>
        <td class='content'>
            <input type=text size=2 name=Kreditkarten_Ablaufdatum_1 value="<?= $Kreditkarten_Ablaufdatum_1 ?>">&nbsp;/&nbsp;
            <input type=text size=2 name=Kreditkarten_Ablaufdatum_2 value="<?= $Kreditkarten_Ablaufdatum_2 ?>">
        </td>
        <td>&nbsp;</td>
      </tr>
      <tr class='content'>
        <td class='content'>
            Vorname:
        </td>
        <td class='content'>
            <input type=text size=32 maxsize=128 name=Kreditkarten_Vorname value="<?= urldecode($Vorname) ?>">
        </td>
        <td>&nbsp;</td>
      </tr>
      <tr class='content'>
        <td class='content'>
            Nachname:
        </td>
        <td class='content'>
            <input type=text size=32 maxsize=128 name=Kreditkarten_Nachname value="<?= urldecode($Nachname) ?>">
        </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td class='content' align='right'>
            <BR>
            <a href="<?= $PHP_SELF ?>?darstellen=1"><img src='Buttons/bt_zurueck.gif' border="0"></a>
        </td>
        <td class='content'>
            <BR>
            <input type=hidden name='Kreditkarten_Hersteller' value='<?= $Kreditkarten_Hersteller ?>'>
            <input type=hidden name='Erfolg' value='1'>
            <input type=hidden name='GNUPG' value='1'>
            <input type=hidden name='darstellen' value='7'>
            <input type=hidden name=message_string_adr value="<?= $message_string_adr ?>">
            <input type=hidden name=email value="<?= $email ?>">
            <input type=hidden name=Zahlungsart value="<?= $Bezahlungsart ?>">
            &nbsp;<input type=image src='Buttons/bt_weiter.gif' border="0">
        </td>
        <td>&nbsp;</td>
      </tr>
    </table>
        </td>
      </tr>
    </table>
    </form>
<?php
} // end of darstellen = 5

  // -----------------------------------------------------------------------
  // Kreditkartenhandling *** EXTERN ***
  // Hier wird die Funktion payment_extern($Pay) aufgerufen. Ihr wird im Argument
  // eine Pay mitgegeben (siehe auch pay_def.php), darin befinden sich alle
  // noetigen Informationen betreffend
  // -----------------------------------------------------------------------
else if ( $darstellen == 6){
  // Damit wir dem Interface-Modul payment_interface ein Pay-Objekt mit allen
  // benoetigten Daten uebergeben koennen, muessen wir hier eines erzeugen und
  // die entsprechenden Daten abfuellen:
  // Ein neues Pay-Objekt instanzieren
  $myPay = new Pay;
  // Session_ID des aktuellen Kunden auslesen
  $Session_ID = session_id();
  // Die Funktion checkSession liefert uns hier die Kunden_ID
  $Kunden_ID = checkSession($Session_ID);
  // Kunde abfuellen
  $myPay->myKunde = getKunde($Kunden_ID);
  // Bestellung abfuellen
  $myPay->myBestellung = getBestellung($Session_ID);
  // Hier wird die Ruecksprung-URL angegeben. Diese URL beschreibt den Ort im
  // PhPepperShop, wo nach der externen Zahlungsabwicklung die Bestellung entweder
  // akzeptiert und abgeschlossen wird oder aber wo die Bestellung nach nicht erfolg-
  // reicher Zahlungsabwicklung der Kunde an eine weiterleidende Page gefuehrt wird.
  $myPay->myReferrer = "http://".$SERVER_NAME.$PHP_SELF."?darstellen=4";
  // Wir speichern den E-Mail-Message-String temporaer in der Kunden-Bestellung.
  // Dieser String wird zur Erstellung des E-Mails an Kunde und Shopbetreiber benoetigt.
  putEmailMessage(addslashes(urldecode($message_string_adr)),$Session_ID)
?>
  <script language="JavaScript">
  <!--
  function chkFormular() {
    // ueberpruefen, ob die AGB's akzeptiert wurden
    if(document.Formular.agb[1].checked) {
        alert("Sie mssen die AGB's akzeptieren, um bestellen zu knnen!");
        document.Formular.agb[1].focus();
        return false;
    } // end of if
    else {
        return true;
    }// end of else
  } // end of fuction chkFormular
  //-->
  </script>

  <center>
  <table border=0 cellspacing=0 cellpadding=0 class=content width='80%'>
    <tr class=content>
      <td class=content>
<?php
  // AGB ausgeben
  echo "<h3 class='content'>Allgemeine Gesch&auml;ftsbedingungen</h3>";
  echo getAGB();

  // Hidden-Formular, damit wir die Variablen per Post weitergeben koennen
?>
      </td>
    </tr>
    <tr><td>&nbsp;</td></tr>
    <tr class=content>
      <td class=content>
<?php
          // Nun wird die Funktion payment_extern($myPay) aufgerufen. Sie enthaelt den Beginn
          // des folgenden Formulars (damit im action=''-Teil der Ziel URL konfiguriert werden
          // kann. Um die Ansteuerung der externen Zahlungsstelle konfigurieren zu koennen,
          // editieren Sie die Datei payment_interface.php in diesem Verzeichnis.
          if (!payment_extern($myPay)) {
              die("<h2>U_B_1_Error: darstellen == 6: Die Funktion payment_extern(\$myPay) wurde nicht korrekt beendet</h2>");
          }
?>
          <input type=hidden name=darstellen value=4>
          <input type=hidden name=message_string_adr value="<?= $message_string_adr ?>">
          <input type=hidden name=email value="<?= $email ?>">
          <input type=hidden name=Zahlungsart value="<?= $Bezahlungsart ?>">
          <input type=radio name="agb" value="ja">&nbsp;Ja, ich akzeptiere die allgemeinen Gesch&auml;ftsbedingungen und will bestellen<BR>
          <input type=radio name="agb" value="nein" checked>&nbsp;Nein, ich akzeptiere die allgemeinen Gesch&auml;ftsbedingungen <B style='font-weight:bold'>nicht</B><BR>
      </td>
    </tr>
    <tr><td>&nbsp;</td></tr>
    <tr class=content>
      <td class=content>
          <center><input type=image src='Buttons/bt_bestellung_absenden.gif' border="0"></center>
        </form>
      </td>
    </tr>
  </table>
  </center>
<?php
} // end of darstellen = 6

else if ($darstellen == 7) {

  // Wenn wir eine interne Kreditkartenzahlung haben, so wird uns die Variable GNUPG mit dem
  // Wert 1 von darstellen == 5 her uebergeben. Wir ueberpruefen also zuerst die Kreditkarten
  // Nummer, falls sie falsch ist, senden wir sie zurueck und der Kunde soll sie nochmals eingeben.
  // Zur Erkennung geben wir das Flag $Kreditkarten_Nummer_ungueltig = 1 mit.
  if ($GNUPG == 1) {
      //Kreditkarten Institutname fuer validateCC Funktion umbenennen
      if (urldecode($Kreditkarten_Hersteller) == "VISA") {
          $creditcard = "visa";
      }
      elseif (urldecode($Kreditkarten_Hersteller) == "Eurocard/Mastercard") {
          $creditcard = "mastercard";
      }
      elseif (urldecode($Kreditkarten_Hersteller) == "American Express") {
          $creditcard = "amex";
      }
      elseif (urldecode($Kreditkarten_Hersteller) == "Diners Club") {
          $creditcard = "discover";
      }
      else {
          $creditcard = "discover";
      }

      //VALIDATE CREDITCARD!
      $ok = validateCC($Kreditkarten_Nummer, $creditcard);
      $mydate = getdate();
      $Jahr = substr($mydate[year],2,2);
      $Monat = $mydate[mon];
      if ($Jahr > $Kreditkarten_Ablaufdatum_2) {
          $ok = 0;
      }
      elseif ($Jahr == $Kreditkarten_Ablaufdatum_2) {
          if ($Monat > $Kreditkarten_Ablaufdatum_1) {
              $ok = 0;
          }
      }

      if (($ok == 0) || ($ok == -1)) {
        echo "<center>";
        echo "<form action='".$PHP_SELF."' method='post' name='Formular'>\n";
        echo "<table class='content'>\n";
        echo "<tr class='content'>\n";
        echo "  <td class='content'>\n";
        echo "      <h3 class='content'>Fehler!</h3>";
        echo "      <h4>Ihre Kreditkartennummer ist ung&uuml;ltig, oder Ihre Kredikarte ist abgelaufen!</h4>\n";
        echo "      <LI>Mit Weiter k&ouml;nnen Sie die Eingaben nochmals t&auml;tigen</LI>\n";
        echo "      <LI>Mit Zur&uuml;ck k&ouml;nnen Sie eine andere Zahlungsart w&auml;hlen</LI>\n";
        echo "      <input type=hidden name='darstellen' value='5'>\n";
        echo "      <input type=hidden name='Kreditkarten_Hersteller' value='$Kreditkarten_Hersteller'>\n";
        echo "      <input type=hidden name='Kreditkarten_Nummer' value='$Kreditkarten_Nummer'>\n";
        echo "      <input type=hidden name='Kreditkarten_Ablaufdatum_1' value='$Kreditkarten_Ablaufdatum_1'>\n";
        echo "      <input type=hidden name='Kreditkarten_Ablaufdatum_2' value='$Kreditkarten_Ablaufdatum_2'>\n";
        echo "      <input type=hidden name='Vorname' value='$Kreditkarten_Vorname'>\n";
        echo "      <input type=hidden name='Nachname' value='$Kreditkarten_Nachname'>\n";
        echo '      <BR><BR><a href="'.$PHP_SELF.'?darstellen=1"><img src="Buttons/bt_zurueck.gif" border="0"></a>&nbsp;'."\n";
        echo "      <input type=image src='Buttons/bt_weiter.gif' border='0'>\n";
        echo "  </td>\n";
        echo "</tr>\n";
        echo "</table>\n";
        echo "</form>\n";
        echo "</center">
        exit; //Abbruch
      }// End if $wrong

?>
  <script language="JavaScript">
  <!--
  function chkFormular() {
    // ueberpruefen, ob die AGB's akzeptiert wurden
    if(document.Formular.agb[1].checked) {
        alert("Sie mssen die AGB's akzeptieren, um bestellen zu knnen!");
        document.Formular.agb[1].focus();
        return false;
    } // end of if
    else {
        return true;
    }// end of else
  } // end of fuction chkFormular
  //-->
  </script>

  <center>
  <form action="<?= $PHP_SELF ?>" method="POST" name="Formular" onSubmit="return chkFormular()">
  <table border=0 cellspacing=0 cellpadding=0 class=content width='80%'>
    <tr class=content>
      <td class=content>
<?php
  // AGB ausgeben
  echo "<h3 class='content'>Allgemeine Gesch&auml;ftsbedingungen</h3>";
  echo getAGB();

  // Hidden-Formular, damit wir die Variablen per Post weitergeben koennen
?>
      </td>
    </tr>
    <tr><td>&nbsp;</td></tr>
    <tr class=content>
      <td class=content>
          <input type=radio name="agb" value="ja">&nbsp;Ja, ich akzeptiere die allgemeinen Gesch&auml;ftsbedingungen und will bestellen<BR>
          <input type=radio name="agb" value="nein" checked>&nbsp;Nein, ich akzeptiere die allgemeinen Gesch&auml;ftsbedingungen <B style='font-weight:bold'>nicht</B><BR>
      </td>
    </tr>
    <tr><td>&nbsp;</td></tr>
    <tr class=content>
      <td class=content>
            <input type=hidden name='Kreditkarten_Hersteller' value='<?= $Kreditkarten_Hersteller ?>'>
            <input type=hidden name='Kreditkarten_Nummer' value='<?= $Kreditkarten_Nummer ?>'>
            <input type=hidden name='Kreditkarten_Ablaufdatum_1' value='<?= $Kreditkarten_Ablaufdatum_1 ?>'>
            <input type=hidden name='Kreditkarten_Ablaufdatum_2' value='<?= $Kreditkarten_Ablaufdatum_2 ?>'>
            <input type=hidden name='Kreditkarten_Vorname' value='<?= $Kreditkarten_Vorname ?>'>
            <input type=hidden name='Kreditkarten_Nachname' value='<?= $Kreditkarten_Nachname ?>'>
            <input type=hidden name='Erfolg' value='1'>
            <input type=hidden name='GNUPG' value='1'>
            <input type=hidden name='darstellen' value='4'>
            <input type=hidden name=message_string_adr value="<?= $message_string_adr ?>">
            <input type=hidden name=email value="<?= $email ?>">
            <input type=hidden name=Zahlungsart value="<?= $Bezahlungsart ?>">
            <center><input type=image src='Buttons/bt_bestellung_absenden.gif' border="0"></center>
      </td>
    </tr>
  </table>
  </form>
  </center>
<?php
exit;

  }// End if GNUPG == 1
}// End darstellen == 7


// -----------------------------------------------------------------------
// Zahlungsart billBOX gewhlt
// Drueckt der Shopkunde auf den "Bestellung absenden" Button, wird ein
// auf dem Server der Firma billBOX befindliches Perl-Script ausgefhrt.
// Der Shopkunde bekommt eine Telefonnummer angezeigt, auf die er anrufen
// muss. Wenn er bei billBOX registrierter Kunde ist, wird die Zahlung
// ausgelst.
// -----------------------------------------------------------------------
else if ( $darstellen == 8){
  // Ein neues Bestellungs-Objekt instanzieren
  $myBestellung = new Bestellung;
  // Session_ID des aktuellen Kunden auslesen
  $Session_ID = session_id();
  // Bestellung abfuellen
  $myBestellung = getBestellung($Session_ID);
  // Auslesen des Rechnungsbetrags
  $Rechnungsbetrag = $myBestellung->Rechnungsbetrag;
  // Auslesen des einzusetzenden Scriptnamens
  // Dieses wird in der Tabelle zahlung_weitere in der Zeile eins unter dem Attribut Par1 gespeichert.
  $weitereZahlungsmethoden = getAllezahlungen();
  $myZahlungsarray = $weitereZahlungsmethoden->getallzahlungen();
  $myParameterarray = $myZahlungsarray[0]->getallparameter();
  $billBOX_Scriptname = $myParameterarray[0];
  // Wir speichern den E-Mail-Message-String temporaer in der Kunden-Bestellung.
  // Dieser String wird zur Erstellung des E-Mails an Kunde und Shopbetreiber benoetigt.
  putEmailMessage(addslashes(urldecode($message_string_adr)),$Session_ID)
?>
  <script language="JavaScript">
  <!--
  function chkFormular() {
    // ueberpruefen, ob die AGB's akzeptiert wurden
    if(document.Formular.agb[1].checked) {
        alert("Sie mssen die AGB's akzeptieren, um bestellen zu knnen!");
        document.Formular.agb[1].focus();
        return false;
    } // end of if
    else {
        return true;
    }// end of else
  } // end of fuction chkFormular
  //-->
  </script>

  <center>
  <table border=0 cellspacing=0 cellpadding=0 class=content width='80%'>
    <tr class=content>
      <td class=content>
<?php
  // AGB ausgeben
  echo "<h3 class='content'>Allgemeine Gesch&auml;ftsbedingungen</h3>";
  echo getAGB();

  // Hidden-Formular, damit die darstellen-Variable weitergegeben werden kann
?>
      </td>
    </tr>
    <tr><td>&nbsp;</td></tr>
    <tr class=content>
      <td class=content>
        <form action="<?= $PHP_SELF ?>" method="POST" name="Formular" onSubmit="return chkFormular()">
          <input type=radio name="agb" value="ja">&nbsp;Ja, ich akzeptiere die allgemeinen Gesch&auml;ftsbedingungen und will bestellen<BR>
          <input type=radio name="agb" value="nein" checked>&nbsp;Nein, ich akzeptiere die allgemeinen Gesch&auml;ftsbedingungen <B style='font-weight:bold'>nicht</B><BR>
        </form>
      </td>
    </tr>
    <tr><td>&nbsp;</td></tr>
    <tr class=content>
      <td class=content>
         <center><a href="http://www.phonegate.ch/cgi-bin/billbox/<?php echo $billBOX_Scriptname; ?>?<?php printf ("%01.2f", $Rechnungsbetrag); ?>" onClick="return chkFormular()" ><img src="Buttons/bt_bestellung_absenden.gif" border="0"></a></center>
      </td>
    </tr>
  </table>
  </center>
<?php
} // end of darstellen = 8

// -----------------------------------------------------------------------
// - Unterscheidung des Workflows je nach Bezahlungsart:
//   - Vorauskasse, Rechnung, Nachnahme: AGB akzeptiert?, weiter
//   - Interne Kreditkartenzahlung: Nummer validieren, GNU-PG enable, weiter
//   - Externe Kreditkartenzahlung: E-Mail String zuruecklesen, weiter
// - Bestellung an Kunden und Shopinhaber mailen
// - Danke an Shopuser ausgeben (mit Kontaktierungsmoeglichkeit bei Fragen)
// - Bestellung abschliessen
// - Alle alten Session-ID's aus Datenbank loeschen
// -----------------------------------------------------------------------
else if ( $darstellen == 4){
  if ($agb == "nein") {
?>
          <center>
          <table border=0 width=80%>
            <tr class='content'>
              <td class='content'>
                <h3 class='content'>AGB nicht akzeptiert!</h3></td></tr>
              </td>
            </tr>
            <tr class='content'>
              <td class='content'>
                <b class='content' style='font-weight:bold'>Damit eine Bestellung ausgel&ouml;st werden kann, m&uuml;ssen die allgemeinen Gesch&auml;ftsbedingungen akzeptiert werden</b>
                <ul>
                  <li>Wenn Sie die Bestellung ausl&ouml;sen wollen, klicken Sie auf zur&uuml;ck</li>
                  <li>Falls Sie unsere allgemeinen Gesch&auml;ftsbedingungen nicht akzeptieren, so k&ouml;nnen Sie jetzt Ihren Browser schliessen. Ihre Bestellung wird nicht ausgef&uuml;hrt.</li>
                </ul>
              </td>
            </tr>
            <tr class='content'>
              <td class='content'>
                <form action="<?= $PHP_SELF ?>" name="Formular" method="POST">
                  <input type=hidden name=message_string_adr value="<?= $message_string_adr ?>">
                  <input type=hidden name=email value="<?= $email ?>">
                  <input type=hidden name=Zahlungsart value="<?= $Bezahlungsart ?>">
                  <input type=hidden name=darstellen value='3'>
                  <center><input type=image src='Buttons/bt_zurueck.gif' border="0"></center>
                </form>
              </td>
            </tr>
          </table>
          </center>
          </body>
          </html>
<?php
  // Falls der Kunde mit den AGB nicht einverstanden ist, so wird das Programm hier beendet
  // andernfalls, kann der Kunde mit dem zurck-Button wider zurck gehen (darstellen == 3)
  exit;
  }//End if agb == nein
  if ($Erfolg == 0) {
?>
          <center>
          <table border=0 width=80%>
            <tr class='content'>
              <td class='content'>
                <h3 class='content'>Fehler bei Zahlungsverarbeitung!</h3></td></tr>
              </td>
            </tr>
            <tr class='content'>
              <td class='content'>
                <?php if ($Errormessage != "") { ?>
                    <b class='content' style='font-weight:bold'>Genauere Fehlermeldung: <?= $Errormessage ?></b>
                <?php }?>
                <ul>
                  <li>Wenn Sie nochmals versuchen wollen zu zahlen oder eine andere Zahlungsmethode w&auml;hlen wollen, so klicken sie auf Zur&uuml;ck</li>
                  <li>Falls Sie die Bestellung nicht ausl&ouml;sen wollen, so k&ouml;nnen Sie jetzt Ihren Browser schliessen. Ihre Bestellung wird nicht ausgef&uuml;hrt.</li>
                </ul>
              </td>
            </tr>
            <tr class='content'>
              <td class='content'>
                <form action="<?= $PHP_SELF ?>" name="Formular" method="POST">
                  <input type=hidden name=darstellen value='1'>
                  <center><input type=image src='Buttons/bt_zurueck.gif' border="0"></center>
                </form>
              </td>
            </tr>
          </table>
          </center>
          </body>
          </html>
<?php
  // Falls der Kunde mit den AGB nicht einverstanden ist, so wird das Programm hier beendet
  // andernfalls, kann der Kunde mit dem zurck-Button wider zurck gehen (darstellen == 3)
  exit;
  }//End if Erfolg == 0




  // Zuerst von der Datenbank Daten auslesen
  $meineBestellung = new Bestellung;
  $meineBestellung = getBestellung(session_id());
  // Falls ein Kunde nach erfolgreicher Bestellung den Zurueck-Button des Browsers verwendet
  // so wird das hier abgefangen, er sieht dann
  if ($meineBestellung->Bestellung_abgeschlossen == "") {
      echo "<h3>Sie haben Ihre Bestellung schon abgeschlossen!</h3>";
      exit;
  }

  // Wenn wir von darstellen == 6 her kommen, dann wurde die Zahlung extern abge
  // wickelt und der E-Mail-Message-String temporaer in der Kunden-Bestellung in der
  // Datenbank gespeichert. Wir holen ihn gegebenenfalls aus der DB zurueck.
  if (urldecode($message_string_adr) == "") {
      // String ist leer, in diesem Fall muessen wir ihn von der Kundentabelle auslesen
      // und ihn dort danach loeschen (die Funktion getEmailMessage uebernimmt beides)
      $message_string_adr = getEmailMessage(session_id());
      // Weiter muessen wir hier noch die E-Mail Adresse des Kunden und die Bezahlungs-
      // art in Variablen fuer die weitere Bearbeitung bereitstellen
      $Kunden_ID = checkSession(session_id());
      $meinKunde = getKunde($Kunden_ID);
      $email = $meinKunde->Email;
  }

  // abfuellen der Bestellungsdaten in Variablen
  $Bestellungs_ID = $meineBestellung->Bestellungs_ID;
  $Session_ID = $meineBestellung->Session_ID;
  $Datum = $meineBestellung->Datum;
  // *** OLD ***  $Endpreis = $meineBestellung->Endpreis;
  $Bezahlungsart = $meineBestellung->Bezahlungsart;
  $Zahlungsart = $meineBestellung->Bezahlungsart;
  $Versandkosten = $meineBestellung->Versandkosten;
  $Mindermengenzuschlag = $meineBestellung->Mindermengenzuschlag;
  $Rechnungstotal = $meineBestellung->Rechnungsbetrag;

  // Auslesen der global benutzten Shopadresse:
  $shopadresse = getShopadresse();

  // Aktuelles Datum berechnen (wird dem Mailheader angehaengt)
  $mydate = getdate();
  $Datum = $mydate[mday].".".$mydate[mon].".".$mydate[year];// Format dd-mm-yyyy
  $message="--------------------------";
  if ($shopadresse[0] != "") { $message.="\nBestellung bei ".$shopadresse[0]; }
  if ($shopadresse[1] != "") { $message.="\n".$shopadresse[1]; }
  if ($shopadresse[2] != "") { $message.="\n".$shopadresse[2]; }
  if ($shopadresse[3] != "") { $message.="\n".$shopadresse[3]; }
  if ($shopadresse[4] != "") { $message.="\nE-Mail: ".$shopadresse[4]; }
  if ($shopadresse[5] != "") { $message.="\nTel. ".$shopadresse[5]; }
  if ($shopadresse[6] != "") { $message.="\nFax. ".$shopadresse[6]; }
  $message.="\nBestellung vom: ".$Datum;
  $message.="\n--------------------------\n\n";

  // die Bezahlungsart wieder Url-decodieren
  $Bezahlungsart = urldecode($Zahlungsart);

  // Adressdaten anhaengen
  $message.= urldecode($message_string_adr);

  $message.= "\n\nBestellungsinformationen:\n-------------------------\n";

  if ($Rechnungstotal - ($Mindermengenzuschlag + $Versandkosten) > 0.0) {
      $message.="Zahlungsart: ".$Bezahlungsart."\n";
  }
  else {
      $message.="Keine Bezahlung ntig, da Rechnungstotal = ".getWaehrung()." 0.00\n";
  }
  if ($Bezahlungsart == "Vorauskasse") {
      $message.=getKontoinformation()."\n";
  }

  // Artikel auslesen
  $warenkorb = darstellenStringBestellung($meineBestellung);

  // Mail an Shopinhaber versenden
  $to=getShopEmail();
  $subject="neue Bestellung Webshop vom ".$Datum." !";
  $header="From: \"Shopadministrator <".getShopEmail().">\"\n";
  // notwendig, damit deutsche Umlaute richtig angezeigt werden
  $header.="Content-Type: text/plain; charset=iso-8859-1";

  // Wenn es sich um eine interne Kreditkartenzahlung handelt, so ist das Flag
  // GNUPG = 1. Wir werden nun zuerst das Shopbetreiber-Email mit GNU-PG verschluesseln
  // und es erst so an den Shop-Betreiber versenden
  $newmessage = $message; //$newmessage ist die Message an den Shop-Betreiber
  if ($GNUPG == 1) {
      $newmessage.="Kreditkarten Institut:    ".urldecode($Kreditkarten_Hersteller);
      $newmessage.="\nKreditkartennummer:       ".urldecode($Kreditkarten_Nummer);
      $newmessage.="\nKreditkarten Ablaufdatum: ".urldecode($Kreditkarten_Ablaufdatum_1)."/".urldecode($Kreditkarten_Ablaufdatum_2);
      $newmessage.="\nVorname des Inhabers:     ".urldecode($Kreditkarten_Vorname);
      $newmessage.="\nNachname des Inhabers:    ".urldecode($Kreditkarten_Nachname)."\n";
      $newmessage.=$warenkorb;

      // ******** NOCH NICHT IMPLEMENTIERT ********
      // An dieser Stelle sollte das E-Mail mit GNUPG verschluesselt werden!!!
      // ******** NOCH NICHT IMPLEMENTIERT ********

      if (!mail ($to, $subject, $newmessage, $header)){
        echo "<h1 class='content'>Probleme beim Mailversand.. bitte nehmen sie per E-Mail oder telefonisch Kontakt mit uns auf!</h1>";
        echo "<B>Vielleicht hat der Shop-Betreiber seine eigene Shop E-Mail Adresse noch nicht konfiguriert!</B>";
      }

  }
  else {
      if ($Bezahlungsart == "billBOX"){
          $newmessage.="\nDie billBOX Tracking-Nummer ist: $tracking\n";
      }
      // IP-Adresse des Kunden mit uebertragen:
      $newmessage.="IP-Adresse des Kunden: ".$HTTP_SERVER_VARS["REMOTE_ADDR"]." (Uhrzeit: ".$mydate[hours].":".$mydate[minutes]."h)\n";
      $newmessage.=$warenkorb;
      if (!mail ($to, $subject, $newmessage, $header)){
        echo "<h1 class='content'>Probleme beim Mailversand.. bitte nehmen sie per E-Mail oder telefonisch Kontakt mit uns auf!</h1>";
        echo "<B>Vielleicht hat der Shop-Betreiber seine eigene Shop E-Mail Adresse noch nicht konfiguriert!</B>";
      } // end of if !mail
  } // end of else

  //Mail an Shopkunden versenden, falls dieser eine E-Mail-Adresse eingegeben hat
  $email_kunde = urldecode($email);
  if ($email_kunde != ""){
      $to=$email_kunde;
      $subject="Bestellungsbesttigung - ".getshopname();
      $header="From: ".getShopEmail();
      $message.=$warenkorb;
      // notwendig, damit deutsche Umlaute richtig angezeigt werden
      $header.="\nContent-Type: text/plain; charset=iso-8859-1";
      if (!mail ($to, $subject, $message, $header)){
          echo "<h1 class='content'>Probleme beim Mailversand.. bitte nehmen sie per E-Mail oder telefonisch Kontakt mit uns auf!</h1>";
      }
  } // end of if $email_kunde != ""

  // Bestellung einem Kunden fest zuordnen
  gibBestellung_an_Kunde($Bestellungs_ID, checkSession(session_id()));

  // 'Einkaufsvolumen' und 'letztes Bestelldatum' aktualisieren
  addEinkaufsvolumen(session_id(), $meineBestellung->Rechnungsbetrag);

  // Bestellung abschliessen, sodass sie nicht geloescht wird wenn man das
  // Bestellungsmanagement eingeschaltet hat. Als zweites Argument wird ein Flag
  // uebergeben, mit welchem gesagt wird, ob die Bestellung als abgeschlossen markiert
  // werden soll. Abgeschlossene Bestellungen werden nicht mehr automatisch geloescht.
  schliessenBestellung(session_id(), getBestellungsmanagement());

  // Alle alten Session-ID's aus Datenbank loeschen, damit werden auch alle temporaeren Bestellungen / -Kunden geloescht
  delallexpiredSessions();

  // Styles fuer die Links aus der Datenbank auslesen und den Stylestring zusammenbauen
  $stylestring = 'class="content" style="text-decoration:'.getcssarg("main_link_d").';
    color:'.getcssarg("main_link_c").'; font-style:'.getcssarg("main_link_i").'; font-size:'.getcssarg("main_link_s").';
    font-weight:'.getcssarg("main_link_w").'"';

  // Bestaetigung und Dank an Browser ausgeben
  ?>

  <SCRIPT LANGUAGE="JavaScript">
  <!-- Begin
    function popUp(URL) {
        day = new Date();
        id = day.getTime();
        eval("page" + id + " = window.open(URL, '" + id + "', 'toolbar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=0,width=640,height=480,left = 312,top = 234');");
    }
  // End -->
  </script>

  <TABLE class="content" border="0" cellpadding="0" cellspacing="0" width="100%" height="100%">
    <TR class='content'>
      <TD class='content' ALIGN=center VALIGN=middle >
        <h3 class='content'>Herzlichen Dank fr Ihre Bestellung</h3>
        <h4 class='content'>Falls Sie noch Fragen haben, benutzen <br>Sie bitte unsere <A <?= $stylestring ?> href="javascript:popUp('./kontakt.php')">Kontaktm&ouml;glichkeiten</a></h4>
      </TD>
    </TR>
  </TABLE>
  <?php
}

// -----------------------------------------------------------------------
// Folgender Fall sollte eigentlich nie auftreten. Falls doch, wird eine
// Fehlermeldung ausgegeben.
// -----------------------------------------------------------------------
else {
  echo "<h1 class='content'>Fehlerhafter Aufruf! Die darstellen-Variable wurde nicht &uuml;bergeben!</h1>";
  }

// Footer ausgeben (fr alle Darstellungen gleich)
?>
  </body>
</html>

<?php
  // End of file-----------------------------------------------------------------------
?>
