<?php
  // Filename: USER_ADMIN_HILFE.php
  //
  // Modul: USER_ADMIN_HILFE
  //
  // Autoren: Jos Fontanil & Reto Glanzmann
  //
  // Zweck: Beinhaltet alle Hilfe-Texte fr USER und ADMIN Pages
  //
  // Sicherheitsstatus:        *** USER ***
  //
  // Version: 1.2
  //
  // CVS-Version / Datum: $Id: USER_ADMIN_HILFE.php,v 1.15 2002/09/17 19:58:35 fontajos Exp $
  //
  // -----------------------------------------------------------------------
  //
  // Lizenz
  // ======
  // PhPepperShop Shopsystem
  // Copyright (C) 2001  Reto Glanzmann, Jos Fontanil
  //
  // This program is free software; you can redistribute it and/or modify
  // it under the terms of the GNU General Public License as published by
  // the Free Software Foundation; either version 2 of the License, or
  // (at your option) any later version.
  //
  // This program is distributed in the hope that it will be useful,
  // but WITHOUT ANY WARRANTY; without even the implied warranty of
  // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  // GNU General Public License for more details.
  //
  // You should have received a copy of the GNU General Public License
  // along with this program; if not, write to the Free Software
  // Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  //
  // -----------------------------------------------------------------------  
  // Damit jedes andere Modul ueberpruefen kann ob dieses hier schon "included" ist
  // wird folgende Vairable auf true gesetzt (Name = Name des Moduls ohne .php)
  $USER_ADMIN_HILFE = true;

  // -----------------------------------------------------------------------
  // Session_management: (Ueberpruefen ob eine Session_ID uebergeben wurde,
  // sonst eine neue erzeugen (Dieser Code-Teil muss VOR dem HTML-Header stehen!)
  if(empty($mySession_ID)){
      session_name("mySession_ID");
      if (session_register("mySession_ID")) {
          /*Zu debug zwecken ausklammern
          echo "<B>USER_BESTELLUNG_AUFRUF.php: Meine <I>NEUE</I> Session_ID: Begin---".session_id()."---End Session_ID</B><BR><BR>";
          */
      }
      else {
          die("<P><H1>USER_BESTELLUNG_AUFRUF.php: ACHTUNG session_register() = false, konnte keine Session_ID zuteilen</H1></P><BR><BR>");
      }
  }
  else {
      session_id($mySession_ID);
  }

  // -----------------------------------------------------------------------
  // include Pfad anpassen. Dabei werden die unterschiedlichen Delimiter-Zeichen fuer
  // Windows und UNIX/Linux beruecksichtigt. Danke fuer die Idee an Eduard Mas Walgram.
  // Windows --> Delimiter = Strichpunkt | UNIX/Linux --> Delimiter = Doppelpunkt
  if (strlen($HTTP_ENV_VARS["WINDIR"]) > 0) {$pd = ";";} else {$pd = ":";}//$pd = path delimiter
  ini_set("include_path", "./$pd../$pd../../$pd./Frameset$pd./shop$pd/usr/local/lib/php");

  // Einbinden der benoetigten Module (PHP-Scripts)
  // Bei Unklarheiten, siehe include-Hierarchie in der Dokumentation
  if (!isset($initialize)) {include("initialize.php");}
  if (!isset($USER_SQL_BEFEHLE)) {include("USER_SQL_BEFEHLE.php");}
  if (!isset($USER_ARTIKEL_HANDLING)) {include("USER_ARTIKEL_HANDLING.php");}

  // Damit der PhPepperShop auch mit der PHP-Einstellung Register Globals = Off funktioniert, werden die Request Arrays
  // $HTTP_GET_VARS und dann $HTTP_POST_VARS in die Standardsymboltabellen ausgelesen. (Post ueberschreibt dabei GET!)
  extract($HTTP_GET_VARS);
  extract($HTTP_POST_VARS);

  // -----------------------------------------------------------------------
  // HTML_HEAD + body open
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta http-equiv="content-language" content="de">
<meta name="author" content="Jos Fontanil and Reto Glanzmann">
<title>Shop</title>
<LINK REL=STYLESHEET HREF="shopstyles.css" TYPE="text/css">
</head>
<body class="content">
    <P>
<?php

  // -----------------------------------------------------------------------
  // Diese Funktion liefert einen String der den entsprechenden Hilfetext
  // der angeforderten Seite enthaelt
  // Hilfe_ID = Filename und optionalem suffix:  _1 _2 ...
  // Argument: Hilfe_ID
  // Rueckgabewert: Text zur aktuellen Seite (String)
  function getHilfe($Hilfe_ID) {
      global $Database;
      global $sql_getHilfe_1_1;
      global $sql_getHilfe_1_2;
      if (! is_object($Database)) {
          die("<P><H1>USER_ADMIN_HILFE_Error: Datenbank nicht erreichbar</H1></P><BR>\n");
      }
      else {
          // Query ausfuehren und in ResultSet schreiben (Typ ResultSet, siehe database.php)
          $RS = $Database->Query("$sql_getHilfe_1_1".$Hilfe_ID."$sql_getHilfe_1_2");
          if (is_object($RS) && $RS->NextRow()){
              $Hilfetext = $RS->Getfield("Hilfetext");
          }
          else {
              echo "USER_ADMIN_HILFE: getHilfe: Konnte Hilfetext nicht auslesen / Kein Text vorhanden <BR>";
              die("Query: $sql_getHilfe_1_1.$Hilfe_ID.$sql_getHilfe_1_2<BR>");
          }
      }
      return $Hilfetext;
  }// End getHilfe


  // Styles fuer die Links aus der Datenbank auslesen und den Stylestring zusammenbauen
  $stylestring = 'class="content" style="text-decoration:'.getcssarg("main_link_d").';
        color:'.getcssarg("main_link_c").'; font-style:'.getcssarg("main_link_i").'; font-size:'.getcssarg("main_link_s").';
        font-weight:'.getcssarg("main_link_w").'"';

  // Falls die Haupthilfe aufgerufen wird, hat der Shopbenutzer die Moeglichkeit, per Link zu den Kontaktinformationen
  // des Shops zu kommen
  if ($Hilfe_ID == "top"){
      echo '<b class="content">Bei Fragen oder Problemen benutzen Sie bitte unsere <a '.$stylestring.' href="./kontakt.php"><b>Kontaktm&ouml;glichkeiten</b></a><br><br></b>';
  }

  // Funktion aufrufen --> Hilfetext einfuegen
  echo "<B class='content'>".getHilfe($Hilfe_ID)."</B><BR>";
  echo '<center><p><A '.$stylestring.' href="javascript:window.close();" class="content">Fenster schliessen</a></p></center>';
?>
    </P>
</body>
</html>
<?php
  // End of file------------------------------------------------------------
?>
