<?php
  // Filename: error_control.php
  //
  // Modul: Error Handling/Logging
  //
  // Autoren: Jos Fontanil & Reto Glanzmann
  //
  // Zweck: Fehlerbehandlungsroutinen
  //
  // Sicherheitsstatus:                 *** USER ***
  //
  // Version: 1.2
  //
  // CVS-Version / Datum: $Id: error_control.php,v 1.5 2002/11/12 01:19:25 fontajos Exp $
  //
  // -----------------------------------------------------------------------
  //
  // Lizenz
  // ======
  // PhPepperShop Shopsystem
  // Copyright (C) 2001  Reto Glanzmann, Jos Fontanil
  //
  // This program is free software; you can redistribute it and/or modify
  // it under the terms of the GNU General Public License as published by
  // the Free Software Foundation; either version 2 of the License, or
  // (at your option) any later version.
  //
  // This program is distributed in the hope that it will be useful,
  // but WITHOUT ANY WARRANTY; without even the implied warranty of
  // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  // GNU General Public License for more details.
  //
  // You should have received a copy of the GNU General Public License
  // along with this program; if not, write to the Free Software
  // Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  //
  // -----------------------------------------------------------------------  
  // Damit jedes andere Modul ueberpruefen kann ob dieses hier schon "included" ist
  // wird folgende Vairable auf true gesetzt (Name = Name des Moduls ohne .php)
  $error_control = true;

  // Folgende Konstante wird spaeter einmal in eine Konfigurationsdatei ausgelagert werden
  // Dann kann einfach gesteuert werden, ob debug-Meldungen angezeigt werden sollen oder nicht.
  define("DEBUG",true); // Im Moment wird die debug-Funktion nur zum Programmieren bentigt
                        // Die Meldungen werden nach den Tests wieder entfernt.

  // Pfad Delimiter je nach Betriebssystem setzen (fuer zukuenftige Verwendung)
  if (PHP_OS == "WINNT" || PHP_OS == "WIN32" || strlen($HTTP_ENV_VARS["WINDIR"]) > 0) {$pd = ";";} else {$pd = ":";}

  // -----------------------------------------------------------------------
  // Die debug-Funktion schreibt die darin angegebene Variable speziell formatiert auf die Standardausgabe.
  // Die beiden optionalen Parameter $arg1 und $arg2 koennen je entweder die Linie (__LINE__) oder
  // den Dateinamen der entsprechenden Datei (__FILE__) beinhalten von welcher die Meldung ausgegeben werden sollte.
  // Falls es sich bei der Variable $data um ein Objekt oder um einen Array handelt, wird dieses detailliert angezeigt.
  // Argumente: $data (String|Array|Object), arg1 (String - optional), $arg2 (Integer - optional)
  // Rueckgabewert: true (boolean) bei Erfolg
  function debug($data, $arg1="", $arg2="") {
      // Debug Anweisungen werden nur ausgegeben, wenn der Debug Modus eingeschaltet ist.
      // Dies ist der Fall, wenn in der ppd.cfg.php Datei die DEBUG Konstante auf true gesetzt ist.
      if (DEBUG == "true") {
          // Tabelle zur uebersichtlicheren Gestaltung erstellen
          echo "<table border=1 bordercolor=\"#550088\">\n<tr><td>\n<b><font color=\"#ff0000\">Debug message:</font> $data</b>\n</td></tr>\n";

          // Fallentscheidungen ob zuerst die Linie und dann der Dateiname oder andersrum angegeben wird, oder nur eins von beiden
          if (is_string($arg1) && $arg1 != "") {
              echo "<tr><td>\nin file:<b> ".$arg1."</b>\n</td></tr>\n";
          }
          elseif (is_int($arg1) && $arg1 != "") {
              echo "<tr><td>\nat line:<b> ".$arg1."</b>\n</td></tr>\n";
          }
          if (is_string($arg2) && $arg2 != "") {
              echo "<tr><td>\nin file:<b> ".$arg2."</b>\n</td></tr>\n";
          }
          elseif (is_int($arg2) && $arg2 != "") {
              echo "<tr><td>\nat line:<b> ".$arg2."</b>\n</td></tr>\n";
          }
          if (gettype($data) == "array" || gettype($data) == "object") {
              if (count($data) > 0) {
                  echo "<tr><td><PRE>";
                  print_r($data);
                  echo "</PRE></td></tr>";
              }
          }
          echo "</table>\n";
      }// End if DEBUG == true
  }// End function debug

  // Diese Funktion liefert Benchmarking-Funktionalitaet (primaer zu Debug-Zwecken)
  // Man kann einen Timer starten und dann an beliebigen Orten Stoppmarken setzen und
  // sich am Ende eine Zusammenfassungen der Zeiten anzeigen lassen.
  // Argumente: $label kann folgende Werte annehmen:
  // - init  : Initialisierung eines neuen Timers (Timer starten)
  // - print : Anzeigen aller Stoppmarken und der Totalzeit
  // - oder den Namen (Beschreibung) der Stoppmarke
  // Rueckgabewert:
  function debug_timing ($label) {
      static $basetime,$totaltime,$rpttimes;

      // Initialisierung des Timers
      if ($label == "init") {
          $rpttimes = array();
          $basetime = microtime();
          $totaltime = 0;
          ereg("^([^ ]+) (.+)", $basetime, $r);
          $basetime = doubleval($r[2]) + doubleval($r[1]);
          return;
      }

      // Ausgabe der Messungen
      if ($label == "print") {
          echo "<b>Timing Resultate:</b><br>\n";
          for ($i = 0;$i < count($rpttimes); $i++) {
              echo "    $rpttimes[$i]<br>\n";
          }
          echo "Total: $totaltime\n";
          return;
      }

      // sonst: aufzeichnen und aufkumulieren der bis jetzt abgelaufenen Zeit
      $newtime = microtime();
      ereg("^([^ ]+) (.+)", $newtime, $r);
      $newtime = doubleval($r[2]) + doubleval($r[1]);
      $diff = $newtime - $basetime;
      $rpttimes[] = sprintf("%-20s [%s]", $label, $diff);
      $basetime = $newtime;
      $totaltime += $diff;

  }// End function debug_timing

  // End of file-----------------------------------------------------------------------
?>
