<?php
  // Filename: kategorie_def.php
  //
  // Modul: Definitions
  //
  // Autoren: Jos Fontanil & Reto Glanzmann
  //
  // Zweck: Definiert die Klasse Artikel
  //
  // Sicherheitsstatus:                 *** USER ***
  //
  // Version: 1.2
  //
  // CVS-Version / Datum: $Id: kategorie_def.php,v 1.11 2002/10/23 15:55:54 fontajos Exp $
  // -----------------------------------------------------------------------
  //
  // Lizenz
  // ======
  // PhPepperShop Shopsystem
  // Copyright (C) 2001  Reto Glanzmann, Jos Fontanil
  //
  // This program is free software; you can redistribute it and/or modify
  // it under the terms of the GNU General Public License as published by
  // the Free Software Foundation; either version 2 of the License, or
  // (at your option) any later version.
  //
  // This program is distributed in the hope that it will be useful,
  // but WITHOUT ANY WARRANTY; without even the implied warranty of
  // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  // GNU General Public License for more details.
  //
  // You should have received a copy of the GNU General Public License
  // along with this program; if not, write to the Free Software
  // Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  //
  // -----------------------------------------------------------------------  
  // Damit jedes andere Modul ueberpruefen kann ob dieses hier schon "included" ist
  // wird folgende Vairable auf true gesetzt (Name = Name des Moduls ohne .php)
  $kategorie_def = true;

  // -----------------------------------------------------------------------
  // Definition eines Kategorie-Objekts:
  class Kategorie {
      //Instanzvariablen
      var $Kategorie_ID;
      var $Name;
      var $Positions_Nr;
      var $Beschreibung;
      var $Details_anzeigen;
      var $Bild_gross;
      var $Bild_klein;
      var $Bildtyp;
      var $Bild_last_modified;
      var $MwSt_default_Satz;  //Vorgewaehlter MwSt-Satz
      var $Unterkategorien = array();

      //Konstruktor
      function Kategorie() {
      }

      //putkategorie legt eine Unterkategorie einer Kategorie im internen Array ab
      function putunterkategorie($cle, $wert){
          $this->Unterkategorien[$cle] = $wert;
      }

      //getallkategorien liefert in einem assoz. Array alle Unterkategorien zurck
      function getallkategorien(){
          $kat = array();
          foreach(($this->Unterkategorien) as $keyname => $value){
              $kat[$keyname] = $value;
          }
          return $kat;
      }

      //getallkategorien liefert in einem assoz. Array alle Unterkategorien zurck
      function getFirstUkat(){
          return $this->Unterkategorien[0];
      }

      //kategorienanzahl liefert die Anzahl Elemente im Array $Unterkategorien
      function kategorienanzahl(){
              return count($this->Unterkategorien);
      }

  }// End class Kategorie

  // Eine Unterkategorie kann nur EINER Kategorie zugeordnet werden
  class Unterkategorie extends Kategorie {
      //Instanzvariablen
      var $Unterkategorie_von;

      //Konstruktor
      function Unterkategorie() {
          $Unterkategorie_von = "";
      }


      //getUnterkategorie_von liefert den Namen der Kategorie, welcher diese
      //Unterkategorie zugeordnet ist
      function getUnterkategorie_von(){
          return $this->Unterkategorie_von;
      }

      //setUnterkategorie_von setzt den Namen der Kategorie, welcher diese
      //Unterkategorie zugeordnet ist
      function setUnterkategorie_von($Eingabewert){
          $this->Unterkategorie_von = $Eingabewert;
      }

  }// End class Unterkategorie

  // End of file-----------------------------------------------------------------------
?>
