<?php
  // Filename: mwst_def.php
  //
  // Modul: Definitions
  //
  // Autoren: Jos Fontanil & Reto Glanzmann
  //
  // Zweck: Definiert die Klasse MwSt
  //
  // Sicherheitsstatus:                 *** USER ***
  //
  // Version: 1.2
  //
  // CVS-Version / Datum: $Id: mwst_def.php,v 1.2 2002/09/09 12:52:39 fontajos Exp $
  //
  // -----------------------------------------------------------------------
  //
  // Lizenz
  // ======
  // PhPepperShop Shopsystem
  // Copyright (C) 2001  Reto Glanzmann, Jos Fontanil
  //
  // This program is free software; you can redistribute it and/or modify
  // it under the terms of the GNU General Public License as published by
  // the Free Software Foundation; either version 2 of the License, or
  // (at your option) any later version.
  //
  // This program is distributed in the hope that it will be useful,
  // but WITHOUT ANY WARRANTY; without even the implied warranty of
  // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  // GNU General Public License for more details.
  //
  // You should have received a copy of the GNU General Public License
  // along with this program; if not, write to the Free Software
  // Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  //
  // -----------------------------------------------------------------------  
  // Damit jedes andere Modul ueberpruefen kann ob dieses hier schon "included" ist
  // wird folgende Vairable auf true gesetzt (Name = Name des Moduls ohne .php)
  $mwst_def = true;

  // -----------------------------------------------------------------------
  // Definiert die Klasse MwSt - Abkuerzung fuer Mehrwertsteuer. Diese Klasse
  // beherbergt aber noch mehr, als nur den eigentlichen MwSt-Satz. Seit der
  // PhPepperShopversion v.1.2 hat jeder Artikel eine eigene Mehrwertsteuer.
  // Diese Konfiguration erlaubt es dem Shopbesitzer gleichzeitig Artikel mit
  // verschiedenen Mehrwertsteuersaetzen zu verkaufen.
  // Die Klasse hat mehrerer Attribute: Zuerst einmal eine ID, welche nur intern
  // verwendet wird. Zweitens den MwSt-Satz, welcher als Prozentzahl interpretiert
  // wird. Es wurde auch noch ein Beschreibungsattribut hinzugefuegt.
  // Weiter gibt es noch Tabellenweite Attribute: MwSt-default-Satz (bool-enum) wird
  // zu Rate gezogen, wenn eine neue Kategorie erstellt wird. Alle Artikel in dieser
  // Kategorie verwenden defaultmaessig diesen MwSt-Satz. Zuletzt gibt es noch das
  // Attribut Preise_inkl_MwSt. Ein boolscher Wert (Char: "Y","N"), entscheidet, ob
  // shopweit alle Artikelpreise inkl. oder exkl. Mehrwertsteuer angegeben wurden. Dem-
  // entsprechend faellt natuerlich auch die Preisberechnung und Warenkorbgestaltung aus.
  //
  // Anmerkung: Die Mehrwertsteuernummer und die boolsche Einstellung, ob der Shop Umsatz-
  // steuerpflichtig ist, werden in der Tabelle shop_settings gespeichert und sind via eigene
  // Funktionen abrufbar.
  class MwSt {
      var $Mehrwertsteuer_ID;
      var $MwSt_Satz;
      var $Beschreibung;
      var $MwSt_default_Satz;
      var $Preise_inkl_MwSt;
      var $Positions_Nr;

      //Konstruktor
      function MwSt() {
      }

  }// End class MwSt

  // End of file-----------------------------------------------------------------------
?>
