<?php
  // Filename: USER_BESTELLUNG_AUFRUF.php
  //
  // Modul: Aufruf-Module - USER_BESTELLUNG
  //
  // Autoren: Jos Fontanil & Reto Glanzmann, Zuercher Hochschule Winterthur
  //
  // Zweck: Ueber dieses Modul werden die einzelnen Daten zur Darstellung geholt
  //
  // Sicherheitsstatus:                     *** USER ***
  //
  // Version: 1.2
  //
  // CVS-Version / Datum: $Id: USER_BESTELLUNG_AUFRUF.php,v 1.24 2002/10/04 10:46:13 fontajos Exp $
  //
  // -----------------------------------------------------------------------
  //
  // Lizenz
  // ======
  // PhPepperShop Shopsystem
  // Copyright (C) 2001  Reto Glanzmann, Jos Fontanil
  //
  // This program is free software; you can redistribute it and/or modify
  // it under the terms of the GNU General Public License as published by
  // the Free Software Foundation; either version 2 of the License, or
  // (at your option) any later version.
  //
  // This program is distributed in the hope that it will be useful,
  // but WITHOUT ANY WARRANTY; without even the implied warranty of
  // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  // GNU General Public License for more details.
  //
  // You should have received a copy of the GNU General Public License
  // along with this program; if not, write to the Free Software
  // Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  //
  // -----------------------------------------------------------------------  
  // Damit jedes andere Modul ueberpruefen kann ob dieses hier schon "included" ist
  // wird folgende Vairable auf true gesetzt (Name = Name des Moduls ohne .php)
  $USER_BESTELLUNG_AUFRUF = true;


  // -----------------------------------------------------------------------
  // Session_management: (Ueberpruefen ob eine Session_ID uebergeben wurde,
  // sonst eine neue erzeugen
  if(empty($mySession_ID)){
      session_name("mySession_ID");
      if (session_register("mySession_ID")) {
          /*Zu debug zwecken ausklammern
          echo "<B>USER_BESTELLUNG_AUFRUF.php: Meine <I>NEUE</I> Session_ID: Begin---".session_id()."---End Session_ID</B><BR><BR>";
          */
      }
      else {
         die("<html><head></head><body class='content'><P><H1 class='content'>USER_BESTELLUNG_AUFRUF.php: ACHTUNG session_register() = false, konnte keine Session_ID zuteilen</H1></P><BR><BR></body><html>");
      }
  }
  else {
      session_id($mySession_ID);
  }

  // -----------------------------------------------------------------------
  // include Pfad anpassen. Dabei werden die unterschiedlichen Delimiter-Zeichen fuer
  // Windows und UNIX/Linux beruecksichtigt. Danke fuer die Idee an Eduard Mas Walgram.
  // Windows --> Delimiter = Strichpunkt | UNIX/Linux --> Delimiter = Doppelpunkt
  if (PHP_OS == "WINNT" || PHP_OS == "WIN32" || strlen($HTTP_ENV_VARS["WINDIR"]) > 0) {$pd = ";";} else {$pd = ":";}
  ini_set("include_path", "./$pd../$pd../../$pd./Frameset$pd./shop$pd/usr/local/lib/php");

  // Einbinden der benoetigten Module (PHP-Scripts)
  // Bei Unklarheiten, siehe include-Hierarchie in der Dokumentation
  if (!isset($bestellung_def)) {include("bestellung_def.php");}
  if (!isset($USER_ARTIKEL_HANDLING)) {include("USER_ARTIKEL_HANDLING.php");}
  if (!isset($USER_BESTELLUNG_DARSTELLUNG)) {include("USER_BESTELLUNG_DARSTELLUNG.php");}

  // Damit der PhPepperShop auch mit der PHP-Einstellung Register Globals = Off funktioniert, werden die Request Arrays
  // $HTTP_GET_VARS und dann $HTTP_POST_VARS in die Standardsymboltabellen ausgelesen. (Post ueberschreibt dabei GET!)
  extract($HTTP_GET_VARS);
  extract($HTTP_POST_VARS);

// -----------------------------------------------------------------------
// Darstellung des HTML-"Headers"
?>

<HTML>
  <HEAD>
    <META HTTP-EQUIV="content-type" CONTENT="text/html;charset=iso-8859-1">
    <META HTTP-EQUIV="language" CONTENT="de">
    <META HTTP-EQUIV="author" CONTENT="Jose Fontanil & Reto Glanzmann">
    <META NAME="robots" CONTENT="all">
    <LINK REL=STYLESHEET HREF="shopstyles.css" TYPE="text/css">
    <TITLE>Shop</TITLE>
  </HEAD>

<?php

// -----------------------------------------------------------------------
// In den Formularen weiter unten hat man ein hidden-field, welches den Wert der
// Variable $darstellen uebermittelt. Dadurch wird entschieden welche Funktion
// oder Darstellung benutzt werden soll.

// -----------------------------------------------------------------------
// Anzeige des Warenkorbs im Content-Frame
// -----------------------------------------------------------------------
if ($darstellen == 1) {

    // Test ob Cookies eingeschaltet sind:
    checkifCookiesenabled("","",1,0);

    // Wenn ich noch keine Bestellung zugewiesen bekommen habe
    // so wird eine neue Bestellung mit meiner Session_ID eroeffnet
    test_create_Bestellung(session_id());

    // Bestellung aus DB laden
    $myBestellung = getBestellung(session_id());

    // Wenn die Bestellung keine Artikel enthaelt, soll eine Meldung ausgegeben werden,
    // anstatt den Warenkorb
    if ($myBestellung->artikelanzahl() == 0) {
        // 'Warenkorb ist leer' - Meldung ausgeben
        echo '<body class="content"><BR>'."\n";
        echo "<P><h3 class='content'><CENTER>Ihr Warenkorb ist leer!</CENTER></h3></P><BR>\n";
        echo '<h4 class="content"><CENTER>Bitte w&auml;hlen Sie zuerst einen Artikel</CENTER></h4>';
    }
    else {
        echo '<body class="content">'."\n";
        echo "<h3 class='content'>Inhalt Ihres Warenkorbs:</h3>\n";
        // Inhalt des Warenkorbs an Browser ausgeben, mit Loeschmoeglichkeit aber nicht als Admin
        darstellenBestellung($myBestellung, true, false); //Funktionsdefinition siehe USER_BESTELLUNG_DARSTELLUNG.php
        echo '<center><p><a class="content" href="USER_BESTELLUNG_1.php?darstellen=1&mySession_ID='.session_id().'" target="content"><img src="Buttons/bt_zur_kasse_1.gif" border="0"></a></p></center>'."\n";
    }
}

// -----------------------------------------------------------------------
// Einen Artikel in die eigene Bestellung legen
// -----------------------------------------------------------------------
else if($darstellen == 2) {

    // Test ob Cookies eingeschaltet sind:
    checkifCookiesenabled("","",1,1);

    // Wenn ich noch keine Bestellung zugewiesen bekommen habe
    // so wird eine neue Bestellung mit meiner Session_ID eroeffnet
    test_create_Bestellung(session_id());

    // Zusammenfassen der Daten in ein Artikel_info-Objekt (siehe bestellung_def.php)
    $myArtikel_info = new Artikel_info; //Objekt-Instantierung
    $myArtikel_info->Artikel_ID = $Artikel_ID;
    $myArtikel_info->Anzahl = $Anzahl;
    $myArtikel_info->Artikel_ID = $Name;
    $myArtikel_info->Anzahl = $Anzahl;
    $myArtikel_info->Artikel_ID = $Artikel_ID;

/*  // Sobald die Bestellungsdaten persisten gespeichert werden sollen, auskommentieren:
    // Aus Sicherheitsgruenden, werden alle weiteren Daten direkt aus der Datenbank ausgelesen. Das kosten zwar (ein klein wenig) Performance
    // dafuer werden keine Sensitiven Daten von einem Formular ausgewertet (koennten gefaelscht sein)
    $tempartikel = getArtikel($Artikel_ID);
    $myArtikel_info->Name = $tempartikel->name;
    $myArtikel_info->Artikel_Nr = $tempartikel->artikel_Nr;
    $myArtikel_info->Preis = $tempartikel->preis;
    $myArtikel_info->Gewicht = $tempartikel->gewicht;      */

    // Artikel-Stammdaten aus Datenbank auslesen (fuer die Beschreibungen der Zusatzfelder)
    $myArtikel = getArtikel($Artikel_ID);

    // allfaellig vorhandene Zusatztexte zu dem Artikel_info-Objekt hinzufuegen
    if (isset($Zusatzfeld)){
        $counter = 0;
        foreach ($Zusatzfeld as $Zusatztext){
            $feld_text = zusatzfeld_beschreibung($myArtikel->zusatzfelder_text[$counter]);
            $myArtikel_info->Zusatzfelder[$counter] = $feld_text[vor].' ';
            $myArtikel_info->Zusatzfelder[$counter].= $Zusatztext.' ';
            $myArtikel_info->Zusatzfelder[$counter].= $feld_text[nach];
            $counter++;
        } // end of foreach
    } // end of if

    $myArtikel = get_var_opt_preise($Artikel_ID);

    // Jetzt suchen wir die Optionen (falls vorhanden)
    // die vom Benutzer angewaehlt wurden und speichern
    // die Werte danach in einem Artikel_info-Objekt ab
    foreach(($myArtikel->getalloptionen()) as $key => $val) {
        $counter=1;
        $Optionsname = "Option1";
        for($i=0;$i < $myArtikel->optionenanzahl();$i++){
            if(urldecode($$Optionsname) == $key){
                $myArtikel_info->putoption(urldecode($$Optionsname), $val);
            }
            $counter++;
            $Optionsname = "Option$counter";
        }
    }
    // Dasselbe fuer die Variationen (falls gewaehlt)
    foreach(($myArtikel->getallvariationen()) as $keyname => $value) {
        $counter=1;
        for($i=0;$i<count($Variation);$i++){
            if(urldecode($Variation[$i]) == $keyname){
                $myArtikel_info->putvariation(urldecode($Variation[$i]), $value);
            } // end of if
        } // end of for
    } // end of foreach
    echo '<BODY class="content">';

    // Securitycheck, ob Artikel nicht in der Kategorie Nichtzugeordnet liegt.
    // Wenn doch, eine Fehlermeldung ausgeben und Artikel NICHT in die Bestellung aufnehmen
    $kategorien_array = getKategorie_eines_Artikels($myArtikel_info->Artikel_ID);
    $foundflag = false; // Dieses Flag wird true, sobald der Artikel in der Kategorie Nichtzugeordnet liegt
    foreach ($kategorien_array as $key=>$value) {
        if ($key == "Nichtzugeordnet") {
            $foundflag = true;
        }
    }
    if ($foundflag == true) {
        echo "<BR><P><H3 class='content'><center>";
        echo "FEHLER: Dieser Artikel ist im Moment nicht verf&uuml;gbar</center></H3></P><BR>";
        echo "<BR><BR><center><a class='content' href='USER_ARTIKEL_HANDLING_AUFRUF.php?darstellen=1&mySession_ID=".session_id()."&Kategorie_ID=$Kategorie_ID#Ziel".$Artikel_ID."'><IMG src='./Buttons/bt_zurueck.gif' border='0'></a>";
        echo "</body></html>";
        exit; // Programmabbruch
    }
    else {
        // Uebertragung der Artikeldaten in die Bestellung (DB)
        // Die Funktion addArtikel ist in USER_BESTELLUNG.php definiert
        addArtikel(session_id(),$myArtikel_info);
    }

    // Um den Zuruecklink zusammensetzen zu koennen, muss wegen den Unterkategorien
    // eine Fallunterscheidung vorgenommen werden
    if (urldecode($ParentKat) == "@leer@") {
        $ParentKat = "";
        $Ziel = "&Kategoriename=$Kategoriename#Ziel".$Artikel_ID;
    }
    else {
        $Ziel = "&Kategoriename=$Kategoriename&ParentKat=$ParentKat#Ziel".$Artikel_ID;
    }
    // Kunden-Bestaetigungs-Meldung, Navigation
    echo "<BR><P><H3 class='content'><center>";
    if($Anzahl > 1){echo "Die gew&auml;hlten ";}
    else{echo "Der gew&auml;hlte ";}
    echo "Artikel wurden in ihren Warenkorb gelegt</center></H3></P><BR>";
    echo "<BR><BR><center><a class='content' href='USER_ARTIKEL_HANDLING_AUFRUF.php?darstellen=1&mySession_ID=".session_id()."&Kategorie_ID=$Kategorie_ID#Ziel".$Artikel_ID."'><IMG src='./Buttons/bt_zurueck.gif' border='0'></a>";
    echo "&nbsp&nbsp<a class='content' href='./USER_BESTELLUNG_AUFRUF.php?darstellen=1&mySession_ID=".session_id()."'><IMG src='./Buttons/bt_warenkorb_zeigen.gif' border='0'></a>\n";
    echo '&nbsp&nbsp<a class="content" href="./USER_BESTELLUNG_1.php?darstellen=1&mySession_ID='.session_id().'" target="content"><img src="Buttons/bt_zur_kasse_1.gif" border="0"></a></center>'."\n";

}

// -----------------------------------------------------------------------
// Einen Artikel aus einer Bestellung loeschen
// -----------------------------------------------------------------------
else if ($darstellen == 3) {

    // Einen Artikel aus einer Bestellung loeschen
    del_B_Artikel($FK_Artikel_ID,$FK_Bestellungs_ID,$Variation,$Optionen,$Zusatztexte);

    // Kunden-Bestaetigungs-Meldung, Navigation
    echo '<BODY class="content"><BR>';
    echo "<P><H3 class='content'><CENTER>Der gewhlte Artikel wurde aus Ihrem Warenkorb entfernt!</CENTER></H3></P><BR><BR><BR>";
    echo '<CENTER><a class="content" href="USER_BESTELLUNG_AUFRUF.php?darstellen=1&mySession_ID='.session_id().'" target="content"><img src="Buttons/bt_warenkorb_zeigen.gif" border="0"></a></CENTER>'."\n";
}

// -----------------------------------------------------------------------
// Folgender Fall sollte eigentlich nie auftreten. Falls doch, wird eine
// fehlermeldung ausgegeben.
// -----------------------------------------------------------------------
else {
  echo "<h1 class='content'>fehlerhafter Aufruf!<BR><BR><a href='../index.php'><IMG src='./Buttons/bt_zurueck.gif' border='0'></a></h1>";
  }

  // Footer ausgeben (bei allen Darstellungen gleich!)
  ?>
</body>
</html>

<?php
// End of file-----------------------------------------------------------------------
?>
